/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.gradient;

import java.awt.Color;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.cytoscape.cg.internal.util.GradientEditor;
import org.cytoscape.cg.model.AbstractCustomGraphics2;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;

public abstract class AbstractGradientEditor<T extends AbstractCustomGraphics2<?>>
extends JPanel {
    private JLabel colorsLbl;
    private GradientEditor grEditor;
    private JPanel otherOptionsPnl;
    protected final T gradient;
    protected final CyServiceRegistrar serviceRegistrar;

    public AbstractGradientEditor(T gradient, CyServiceRegistrar serviceRegistrar) {
        this.gradient = gradient;
        this.serviceRegistrar = serviceRegistrar;
        this.init();
    }

    protected void init() {
        this.createLabels();
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        JSeparator sep = new JSeparator();
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.colorsLbl).addComponent(this.getGrEditor()).addComponent(sep).addComponent(this.getOtherOptionsPnl()));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.colorsLbl).addComponent(this.getGrEditor(), 100, 100, -2).addComponent(sep, -2, -1, -2).addComponent(this.getOtherOptionsPnl()));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.colorsLbl});
    }

    protected void createLabels() {
        this.colorsLbl = new JLabel("Colors:");
    }

    protected GradientEditor getGrEditor() {
        if (this.grEditor == null) {
            List<Float> fractions = ((AbstractCustomGraphics2)this.gradient).getList("cy_gradientFractions", Float.class);
            List<Color> colors = ((AbstractCustomGraphics2)this.gradient).getList("cy_gradientColors", Color.class);
            this.grEditor = new GradientEditor(fractions, colors, this.serviceRegistrar);
            this.grEditor.addActionListener(e -> this.updateGradient());
            if (fractions == null || fractions.size() < 2) {
                ((AbstractCustomGraphics2)this.gradient).set("cy_gradientFractions", this.getGrEditor().getPositions());
                ((AbstractCustomGraphics2)this.gradient).set("cy_gradientColors", this.getGrEditor().getColors());
            }
        }
        return this.grEditor;
    }

    protected JPanel getOtherOptionsPnl() {
        if (this.otherOptionsPnl == null) {
            this.otherOptionsPnl = new JPanel();
            this.otherOptionsPnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
            this.otherOptionsPnl.setVisible(false);
        }
        return this.otherOptionsPnl;
    }

    protected void updateGradient() {
        ((AbstractCustomGraphics2)this.gradient).set("cy_gradientFractions", this.getGrEditor().getPositions());
        ((AbstractCustomGraphics2)this.gradient).set("cy_gradientColors", this.getGrEditor().getColors());
    }
}

