/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts.ring;

import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.cytoscape.cg.internal.charts.AbstractChart;
import org.cytoscape.cg.internal.charts.ring.RingLayer;
import org.cytoscape.cg.model.Rotation;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;

public class RingChart
extends AbstractChart<RingLayer> {
    public static final String FACTORY_ID = "org.cytoscape.RingChart";
    public static final String DISPLAY_NAME = "Ring Chart";
    public static final String START_ANGLE = "cy_startAngle";
    public static final String HOLE_SIZE = "cy_holeSize";
    public static ImageIcon ICON;

    public RingChart(Map<String, Object> properties, CyServiceRegistrar serviceRegistrar) {
        super(DISPLAY_NAME, properties, serviceRegistrar);
    }

    public RingChart(RingChart chart, CyServiceRegistrar serviceRegistrar) {
        super(chart, serviceRegistrar);
    }

    public RingChart(String input, CyServiceRegistrar serviceRegistrar) {
        super(DISPLAY_NAME, input, serviceRegistrar);
    }

    public Image getRenderedImage() {
        return ICON.getImage();
    }

    @Override
    public String getId() {
        return FACTORY_ID;
    }

    @Override
    public Class<?> getSettingType(String key) {
        if (key.equalsIgnoreCase(START_ANGLE)) {
            return Double.class;
        }
        if (key.equalsIgnoreCase(HOLE_SIZE)) {
            return Double.class;
        }
        return super.getSettingType(key);
    }

    @Override
    protected RingLayer getLayer(CyRow row) {
        Double startAngle = this.get(START_ANGLE, Double.class, 0.0);
        Double hole = this.get(HOLE_SIZE, Double.class, 0.4);
        Rotation rotation = this.get("cy_rotation", Rotation.class, Rotation.ANTICLOCKWISE);
        List<String> labels = this.getItemLabels(row);
        Map<String, List<Double>> data = this.getData(row);
        List<Color> colors = this.getColors(data);
        Boolean showLabels = this.get("cy_showItemLabels", Boolean.class, false);
        float itemFontSize = RingChart.convertFontSize(this.get("cy_itemLabelFontSize", Integer.class, 1));
        Float borderWidth = this.get("cy_borderWidth", Float.class, Float.valueOf(0.25f));
        Color borderColor = this.get("cy_borderColor", Color.class, Color.DARK_GRAY);
        RingLayer layer = new RingLayer(data, labels, showLabels, itemFontSize, colors, borderWidth.floatValue(), borderColor, startAngle, hole, rotation);
        return layer;
    }

    static {
        try {
            ICON = new ImageIcon(ImageIO.read(RingChart.class.getClassLoader().getResource("images/charts/ring-chart.png")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

