/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts.heatmap;

import java.awt.Color;
import java.awt.Paint;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.cytoscape.cg.internal.charts.AbstractChartLayer;
import org.cytoscape.cg.internal.charts.LabelPosition;
import org.cytoscape.cg.internal.charts.util.ColorScale;
import org.cytoscape.cg.model.Orientation;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.RectangleInsets;

public class HeatMapLayer
extends AbstractChartLayer<XYZDataset> {
    private final Orientation orientation;
    private final String[] xLabels;
    private final String[] yLabels;
    private int maxYSize;

    public HeatMapLayer(Map<String, List<Double>> data, List<String> itemLabels, List<String> domainLabels, List<String> rangeLabels, boolean showDomainAxis, boolean showRangeAxis, LabelPosition domainLabelPosition, List<Color> colors, Color axisColor, float axisFontSize, List<Double> range, Orientation orientation) {
        super(data, itemLabels, domainLabels, rangeLabels, false, showDomainAxis, showRangeAxis, 0.0f, domainLabelPosition, colors, 0.0f, axisColor, axisFontSize, 0.0f, TRANSPARENT_COLOR, range);
        this.orientation = orientation;
        if (this.range == null) {
            this.range = HeatMapLayer.calculateRange(data.values(), false);
        }
        this.xLabels = new String[data.size()];
        int x = 0;
        for (Map.Entry<String, List<Double>> series : data.entrySet()) {
            String k = series.getKey();
            List<Double> zValues = series.getValue();
            this.maxYSize = Math.max(this.maxYSize, zValues.size());
            this.xLabels[x] = domainLabels != null && domainLabels.size() > x ? domainLabels.get(x) : k;
            ++x;
        }
        this.yLabels = new String[this.maxYSize];
        for (int i = 0; i < this.maxYSize; ++i) {
            this.yLabels[i] = rangeLabels != null && rangeLabels.size() > i ? rangeLabels.get(i) : "" + (i + 1);
        }
    }

    @Override
    protected XYZDataset createDataset() {
        DefaultXYZDataset dataset = new DefaultXYZDataset();
        int x = 0;
        for (Map.Entry series : this.data.entrySet()) {
            String k = (String)series.getKey();
            List zValues = (List)series.getValue();
            double[][] seriesData = new double[3][this.maxYSize];
            Arrays.fill(seriesData[0], (double)x);
            for (int y = 0; y < this.maxYSize; ++y) {
                double z = Double.NaN;
                if (zValues.size() > y && zValues.get(y) != null) {
                    z = (Double)zValues.get(y);
                }
                seriesData[1][y] = y;
                seriesData[2][y] = z;
            }
            dataset.addSeries((Comparable)((Object)k), seriesData);
            ++x;
        }
        return dataset;
    }

    @Override
    protected JFreeChart createChart(XYZDataset dataset) {
        PlotOrientation plotOrientation = this.orientation == Orientation.HORIZONTAL ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
        SymbolAxis xAxis = new SymbolAxis(null, this.xLabels);
        xAxis.setVisible(this.showDomainAxis);
        xAxis.setAxisLineVisible(false);
        xAxis.setTickMarksVisible(false);
        xAxis.setTickLabelFont(xAxis.getLabelFont().deriveFont(this.axisFontSize));
        xAxis.setTickLabelPaint((Paint)this.axisColor);
        xAxis.setVerticalTickLabels(this.domainLabelPosition != LabelPosition.STANDARD);
        xAxis.setLowerMargin(0.0);
        xAxis.setUpperMargin(0.0);
        SymbolAxis yAxis = new SymbolAxis(null, this.yLabels);
        yAxis.setVisible(this.showRangeAxis);
        yAxis.setAxisLineVisible(false);
        yAxis.setTickMarksVisible(false);
        yAxis.setTickLabelFont(yAxis.getLabelFont().deriveFont(this.axisFontSize));
        yAxis.setTickLabelPaint((Paint)this.axisColor);
        yAxis.setLowerMargin(0.0);
        yAxis.setUpperMargin(0.0);
        yAxis.setInverted(true);
        XYBlockRenderer renderer = new XYBlockRenderer();
        if (this.range != null && this.range.size() >= 2 && this.range.get(0) != null && this.range.get(1) != null) {
            int colorsSize = this.colors != null ? this.colors.size() : 0;
            Color upperColor = colorsSize > 0 ? (Color)this.colors.get(0) : Color.BLUE;
            Color zeroColor = colorsSize > 1 ? (Color)this.colors.get(1) : Color.WHITE;
            Color lowerColor = colorsSize > 2 ? (Color)this.colors.get(2) : Color.RED;
            Color nanColor = colorsSize > 3 ? (Color)this.colors.get(3) : Color.GRAY;
            ColorScale scale = new ColorScale((Double)this.range.get(0), (Double)this.range.get(1), lowerColor, zeroColor, upperColor, nanColor);
            renderer.setPaintScale((PaintScale)scale);
        }
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setDomainAxis((ValueAxis)xAxis);
        plot.setDomainAxisLocation(AxisLocation.TOP_OR_LEFT);
        plot.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT);
        plot.setOutlineVisible(false);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setBackgroundPaint((Paint)TRANSPARENT_COLOR);
        plot.setInsets(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        plot.setAxisOffset(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        plot.setOrientation(plotOrientation);
        JFreeChart chart = new JFreeChart(null, (Plot)plot);
        chart.removeLegend();
        chart.setBorderVisible(false);
        chart.setBackgroundPaint((Paint)TRANSPARENT_COLOR);
        chart.setPadding(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        return chart;
    }
}

