/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.cytoscape.cg.internal.charts.LabelPosition;
import org.cytoscape.cg.internal.paint.TexturePaintFactory;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyRow;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.Cy2DGraphicLayer;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.Plot;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public abstract class AbstractChartLayer<T extends Dataset>
implements Cy2DGraphicLayer {
    public static final int MAX_IMG_RESOLUTION = 0x300000;
    public static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    public static final Color DEFAULT_ITEM_BG_COLOR = Color.LIGHT_GRAY;
    protected final Map<String, List<Double>> data;
    protected final List<String> itemLabels;
    protected final List<String> domainLabels;
    protected final List<String> rangeLabels;
    protected final boolean showItemLabels;
    protected final boolean showDomainAxis;
    protected final boolean showRangeAxis;
    protected final LabelPosition domainLabelPosition;
    protected final List<Color> colors;
    protected final float borderWidth;
    protected final Color borderColor;
    protected Color labelColor = Color.DARK_GRAY;
    protected float itemFontSize;
    protected float axisWidth;
    protected Color axisColor;
    protected float axisFontSize;
    protected List<Double> range;
    protected Rectangle2D bounds;
    protected Rectangle2D scaledBounds;
    private JFreeChart chart;
    protected BufferedImage img;
    protected TexturePaint paint;

    protected AbstractChartLayer(Map<String, List<Double>> data, List<String> itemLabels, List<String> domainLabels, List<String> rangeLabels, boolean showItemLabels, boolean showDomainAxis, boolean showRangeAxis, float itemFontSize, LabelPosition domainLabelPosition, List<Color> colors, float axisWidth, Color axisColor, float axisFontSize, float borderWidth, Color borderColor, List<Double> range) {
        this.data = data;
        this.itemLabels = itemLabels;
        this.domainLabels = domainLabels;
        this.rangeLabels = rangeLabels;
        this.showItemLabels = showItemLabels;
        this.showDomainAxis = showDomainAxis;
        this.showRangeAxis = showRangeAxis;
        this.itemFontSize = itemFontSize;
        this.domainLabelPosition = domainLabelPosition;
        this.colors = colors;
        this.axisWidth = axisWidth;
        this.axisColor = axisColor;
        this.axisFontSize = axisFontSize;
        this.borderWidth = borderWidth;
        this.borderColor = borderColor;
        this.range = range;
        double size = 32.0;
        Rectangle2D.Double bounds = new Rectangle2D.Double(-size / 2.0, -size / 2.0, size, size);
        this.bounds = this.scaledBounds = bounds;
    }

    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public CustomGraphicLayer transform(AffineTransform xform) {
        this.bounds = xform.createTransformedShape(this.bounds).getBounds2D();
        return this;
    }

    public void draw(Graphics2D g, Shape shape, CyNetworkView networkView, View<? extends CyIdentifiable> view) {
        this.draw(g);
    }

    public void draw(Graphics2D g, CyTableView tableView, CyColumn column, CyRow row) {
        this.draw(g);
    }

    public TexturePaint getPaint(Rectangle2D r) {
        if (this.img == null || this.paint == null || !r.equals(this.scaledBounds)) {
            this.img = this.createImage(r);
            this.paint = new TexturePaintFactory(this.img).getPaint(new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
        }
        this.scaledBounds = r;
        return this.paint;
    }

    protected void draw(Graphics2D g) {
        Graphics2D g2 = (Graphics2D)g.create();
        double scale = 2.0;
        Rectangle2D.Double newBounds = new Rectangle2D.Double(this.bounds.getX() * scale, this.bounds.getY() * scale, this.bounds.getWidth() * scale, this.bounds.getHeight() * scale);
        double invScale = 1.0 / scale;
        g2.scale(invScale, invScale);
        Composite comp = g2.getComposite();
        if (comp instanceof AlphaComposite) {
            float alpha = ((AlphaComposite)comp).getAlpha();
            JFreeChart fc = this.getChart();
            Plot plot = fc.getPlot();
            plot.setForegroundAlpha(alpha);
            fc.draw(g2, (Rectangle2D)newBounds);
        } else {
            this.getChart().draw(g2, (Rectangle2D)newBounds);
        }
        g2.dispose();
    }

    protected JFreeChart getChart() {
        if (this.chart == null) {
            T dataset = this.createDataset();
            this.chart = this.createChart(dataset);
        }
        return this.chart;
    }

    protected BufferedImage createImage(Rectangle2D r) {
        Rectangle nr = this.validateBounds(r);
        return this.getChart().createBufferedImage(nr.width, nr.height, 2, null);
    }

    protected Rectangle validateBounds(Rectangle2D r) {
        int h;
        int w;
        double resolution;
        double minScale = 1.0;
        double minSize = 140.0;
        if ((r.getWidth() < minSize || r.getHeight() < minSize) && r.getWidth() > 4.0 && r.getHeight() > 4.0) {
            minScale = minSize / Math.min(r.getWidth(), r.getHeight());
        }
        if ((resolution = (double)(w = (int)Math.round(r.getWidth() * minScale)) * (double)(h = (int)Math.round(r.getHeight() * minScale))) > 3145728.0) {
            double f = Math.sqrt(3145728.0 / resolution);
            w = (int)Math.round((double)w * f);
            h = (int)Math.round((double)h * f);
        }
        if (w <= 0) {
            w = 1;
        }
        if (h <= 0) {
            h = 1;
        }
        return new Rectangle(w, h);
    }

    protected CategoryLabelPositions getCategoryLabelPosition() {
        if (this.domainLabelPosition == LabelPosition.DOWN_45) {
            return CategoryLabelPositions.DOWN_45;
        }
        if (this.domainLabelPosition == LabelPosition.DOWN_90) {
            return CategoryLabelPositions.DOWN_90;
        }
        if (this.domainLabelPosition == LabelPosition.UP_45) {
            return CategoryLabelPositions.UP_45;
        }
        if (this.domainLabelPosition == LabelPosition.UP_90) {
            return CategoryLabelPositions.UP_90;
        }
        return CategoryLabelPositions.STANDARD;
    }

    protected abstract T createDataset();

    protected abstract JFreeChart createChart(T var1);

    /*
     * WARNING - void declaration
     */
    public static CategoryDataset createCategoryDataset(Map<String, List<Double>> data, boolean listIsSeries, List<String> labels) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        if (listIsSeries && (labels == null || labels.isEmpty())) {
            int size = 0;
            for (List list : data.values()) {
                size = Math.max(size, list.size());
            }
            labels = AbstractChartLayer.createDefaultLabels(size);
        }
        int count = 0;
        for (String string : data.keySet()) {
            List<Double> values = data.get(string);
            for (int i = 0; i < values.size(); ++i) {
                void var6_9;
                Double v = values.get(i);
                Object k = "#" + (i + 1);
                if (listIsSeries) {
                    if (labels != null && labels.size() > i) {
                        k = labels.get(i);
                    }
                    dataset.addValue((Number)v, (Comparable)var6_9, (Comparable)k);
                    continue;
                }
                if (labels != null && labels.size() > count) {
                    String string2 = labels.get(count);
                }
                dataset.addValue((Number)v, (Comparable)k, (Comparable)var6_9);
            }
            ++count;
        }
        return dataset;
    }

    public static PieDataset createPieDataset(List<Double> values) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                Double v = values.get(i);
                String k = "#" + (i + 1);
                dataset.setValue((Comparable)((Object)k), (Number)v);
            }
        }
        return dataset;
    }

    public static List<String> createDefaultLabels(int size) {
        ArrayList<String> labels = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            labels.add("#" + (i + 1));
        }
        return labels;
    }

    public static List<Double> calculateRange(Collection<List<Double>> lists, boolean stacked) {
        ArrayList<Double> range = new ArrayList<Double>();
        if (lists != null && !lists.isEmpty()) {
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            for (List<Double> values : lists) {
                double sum = 0.0;
                if (values != null) {
                    for (double v : values) {
                        if (Double.isNaN(v)) continue;
                        if (stacked) {
                            sum += v;
                            continue;
                        }
                        min = Math.min(min, v);
                        max = Math.max(max, v);
                    }
                    if (stacked) {
                        min = Math.min(min, sum);
                        max = Math.max(max, sum);
                    }
                }
                if (min == Double.POSITIVE_INFINITY || max == Double.NEGATIVE_INFINITY) continue;
                range.add(min);
                range.add(max);
            }
        }
        return range;
    }
}

