/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.util;

import org.cytoscape.analyzer.util.Msgs;
import org.cytoscape.analyzer.util.NetworkInspection;
import org.cytoscape.analyzer.util.NetworkInterpretation;

public class NetworkStatus {
    private static final String BR = "<br>";
    private static final NetworkInterpretation[] allTrs = new NetworkInterpretation[33];
    public static final NetworkStatus DIR_PAIRED_N_N;
    public static final NetworkStatus DIR_PAIRED_S_N;
    public static final NetworkStatus DIR_PAIRED_N_S;
    public static final NetworkStatus DIR_PAIRED_S_S;
    public static final NetworkStatus DIR_UNPAIRED_N_N;
    public static final NetworkStatus DIR_UNPAIRED_S_N;
    public static final NetworkStatus DIR_UNPAIRED_N_S;
    public static final NetworkStatus DIR_UNPAIRED_S_S;
    public static final NetworkStatus MIXED_PAIRED_N_N;
    public static final NetworkStatus MIXED_PAIRED_S_N;
    public static final NetworkStatus MIXED_PAIRED_N_S;
    public static final NetworkStatus MIXED_PAIRED_S_S;
    public static final NetworkStatus MIXED_UNPAIRED_N_N;
    public static final NetworkStatus MIXED_UNPAIRED_S_N;
    public static final NetworkStatus MIXED_UNPAIRED_N_S;
    public static final NetworkStatus MIXED_UNPAIRED_S_S;
    public static final NetworkStatus UNDIR_N_N;
    public static final NetworkStatus UNDIR_S_N;
    public static final NetworkStatus UNDIR_N_S;
    public static final NetworkStatus UNDIR_S_S;
    private String description;
    private NetworkInterpretation[] interprs;
    private int defaultInterprIndex;

    public static NetworkStatus getStatus(NetworkInspection aInsp) {
        int loops = (aInsp.dirLoops ? 1 : 0) + (aInsp.undirLoops ? 2 : 0);
        if (aInsp.dir) {
            if (aInsp.uniqueDir) {
                if (aInsp.undir) {
                    switch (loops) {
                        case 0: {
                            return MIXED_UNPAIRED_N_N;
                        }
                        case 1: {
                            return MIXED_UNPAIRED_S_N;
                        }
                        case 2: {
                            return MIXED_UNPAIRED_N_S;
                        }
                    }
                    return MIXED_UNPAIRED_S_S;
                }
                switch (loops) {
                    case 0: {
                        return DIR_UNPAIRED_N_N;
                    }
                    case 1: {
                        return DIR_UNPAIRED_S_N;
                    }
                    case 2: {
                        return DIR_UNPAIRED_N_S;
                    }
                }
                return DIR_UNPAIRED_S_S;
            }
            if (aInsp.undir) {
                switch (loops) {
                    case 0: {
                        return MIXED_PAIRED_N_N;
                    }
                    case 1: {
                        return MIXED_PAIRED_S_N;
                    }
                    case 2: {
                        return MIXED_PAIRED_N_S;
                    }
                }
                return MIXED_PAIRED_S_S;
            }
            switch (loops) {
                case 0: {
                    return DIR_PAIRED_N_N;
                }
                case 1: {
                    return DIR_PAIRED_S_N;
                }
                case 2: {
                    return DIR_PAIRED_N_S;
                }
            }
            return DIR_PAIRED_S_S;
        }
        switch (loops) {
            case 0: {
                return UNDIR_N_N;
            }
            case 1: {
                return UNDIR_S_N;
            }
            case 2: {
                return UNDIR_N_S;
            }
        }
        return UNDIR_S_S;
    }

    public String getDescription() {
        return this.description;
    }

    public NetworkInterpretation[] getInterpretations() {
        return this.interprs;
    }

    public int getDefaultInterprIndex() {
        return this.defaultInterprIndex;
    }

    private NetworkStatus(String aDescription, NetworkInterpretation aInterpr) {
        this(aDescription, new NetworkInterpretation[]{aInterpr}, 0);
    }

    private NetworkStatus(String aDescription, NetworkInterpretation aInterpr1, NetworkInterpretation aInterpr2, int aDefIndex) {
        this(aDescription, new NetworkInterpretation[]{aInterpr1, aInterpr2}, aDefIndex);
    }

    private NetworkStatus(String aDescription, NetworkInterpretation aInterpr1, NetworkInterpretation aInterpr2, NetworkInterpretation aInterpr3, int aDefIndex) {
        this(aDescription, new NetworkInterpretation[]{aInterpr1, aInterpr2, aInterpr3}, aDefIndex);
    }

    private NetworkStatus(String aDescription, NetworkInterpretation[] aInterprs, int aDefIndex) {
        this.description = "<html><b>" + aDescription + "</b>";
        this.interprs = aInterprs;
        this.defaultInterprIndex = aDefIndex;
    }

    static {
        NetworkStatus.allTrs[0] = new NetworkInterpretation(true);
        NetworkStatus.allTrs[1] = new NetworkInterpretation(false, true);
        NetworkStatus.allTrs[2] = new NetworkInterpretation(false, false);
        NetworkStatus.allTrs[3] = new NetworkInterpretation(true);
        NetworkStatus.allTrs[4] = new NetworkInterpretation(false, true);
        NetworkStatus.allTrs[5] = new NetworkInterpretation(false, false);
        NetworkStatus.allTrs[6] = new NetworkInterpretation(true, true);
        NetworkStatus.allTrs[7] = new NetworkInterpretation(false, true);
        NetworkStatus.allTrs[8] = new NetworkInterpretation(false, false);
        NetworkStatus.allTrs[9] = new NetworkInterpretation(true, true);
        NetworkStatus.allTrs[10] = new NetworkInterpretation(false, true);
        NetworkStatus.allTrs[11] = new NetworkInterpretation(false, false);
        NetworkStatus.allTrs[12] = new NetworkInterpretation(true);
        NetworkStatus.allTrs[13] = new NetworkInterpretation(false);
        NetworkStatus.allTrs[14] = new NetworkInterpretation(true);
        NetworkStatus.allTrs[15] = new NetworkInterpretation(false);
        NetworkStatus.allTrs[16] = new NetworkInterpretation(true, true);
        NetworkStatus.allTrs[17] = new NetworkInterpretation(false);
        NetworkStatus.allTrs[18] = new NetworkInterpretation(true, true);
        NetworkStatus.allTrs[19] = new NetworkInterpretation(false);
        NetworkStatus.allTrs[20] = new NetworkInterpretation(false, true);
        NetworkStatus.allTrs[21] = new NetworkInterpretation(false, false);
        NetworkStatus.allTrs[22] = new NetworkInterpretation(false, true);
        NetworkStatus.allTrs[23] = new NetworkInterpretation(false, false);
        NetworkStatus.allTrs[24] = new NetworkInterpretation(false, true);
        NetworkStatus.allTrs[25] = new NetworkInterpretation(false, false);
        NetworkStatus.allTrs[26] = new NetworkInterpretation(false, true);
        NetworkStatus.allTrs[27] = new NetworkInterpretation(false, false);
        NetworkStatus.allTrs[28] = new NetworkInterpretation(Msgs.NI_FORCETU, false);
        NetworkStatus.allTrs[29] = new NetworkInterpretation(Msgs.NI_FORCETU, false);
        NetworkStatus.allTrs[30] = new NetworkInterpretation(Msgs.NI_FORCETU, false);
        NetworkStatus.allTrs[31] = new NetworkInterpretation(Msgs.NI_FORCETU, false);
        NetworkStatus.allTrs[32] = new NetworkInterpretation(Msgs.NI_FORCETU, false);
        DIR_PAIRED_N_N = new NetworkStatus(Msgs.NI_DIRPAIRED, allTrs[0], allTrs[1], allTrs[2], 1);
        DIR_PAIRED_S_N = new NetworkStatus(Msgs.NI_DIRPAIRED + BR + Msgs.NI_LOOPSDIR, allTrs[3], allTrs[4], allTrs[5], 1);
        DIR_PAIRED_N_S = new NetworkStatus(Msgs.NI_DIRPAIRED + BR + Msgs.NI_LOOPSUNDIR, allTrs[6], allTrs[7], allTrs[8], 1);
        DIR_PAIRED_S_S = new NetworkStatus(Msgs.NI_DIRPAIRED + BR + Msgs.NI_LOOPSBOTH, allTrs[9], allTrs[10], allTrs[11], 1);
        DIR_UNPAIRED_N_N = new NetworkStatus(Msgs.NI_DIRUNPAIRED, allTrs[12], allTrs[13], 1);
        DIR_UNPAIRED_S_N = new NetworkStatus(Msgs.NI_DIRUNPAIRED + BR + Msgs.NI_LOOPSDIR, allTrs[14], allTrs[15], 1);
        DIR_UNPAIRED_N_S = new NetworkStatus(Msgs.NI_DIRUNPAIRED + BR + Msgs.NI_LOOPSUNDIR, allTrs[16], allTrs[17], 1);
        DIR_UNPAIRED_S_S = new NetworkStatus(Msgs.NI_DIRUNPAIRED + BR + Msgs.NI_LOOPSBOTH, allTrs[18], allTrs[19], 1);
        MIXED_PAIRED_N_N = new NetworkStatus(Msgs.NI_MIXED + BR + Msgs.NI_PAIRED, allTrs[20], allTrs[21], 0);
        MIXED_PAIRED_S_N = new NetworkStatus(Msgs.NI_MIXED + BR + Msgs.NI_PAIRED + BR + Msgs.NI_LOOPSDIR, allTrs[22], allTrs[23], 0);
        MIXED_PAIRED_N_S = new NetworkStatus(Msgs.NI_MIXED + BR + Msgs.NI_PAIRED + BR + Msgs.NI_LOOPSUNDIR, allTrs[24], allTrs[25], 0);
        MIXED_PAIRED_S_S = new NetworkStatus(Msgs.NI_MIXED + BR + Msgs.NI_UNPAIRED + BR + Msgs.NI_LOOPSBOTH, allTrs[26], allTrs[27], 0);
        MIXED_UNPAIRED_N_N = new NetworkStatus(Msgs.NI_MIXED + BR + Msgs.NI_UNPAIRED, allTrs[28]);
        MIXED_UNPAIRED_S_N = new NetworkStatus(Msgs.NI_MIXED + BR + Msgs.NI_UNPAIRED + BR + Msgs.NI_LOOPSDIR, allTrs[29]);
        MIXED_UNPAIRED_N_S = new NetworkStatus(Msgs.NI_MIXED + BR + Msgs.NI_UNPAIRED + BR + Msgs.NI_LOOPSUNDIR, allTrs[30]);
        MIXED_UNPAIRED_S_S = new NetworkStatus(Msgs.NI_MIXED + BR + Msgs.NI_UNPAIRED + BR + Msgs.NI_LOOPSBOTH, allTrs[31]);
        UNDIR_N_N = new NetworkStatus(Msgs.NI_UNDIR, allTrs[32]);
        UNDIR_S_N = new NetworkStatus(Msgs.NI_UNDIR + BR + Msgs.NI_LOOPSDIR, allTrs[29]);
        UNDIR_N_S = new NetworkStatus(Msgs.NI_UNDIR + BR + Msgs.NI_LOOPSUNDIR, allTrs[32]);
        UNDIR_S_S = new NetworkStatus(Msgs.NI_UNDIR + BR + Msgs.NI_LOOPSBOTH, allTrs[31]);
    }
}

