/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.util;

import java.util.HashMap;
import java.util.Map;

public class JSONUtils {
    public static Map<String, Object> jsonToMap(String json) {
        String[] lines = json.split("\n");
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String line : lines) {
            String[] tokens;
            if (line.trim().length() == 0 || (tokens = line.split(":")).length < 2) continue;
            String key = JSONUtils.clean(tokens[0]);
            Object val = JSONUtils.clean(tokens[1]);
            String s = val.toString();
            if (JSONUtils.isDouble(s) && !JSONUtils.isInteger(s)) {
                val = Double.parseDouble(val.toString());
            }
            map.put(key, val);
        }
        return map;
    }

    private static String clean(String in) {
        String trimmed = in.trim();
        if (trimmed.charAt(0) == '\"') {
            trimmed = trimmed.substring(1);
        }
        if (trimmed.endsWith(",")) {
            trimmed = trimmed.substring(0, trimmed.length() - 1);
        }
        if (trimmed.endsWith("\"")) {
            trimmed = trimmed.substring(0, trimmed.length() - 1);
        }
        return trimmed;
    }

    private static boolean isDouble(String input) {
        try {
            Double.parseDouble(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isInteger(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

