/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.tasks;

import java.util.Collection;
import java.util.List;
import org.cytoscape.analyzer.AnalyzerManager;
import org.cytoscape.analyzer.tasks.AnalyzeNetworkTask;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkCollectionTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;

public class AnalyzeNetworkTaskFactory
extends AbstractNetworkCollectionTaskFactory
implements TaskFactory {
    private final CySwingApplication app;
    private final CyServiceRegistrar reg;
    private final AnalyzerManager mgr;
    private boolean degreeOnly = false;

    public AnalyzeNetworkTaskFactory(CyServiceRegistrar registrar, CySwingApplication desktop, AnalyzerManager manager) {
        this.reg = registrar;
        this.app = desktop;
        this.mgr = manager;
    }

    public TaskIterator createTaskIterator(Collection<CyNetwork> networks) {
        return new TaskIterator(new Task[]{new AnalyzeNetworkTask(networks, this.reg, this.app, this.mgr)});
    }

    public TaskIterator createTaskIterator() {
        CyApplicationManager appMgr = (CyApplicationManager)this.reg.getService(CyApplicationManager.class);
        return new TaskIterator(new Task[]{new AnalyzeNetworkTask(null, this.reg, this.app, this.mgr)});
    }

    public boolean isReady() {
        return true;
    }

    public static boolean isDirected(Collection<CyNetwork> networks) {
        for (CyNetwork net : networks) {
            if (!AnalyzeNetworkTaskFactory.isDirected(net)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDirected(CyNetwork current) {
        List edges = current.getEdgeList();
        int ct = Math.min(100, edges.size());
        for (int i = 0; i < ct; ++i) {
            if (!((CyEdge)edges.get(i)).isDirected()) continue;
            return true;
        }
        return false;
    }
}

