/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer;

import java.util.List;
import org.cytoscape.analyzer.AnalyzerManager;
import org.cytoscape.analyzer.ConnComponentAnalyzer;
import org.cytoscape.analyzer.NetworkAnalyzer;
import org.cytoscape.analyzer.util.AttributeSetup;
import org.cytoscape.analyzer.util.ConnectedComponentInfo;
import org.cytoscape.analyzer.util.NetworkInterpretation;
import org.cytoscape.analyzer.util.PathLengthData;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;

public class UndirNetworkAnalyzer
extends NetworkAnalyzer {
    @Override
    public boolean isDirected() {
        return false;
    }

    public UndirNetworkAnalyzer(CyNetwork aNetwork, NetworkInterpretation aInterpr, CySwingApplication app, AnalyzerManager mgr) {
        super(aNetwork, aInterpr, app, mgr);
        AttributeSetup.createUndirectedNodeAttributes(aNetwork.getTable(CyNode.class, "LOCAL_ATTRS"));
        AttributeSetup.createEdgeBetweennessAttribute(aNetwork.getTable(CyEdge.class, "LOCAL_ATTRS"));
    }

    @Override
    public void computeAll() {
        long time = System.currentTimeMillis();
        this.analysisStarting();
        ConnComponentAnalyzer cca = new ConnComponentAnalyzer(this, this.network);
        List<ConnectedComponentInfo> components = cca.findComponents();
        int connectedComponentCount = components.size();
        ConnectedComponentInfo largest = cca.findLargestComponent();
        this.stats.set("ncc", connectedComponentCount);
        for (ConnectedComponentInfo aCompInfo : components) {
            aCompInfo.analyze(this.network, cca);
            ++this.progress;
        }
        this.stats.copyStats(largest.getStats());
        this.analysisFinished();
        time = System.currentTimeMillis() - time;
        this.stats.set("time", (double)time / 1000.0);
        this.doOutput();
    }

    public static double computeCC(int[] neighbors, int numNodes, int[] edges, int[] edgeOffsets) {
        boolean[] isNeighbor = new boolean[numNodes];
        for (int neighbor : neighbors) {
            isNeighbor[neighbor] = true;
        }
        int edgeCount = 0;
        for (int neighbor : neighbors) {
            int firstEdge = edgeOffsets[neighbor];
            int lastEdge = edgeOffsets[neighbor + 1];
            for (int ei = firstEdge; ei < lastEdge; ++ei) {
                if (!isNeighbor[edges[ei]]) continue;
                ++edgeCount;
            }
        }
        long neighborsCount = neighbors.length;
        return (double)edgeCount / (double)(neighborsCount * (neighborsCount - 1L));
    }

    public static PathLengthData computeSPandSN(int node, int numNodes, int[] edges, int[] edgeOffsets, long[] outSharedNeighborsHist, long[] outSPathLengths) {
        boolean[] visited = new boolean[numNodes];
        visited[node] = true;
        int[] frontier = new int[numNodes];
        int[] nextFrontier = new int[numNodes];
        frontier[0] = node;
        int frontierSize = 1;
        int i = 1;
        boolean[] startNeighbors = new boolean[numNodes];
        int firstNeighbor = edgeOffsets[node];
        int lastNeighbor = edgeOffsets[node + 1];
        for (int ni = firstNeighbor; ni < lastNeighbor; ++ni) {
            startNeighbors[edges[ni]] = true;
        }
        PathLengthData result = new PathLengthData();
        while (frontierSize > 0) {
            int nextFrontierSize = 0;
            for (int fi = 0; fi < frontierSize; ++fi) {
                int index;
                int n = frontier[fi];
                int firstNeighbor2 = edgeOffsets[n];
                int lastNeighbor2 = edgeOffsets[n + 1];
                int sharedNeighbors = 0;
                for (int ni = firstNeighbor2; ni < lastNeighbor2; ++ni) {
                    int neighbor = edges[ni];
                    if (startNeighbors[neighbor]) {
                        ++sharedNeighbors;
                    }
                    if (visited[neighbor]) continue;
                    visited[neighbor] = true;
                    nextFrontier[nextFrontierSize++] = neighbor;
                }
                int n2 = index = i > 2 ? sharedNeighbors : 0;
                outSharedNeighborsHist[n2] = outSharedNeighborsHist[n2] + 1L;
            }
            for (int nfi = 0; nfi < nextFrontierSize; ++nfi) {
                frontier[nfi] = nextFrontier[nfi];
                result.addSPL(i);
            }
            if (i < outSPathLengths.length) {
                int n = i;
                outSPathLengths[n] = outSPathLengths[n] + (long)nextFrontierSize;
            }
            frontierSize = nextFrontierSize;
            ++i;
        }
        return result;
    }

    public static void computeNBandEB(int source, int numNodes, int[] edges, int[] edgeOffsets, int[] edgeIDs, double[] outNodeBetweenness, long[] outStress, double[] outEdgeBetweenness) {
        int[] Q = new int[numNodes];
        Q[0] = source;
        int Qlow = 0;
        int Qhigh = 1;
        int[] P = new int[edges.length];
        int[] Pedge = new int[edges.length];
        int[] Pcount = new int[numNodes];
        int[] Dedge = new int[edges.length];
        int[] Dcount = new int[numNodes];
        int[] sigma = new int[numNodes];
        sigma[source] = 1;
        int[] d = new int[numNodes];
        for (int i = 0; i < numNodes; ++i) {
            d[i] = -1;
        }
        d[source] = 0;
        double[] delta = new double[numNodes];
        long[] stressDependency = new long[numNodes];
        double[] edgeDependency = new double[edges.length];
        while (Qlow < Qhigh) {
            int node = Q[Qlow++];
            int firstEdge = edgeOffsets[node];
            int lastEdge = edgeOffsets[node + 1];
            int dnodeplus = d[node] + 1;
            int sigmanode = sigma[node];
            for (int ei = firstEdge; ei < lastEdge; ++ei) {
                int neighbor = edges[ei];
                if (d[neighbor] < 0) {
                    Q[Qhigh++] = neighbor;
                    d[neighbor] = dnodeplus;
                }
                if (d[neighbor] != dnodeplus) continue;
                int n = neighbor;
                sigma[n] = sigma[n] + sigmanode;
                int pi = edgeOffsets[neighbor] + Pcount[neighbor];
                P[pi] = node;
                Pedge[pi] = edgeIDs[ei];
                int n2 = neighbor;
                Pcount[n2] = Pcount[n2] + 1;
                int di = edgeOffsets[node] + Dcount[node];
                Dedge[di] = edgeIDs[ei];
                int n3 = node;
                Dcount[n3] = Dcount[n3] + 1;
            }
        }
        while (Qhigh > 0) {
            int w = Q[--Qhigh];
            int firstP = edgeOffsets[w];
            int lastP = firstP + Pcount[w];
            double sigmaw = 1.0 / (double)sigma[w];
            double deltaw = delta[w];
            long stressw = stressDependency[w];
            double Dbetweenness = 0.0;
            int firstD = edgeOffsets[w];
            int lastD = firstD + Dcount[w];
            boolean isLeaf = lastD - firstD == 0;
            for (int di = firstD; di < lastD; ++di) {
                Dbetweenness += edgeDependency[Dedge[di]];
            }
            for (int pi = firstP; pi < lastP; ++pi) {
                int v = P[pi];
                double sigmavw = (double)sigma[v] * sigmaw;
                int n = v;
                delta[n] = delta[n] + sigmavw * (1.0 + deltaw);
                int n4 = v;
                stressDependency[n4] = stressDependency[n4] + (1L + stressw);
                double edgeBetweenness = 0.0;
                int edgeID = Pedge[pi];
                edgeBetweenness = isLeaf ? sigmavw : (1.0 + Dbetweenness) * sigmavw;
                edgeDependency[edgeID] = edgeBetweenness;
                int n5 = edgeID;
                outEdgeBetweenness[n5] = outEdgeBetweenness[n5] + edgeBetweenness;
            }
            if (w == source) continue;
            int n = w;
            outNodeBetweenness[n] = outNodeBetweenness[n] + deltaw;
            int n6 = w;
            outStress[n6] = outStress[n6] + (long)sigma[w] * stressw;
        }
    }

    public static double computeNormFactor(int count) {
        return count > 2 ? 1.0 / (double)((count - 1) * (count - 2)) : 1.0;
    }

    public static double computeTC(int node, int numNodes, int[] edges, int[] edgeOffsets) {
        int ni;
        boolean[] commNNodes = new boolean[numNodes];
        int commNNodesSize = 0;
        boolean[] isNeighbor = new boolean[numNodes];
        int tc = 0;
        int firstEdge = edgeOffsets[node];
        int lastEdge = edgeOffsets[node + 1];
        for (ni = firstEdge; ni < lastEdge; ++ni) {
            isNeighbor[edges[ni]] = true;
        }
        for (ni = firstEdge; ni < lastEdge; ++ni) {
            int neighbor = edges[ni];
            int firstNEdge = edgeOffsets[neighbor];
            int lastNEdge = edgeOffsets[neighbor + 1];
            for (int nni = firstNEdge; nni < lastNEdge; ++nni) {
                int nneighbor = edges[nni];
                if (nneighbor == node) continue;
                ++tc;
                if (commNNodes[nneighbor]) continue;
                commNNodes[nneighbor] = true;
                ++commNNodesSize;
                if (!isNeighbor[nneighbor]) continue;
                ++tc;
            }
        }
        return (double)tc / ((double)commNNodesSize * (double)(lastEdge - firstEdge));
    }
}

