/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer;

import java.util.Properties;
import org.cytoscape.analyzer.AnalyzerManager;
import org.cytoscape.analyzer.tasks.AnalyzeNetworkTaskFactory;
import org.cytoscape.analyzer.tasks.RemoveDupEdgesAction;
import org.cytoscape.analyzer.tasks.RemoveSelfLoopsAction;
import org.cytoscape.analyzer.tasks.VersionTaskFactory;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.NetworkCollectionTaskFactory;
import org.cytoscape.work.TaskFactory;
import org.osgi.framework.BundleContext;

public class CyActivator
extends AbstractCyActivator {
    public void start(BundleContext bc) {
        CyServiceRegistrar registrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        CySwingApplication desktop = (CySwingApplication)this.getService(bc, CySwingApplication.class);
        CyApplicationManager mgr = (CyApplicationManager)this.getService(bc, CyApplicationManager.class);
        CyNetworkManager netmgr = (CyNetworkManager)this.getService(bc, CyNetworkManager.class);
        AnalyzerManager manager = new AnalyzerManager(registrar, desktop);
        Properties props = new Properties();
        props.clear();
        props.put("id", "analyzeNetworkTaskFactory");
        props.put("title", "Analyze Network");
        props.put("commandNamespace", "analyzer");
        props.put("command", "analyze");
        props.put("commandDescription", "Calculate statistics on the current network");
        props.put("commandLongDescription", "Run algorithms to calculate a set of statistics on the network, and write those statistics to the node and network tables.");
        props.put("commandExampleJSON", "{   \"networkTitle\": \"galFiltered.sif (undirected)\",   \"nodeCount\": \"330\",  \"avNeighbors\": \"2.167\"}");
        props.put("commandSupportsJSON", "true");
        props.put("enableFor", "network");
        AnalyzeNetworkTaskFactory analyzeNetworkTaskFactory = new AnalyzeNetworkTaskFactory(registrar, desktop, manager);
        this.registerService(bc, (Object)analyzeNetworkTaskFactory, NetworkCollectionTaskFactory.class, props);
        props.put("preferredMenu", "Tools");
        props.put("menuGravity", "9.1");
        props.put("inMenuBar", "true");
        props.put("inToolBar", "false");
        this.registerService(bc, (Object)analyzeNetworkTaskFactory, TaskFactory.class, props);
        RemoveDupEdgesAction remDupEdgesAction = new RemoveDupEdgesAction(mgr, desktop, netmgr);
        RemoveSelfLoopsAction removeSelfLoopsAction = new RemoveSelfLoopsAction(mgr, desktop, netmgr);
        this.registerService(bc, (Object)remDupEdgesAction, CyAction.class, new Properties());
        this.registerService(bc, (Object)removeSelfLoopsAction, CyAction.class, new Properties());
        String version = bc.getBundle().getVersion().toString();
        VersionTaskFactory versionTask = new VersionTaskFactory(version);
        props = new Properties();
        props.setProperty("commandNamespace", "analyzer");
        props.setProperty("command", "version");
        props.setProperty("commandDescription", "Display the analyzer version");
        props.setProperty("commandLongDescription", "Display the version of the analyzer app.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"version\":\"4.3.1\"}");
        this.registerService(bc, (Object)versionTask, TaskFactory.class, props);
    }
}

