/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.cytoscape.analyzer.ResultsPanel;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.TaskObserver;

public class AnalyzerManager
implements SessionLoadedListener {
    private final TaskManager<?, ?> taskManager;
    private final CyServiceRegistrar registrar;
    private final HashMap<String, String> settings;
    private final CySwingApplication application;
    private ResultsPanel resultsPanel;
    boolean isRegistered = false;

    public AnalyzerManager(CyServiceRegistrar reg, CySwingApplication desktop) {
        this.registrar = reg;
        this.taskManager = (TaskManager)this.registrar.getService(TaskManager.class);
        this.application = desktop;
        this.resultsPanel = new ResultsPanel(this);
        this.settings = new HashMap();
    }

    public void handleEvent(SessionLoadedEvent e) {
        this.unregisterResultsPanel();
    }

    public void makeDegreeHisto() {
        CommandExecutorTaskFactory commandTF = (CommandExecutorTaskFactory)this.registrar.getService(CommandExecutorTaskFactory.class);
        TaskManager taskManager = (TaskManager)this.registrar.getService(TaskManager.class);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x", "Degree");
        TaskIterator ti = commandTF.createTaskIterator("cychart", "histogram", args, null);
        taskManager.execute(ti);
    }

    public void makeBetweenScatter() {
        CommandExecutorTaskFactory commandTF = (CommandExecutorTaskFactory)this.registrar.getService(CommandExecutorTaskFactory.class);
        TaskManager taskManager = (TaskManager)this.registrar.getService(TaskManager.class);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x", "Degree");
        args.put("y", "BetweennessCentrality");
        TaskIterator ti = commandTF.createTaskIterator("cychart", "scatter", args, null);
        taskManager.execute(ti);
    }

    public void makeClosenessClusterScatter() {
        CommandExecutorTaskFactory commandTF = (CommandExecutorTaskFactory)this.registrar.getService(CommandExecutorTaskFactory.class);
        TaskManager taskManager = (TaskManager)this.registrar.getService(TaskManager.class);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x", "ClosenessCentrality");
        args.put("y", "BetweennessCentrality");
        TaskIterator ti = commandTF.createTaskIterator("cychart", "scatter", args, null);
        taskManager.execute(ti);
    }

    public void registerResultsPanel() {
        if (this.isRegistered) {
            return;
        }
        this.registerService(this.resultsPanel, CytoPanelComponent.class, new Properties());
        this.registerService(this.resultsPanel, SetCurrentNetworkListener.class, new Properties());
        CytoPanel panel = this.application.getCytoPanel(CytoPanelName.EAST);
        panel.setState(CytoPanelState.DOCK);
        this.isRegistered = true;
        this.resultsPanel.enableButtons(true);
    }

    public void unregisterResultsPanel() {
        if (!this.isRegistered) {
            return;
        }
        this.unregisterService(this.resultsPanel, CytoPanelComponent.class);
        this.unregisterService(this.resultsPanel, SetCurrentNetworkListener.class);
        this.resultsPanel.enableButtons(false);
        this.isRegistered = false;
    }

    public String getSetting(String setting) {
        return this.settings.get(setting);
    }

    public void setSetting(String setting, double value) {
        this.setSetting(setting, String.valueOf(value));
    }

    public void setSetting(String setting, int value) {
        this.setSetting(setting, String.valueOf(value));
    }

    public void setSetting(String setting, boolean value) {
        this.setSetting(setting, String.valueOf(value));
    }

    public void setSetting(String setting, String value) {
        this.settings.put(setting, value);
    }

    public void executeCommand(String namespace, String command, Map<String, Object> args, boolean synchronous) {
        this.executeCommand(namespace, command, args, null, synchronous);
    }

    public void executeCommand(String namespace, String command, Map<String, Object> args) {
        this.executeCommand(namespace, command, args, null, false);
    }

    public void executeCommand(String namespace, String command, Map<String, Object> args, TaskObserver observer, boolean synchronous) {
    }

    public void executeTasks(TaskIterator tasks) {
        this.taskManager.execute(tasks);
    }

    public void executeTasks(TaskIterator tasks, TaskObserver observer) {
        this.taskManager.execute(tasks, observer);
    }

    public void executeTasks(TaskFactory factory) {
        this.taskManager.execute(factory.createTaskIterator());
    }

    public void executeTasks(TaskFactory factory, TaskObserver observer) {
        this.taskManager.execute(factory.createTaskIterator(), observer);
    }

    public <S> S getService(Class<S> serviceClass) {
        return (S)this.registrar.getService(serviceClass);
    }

    public <S> S getService(Class<S> serviceClass, String filter) {
        return (S)this.registrar.getService(serviceClass, filter);
    }

    public void registerService(Object service, Class<?> serviceClass, Properties props) {
        this.registrar.registerService(service, serviceClass, props);
    }

    public void unregisterService(Object service, Class<?> serviceClass) {
        this.registrar.unregisterService(service, serviceClass);
    }
}

