/*
 * Decompiled with CFR 0.152.
 */
package csapps.layout.algorithms.hierarchicalLayout;

class LayerOrderNode
implements Comparable<LayerOrderNode> {
    private int index;
    private boolean isDummy;
    private int degree;
    private int priority;
    private int layer;

    public LayerOrderNode(int index, boolean isDummy, int degree, int layer) {
        this.index = index;
        this.isDummy = isDummy;
        this.degree = degree;
        this.layer = layer;
        this.priority = isDummy ? 20 : (degree < 5 ? 5 : (degree < 10 ? 10 : 15));
    }

    @Override
    public int compareTo(LayerOrderNode second) {
        if (this.layer != second.layer) {
            return this.layer - second.layer;
        }
        if (this.isDummy && !second.isDummy) {
            return -1;
        }
        if (!this.isDummy && second.isDummy) {
            return 1;
        }
        return second.degree - this.degree;
    }

    public int GetIndex() {
        return this.index;
    }

    public int GetPriority() {
        return this.priority;
    }

    public boolean GetIsDummy() {
        return this.isDummy;
    }
}

