/*
 * Decompiled with CFR 0.152.
 */
package csapps.layout.algorithms.hierarchicalLayout;

import csapps.layout.algorithms.hierarchicalLayout.Edge;
import csapps.layout.algorithms.hierarchicalLayout.IntSortNode;
import csapps.layout.algorithms.hierarchicalLayout.TwinDoubleSortNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Stack;

public class Graph {
    private int nodecount;
    private Edge[] edge;
    private LinkedList<Integer>[] edgesFrom;
    private LinkedList<Integer>[] edgesTo;
    private int dummyNodesStart;
    private boolean acyclic;
    private boolean reduced;
    static int MAX_ADJACENT_EXCHANGE_PASSES = 5;
    private byte[] status;
    private int[] d;
    private int[] low;
    private int[] pred;
    private int time;
    private HashMap<Integer, LinkedList<Integer>> neighbours;
    private Stack<Edge> edgesStack;
    private LinkedList<LinkedList<Integer>> biComponents;

    public Graph(int a_nodecount, Edge[] a_edge) {
        int x;
        this.nodecount = a_nodecount;
        this.edge = new Edge[a_edge.length];
        this.edgesFrom = new LinkedList[this.nodecount];
        this.edgesTo = new LinkedList[this.nodecount];
        this.dummyNodesStart = a_nodecount;
        for (x = 0; x < this.nodecount; ++x) {
            this.edgesFrom[x] = new LinkedList();
            this.edgesTo[x] = new LinkedList();
        }
        for (x = 0; x < a_edge.length; ++x) {
            int edgeFrom = a_edge[x].getFrom();
            int edgeTo = a_edge[x].getTo();
            if (edgeFrom < 0 || edgeFrom >= this.nodecount || edgeTo < 0 || edgeTo >= this.nodecount) {
                throw new IllegalArgumentException("Edge refered to node outside of valid range: From=" + edgeFrom + " To=" + edgeTo + " with nodecount=" + this.nodecount + "\n");
            }
            this.edge[x] = new Edge(edgeFrom, edgeTo);
            this.edgesFrom[edgeFrom].add(edgeTo);
            this.edgesTo[edgeTo].add(edgeFrom);
        }
        this.acyclic = false;
        this.reduced = false;
        this.status = new byte[this.nodecount];
        this.d = new int[this.nodecount];
        this.low = new int[this.nodecount];
        this.pred = new int[this.nodecount];
        this.time = 0;
        this.neighbours = new HashMap();
        this.edgesStack = new Stack();
        this.biComponents = new LinkedList();
    }

    public Edge GetTheEdge(int a, int b) {
        for (int i = 0; i < this.edge.length; ++i) {
            if (this.edge[i].getFrom() != a || this.edge[i].getTo() != b) continue;
            return this.edge[i];
        }
        return null;
    }

    public LinkedList<Integer>[] GetEdgesFrom() {
        return this.edgesFrom;
    }

    public LinkedList<Integer>[] GetEdgesTo() {
        return this.edgesTo;
    }

    public Edge[] GetEdges() {
        return this.edge;
    }

    public Graph(Reader r) throws IOException {
        BufferedReader br = new BufferedReader(r);
        String linebuf = br.readLine();
        this.nodecount = Integer.parseInt(linebuf);
        LinkedList<Edge> edges = new LinkedList<Edge>();
        this.edgesFrom = new LinkedList[this.nodecount];
        this.edgesTo = new LinkedList[this.nodecount];
        for (int x = 0; x < this.nodecount; ++x) {
            this.edgesFrom[x] = new LinkedList();
            this.edgesTo[x] = new LinkedList();
        }
        linebuf = br.readLine();
        while (!linebuf.equals(".")) {
            String[] vertex = linebuf.trim().split("\\s+");
            if (vertex.length != 2) {
                throw new NumberFormatException("Illegal input to Graph constructor:\nExpected two integers, received: " + linebuf + "\n");
            }
            int edgeFrom = Integer.parseInt(vertex[0]);
            int edgeTo = Integer.parseInt(vertex[1]);
            edges.add(new Edge(edgeFrom, edgeTo));
            this.edgesFrom[edgeFrom].add(edgeTo);
            this.edgesTo[edgeTo].add(edgeFrom);
            linebuf = br.readLine();
        }
        this.edge = new Edge[edges.size()];
        edges.toArray(this.edge);
        this.acyclic = false;
        this.reduced = false;
    }

    public String toString() {
        String retval = "Graph with " + this.nodecount + " nodes.\nEdges:\n";
        for (int x = 0; x < this.edge.length; ++x) {
            retval = retval + "From " + this.edge[x].getFrom() + " To " + this.edge[x].getTo() + "\n";
        }
        return retval;
    }

    public void setAcyclic(boolean q) {
        this.acyclic = q;
    }

    public void setReduced(boolean q) {
        this.reduced = q;
    }

    public void setDummyNodesStart(int dummyStart) {
        this.dummyNodesStart = dummyStart;
    }

    public int getDummyNodesStart() {
        return this.dummyNodesStart;
    }

    public int getNodecount() {
        return this.nodecount;
    }

    public int getEdgecount() {
        return this.edge.length;
    }

    public boolean hasEdge(int edgeFrom, int edgeTo) {
        return this.edgesFrom[edgeFrom].contains(edgeTo);
    }

    public Graph getGraphWithoutOneOrTwoCycles() {
        LinkedList<Edge> newEdges = new LinkedList<Edge>();
        for (int x = 0; x < this.edge.length; ++x) {
            int edgeTo;
            int edgeFrom = this.edge[x].getFrom();
            if (edgeFrom == (edgeTo = this.edge[x].getTo()) || this.hasEdge(edgeTo, edgeFrom)) continue;
            newEdges.add(this.edge[x]);
        }
        Edge[] newEdge = new Edge[newEdges.size()];
        newEdges.toArray(newEdge);
        return new Graph(this.nodecount, newEdge);
    }

    public Graph getGraphWithoutMultipleEdges() {
        LinkedList<Edge> newEdges = new LinkedList<Edge>();
        for (int edgeFrom = 0; edgeFrom < this.nodecount; ++edgeFrom) {
            HashSet<Integer> seenEdgeTo = new HashSet<Integer>();
            for (Integer edgeTo : this.edgesFrom[edgeFrom]) {
                if (seenEdgeTo.contains(edgeTo)) continue;
                newEdges.add(new Edge(edgeFrom, edgeTo));
                seenEdgeTo.add(edgeTo);
            }
        }
        Edge[] newEdge = new Edge[newEdges.size()];
        newEdges.toArray(newEdge);
        return new Graph(this.nodecount, newEdge);
    }

    public int[] componentIndex() {
        int x;
        int[] cI = new int[this.nodecount];
        LinkedList[] componentNode = new LinkedList[this.nodecount];
        for (x = 0; x < this.nodecount; ++x) {
            cI[x] = x;
            componentNode[x] = new LinkedList();
            componentNode[x].add(x);
        }
        for (x = 0; x < this.edge.length; ++x) {
            int larger;
            if (cI[this.edge[x].getFrom()] == cI[this.edge[x].getTo()]) continue;
            int smaller = cI[this.edge[x].getFrom()];
            if (smaller > (larger = cI[this.edge[x].getTo()])) {
                int tmp = smaller;
                smaller = larger;
                larger = tmp;
            }
            Iterator iter = componentNode[larger].iterator();
            while (iter.hasNext()) {
                int nodeIndex = (Integer)iter.next();
                cI[nodeIndex] = smaller;
                componentNode[smaller].add(nodeIndex);
            }
        }
        int[] contiguousMap = new int[this.nodecount];
        int topSeen = 0;
        int topAssigned = 0;
        for (x = 0; x < this.nodecount; ++x) {
            if (cI[x] > topSeen) {
                topSeen = cI[x];
                contiguousMap[cI[x]] = ++topAssigned;
            }
            cI[x] = contiguousMap[cI[x]];
        }
        return cI;
    }

    private void ArtPoints(int current) {
        this.status[current] = 1;
        this.d[current] = ++this.time;
        this.low[current] = this.time;
        Iterator iter = this.neighbours.get(current).iterator();
        while (iter.hasNext()) {
            int neigh = (Integer)iter.next();
            if (this.status[neigh] == 0) {
                this.pred[neigh] = current;
                this.edgesStack.push(new Edge(current, neigh));
                this.ArtPoints(neigh);
                this.low[current] = Math.min(this.low[current], this.low[neigh]);
                if (this.pred[current] == -1) {
                    Iterator rootChildren = this.neighbours.get(current).iterator();
                    int noChildren = 0;
                    while (rootChildren.hasNext()) {
                        ++noChildren;
                        rootChildren.next();
                    }
                    if (noChildren >= 2) {
                        LinkedList<Integer> singleComponent = new LinkedList<Integer>();
                        singleComponent.add(this.edgesStack.peek().getTo());
                        while (this.edgesStack.peek().getFrom() != current) {
                            Edge currEdge = this.edgesStack.pop();
                            if (!singleComponent.contains(currEdge.getFrom())) {
                                singleComponent.add(currEdge.getFrom());
                            }
                            if (singleComponent.contains(currEdge.getTo())) continue;
                            singleComponent.add(currEdge.getTo());
                        }
                        this.edgesStack.pop();
                        if (!singleComponent.contains(current)) {
                            singleComponent.add(current);
                        }
                        this.biComponents.add(singleComponent);
                    }
                } else if (this.low[neigh] >= this.d[current]) {
                    LinkedList<Integer> singleComponent = new LinkedList<Integer>();
                    singleComponent.add(this.edgesStack.peek().getTo());
                    while (this.edgesStack.peek().getFrom() != current) {
                        Edge currEdge = this.edgesStack.pop();
                        if (!singleComponent.contains(currEdge.getFrom())) {
                            singleComponent.add(currEdge.getFrom());
                        }
                        if (singleComponent.contains(currEdge.getTo())) continue;
                        singleComponent.add(currEdge.getTo());
                    }
                    this.edgesStack.pop();
                    if (!singleComponent.contains(current)) {
                        singleComponent.add(current);
                    }
                    this.biComponents.add(singleComponent);
                }
                this.status[neigh] = 1;
                this.d[neigh] = ++this.time;
                this.low[neigh] = this.time;
                continue;
            }
            if (neigh == this.pred[current]) continue;
            this.low[current] = Math.min(this.low[current], this.d[neigh]);
        }
    }

    public int[][] biconnectedComponents() {
        int i;
        for (i = 0; i < this.nodecount; ++i) {
            this.neighbours.put(i, new LinkedList());
        }
        for (i = 0; i < this.edge.length; ++i) {
            this.neighbours.get(this.edge[i].getFrom()).add(this.edge[i].getTo());
        }
        for (i = 0; i < this.nodecount; ++i) {
            this.status[i] = 0;
        }
        this.pred[0] = -1;
        this.ArtPoints(0);
        int[][] bc = new int[this.biComponents.size()][];
        for (int i2 = 0; i2 < this.biComponents.size(); ++i2) {
            bc[i2] = new int[this.biComponents.get(i2).size()];
            for (int j = 0; j < this.biComponents.get(i2).size(); ++j) {
                bc[i2][j] = this.biComponents.get(i2).get(j);
            }
        }
        return bc;
    }

    public Graph[] partition(int[] partitionIndex, int[] nodeRenumber) {
        int x;
        if (partitionIndex.length != this.nodecount || nodeRenumber.length != this.nodecount) {
            throw new IllegalArgumentException("partitionGraph received wrong sized argument");
        }
        int[] partitionNodecount = new int[this.nodecount];
        int numberOfPartitions = 0;
        for (x = 0; x < this.nodecount; ++x) {
            int n = partitionIndex[x];
            partitionNodecount[n] = partitionNodecount[n] + 1;
            if (nodeRenumber[x] != 0) continue;
            ++numberOfPartitions;
        }
        LinkedList[] partitionEdges = new LinkedList[numberOfPartitions];
        for (x = 0; x < numberOfPartitions; ++x) {
            partitionEdges[x] = new LinkedList();
        }
        for (x = 0; x < this.edge.length; ++x) {
            Edge e = this.edge[x];
            if (partitionIndex[e.getFrom()] != partitionIndex[e.getTo()]) continue;
            partitionEdges[partitionIndex[e.getFrom()]].add(new Edge(nodeRenumber[e.getFrom()], nodeRenumber[e.getTo()]));
        }
        Graph[] retval = new Graph[numberOfPartitions];
        for (x = 0; x < numberOfPartitions; ++x) {
            Edge[] pe = new Edge[partitionEdges[x].size()];
            partitionEdges[x].toArray(pe);
            retval[x] = new Graph(partitionNodecount[x], pe);
        }
        return retval;
    }

    public int[] getCycleEliminationVertexPriority() {
        int x;
        int[] priority = new int[this.nodecount];
        int[] inDegree = new int[this.nodecount];
        int[] outDegree = new int[this.nodecount];
        if (this.nodecount == 0) {
            return priority;
        }
        if (this.nodecount == 1) {
            priority[0] = 0;
            return priority;
        }
        Graph simplifiedGraph = this.getGraphWithoutMultipleEdges().getGraphWithoutOneOrTwoCycles();
        if (this.nodecount == 2) {
            if (simplifiedGraph.edgesFrom[0].size() == 0) {
                priority[0] = 1;
                priority[1] = 0;
            } else {
                priority[0] = 0;
                priority[1] = 1;
            }
            return priority;
        }
        LinkedList<Integer>[] simpleEdgesTo = simplifiedGraph.edgesTo;
        LinkedList<Integer>[] simpleEdgesFrom = simplifiedGraph.edgesFrom;
        LinkedList[] bucket = new LinkedList[2 * this.nodecount - 3];
        LinkedList<Integer> Sr = new LinkedList<Integer>();
        LinkedList<Integer> Sl = new LinkedList<Integer>();
        int bucketOffset = this.nodecount - 2;
        for (x = 0; x < bucket.length; ++x) {
            bucket[x] = new LinkedList();
        }
        LinkedList sink = bucket[0];
        LinkedList source = bucket[bucket.length - 1];
        for (x = 0; x < this.nodecount; ++x) {
            inDegree[x] = simpleEdgesTo[x].size();
            outDegree[x] = simpleEdgesFrom[x].size();
            if (outDegree[x] == 0) {
                sink.add(x);
                continue;
            }
            if (inDegree[x] == 0) {
                source.add(x);
                continue;
            }
            bucket[outDegree[x] - inDegree[x] + bucketOffset].add(x);
        }
        int scanBucketStart = bucket.length - 2;
        for (int nodesRemaining = this.nodecount; nodesRemaining != 0; --nodesRemaining) {
            int dest;
            int outDeg;
            int inDeg;
            int adjindex;
            Integer adj;
            Integer u;
            boolean goRight = false;
            if (sink.size() > 0) {
                u = (Integer)sink.removeFirst();
                goRight = true;
            } else if (source.size() > 0) {
                u = (Integer)source.removeFirst();
            } else {
                while (bucket[scanBucketStart].size() == 0) {
                    --scanBucketStart;
                }
                u = (Integer)bucket[scanBucketStart].removeFirst();
            }
            LinkedList<Integer> simpleAdjacents = simpleEdgesTo[u];
            while (simpleAdjacents.size() > 0) {
                adj = simpleAdjacents.removeFirst();
                adjindex = adj;
                inDeg = inDegree[adjindex];
                outDeg = outDegree[adjindex];
                if (outDeg == 0) {
                    sink.remove(adj);
                } else if (inDeg == 0) {
                    source.remove(adj);
                } else {
                    bucket[outDeg - inDeg + bucketOffset].remove(adj);
                }
                simpleEdgesFrom[adjindex].remove(u);
                int n = adjindex;
                outDegree[n] = outDegree[n] - 1;
                if (--outDeg == 0) {
                    sink.add(adj);
                    continue;
                }
                if (inDeg == 0) {
                    source.add(adj);
                    continue;
                }
                dest = outDeg - inDeg + bucketOffset;
                bucket[dest].add(adj);
                if (dest <= scanBucketStart) continue;
                scanBucketStart = dest;
            }
            simpleAdjacents = simpleEdgesFrom[u];
            while (simpleAdjacents.size() > 0) {
                adj = simpleAdjacents.removeFirst();
                adjindex = adj;
                inDeg = inDegree[adjindex];
                outDeg = outDegree[adjindex];
                if (outDeg == 0) {
                    sink.remove(adj);
                } else if (inDeg == 0) {
                    source.remove(adj);
                } else {
                    bucket[outDeg - inDeg + bucketOffset].remove(adj);
                }
                simpleEdgesTo[adjindex].remove(u);
                int n = adjindex;
                inDegree[n] = inDegree[n] - 1;
                --inDeg;
                if (outDeg == 0) {
                    sink.add(adj);
                    continue;
                }
                if (inDeg == 0) {
                    source.add(adj);
                    continue;
                }
                dest = outDeg - inDeg + bucketOffset;
                bucket[dest].add(adj);
                if (dest <= scanBucketStart) continue;
                scanBucketStart = dest;
            }
            if (goRight) {
                Sr.addFirst(u);
                continue;
            }
            Sl.addLast(u);
        }
        x = 0;
        Iterator iter = Sl.iterator();
        while (iter.hasNext()) {
            priority[x++] = (Integer)iter.next();
        }
        iter = Sr.iterator();
        while (iter.hasNext()) {
            priority[x++] = (Integer)iter.next();
        }
        return priority;
    }

    public Graph getGraphWithoutCycles(int[] cycleEliminationPriority) {
        int x;
        int[] priorityIndex = new int[this.nodecount];
        for (x = 0; x < cycleEliminationPriority.length; ++x) {
            priorityIndex[cycleEliminationPriority[x]] = x;
        }
        LinkedList<Edge> newEdges = new LinkedList<Edge>();
        for (x = 0; x < this.edge.length; ++x) {
            int edgeTo;
            int edgeFrom = this.edge[x].getFrom();
            if (edgeFrom == (edgeTo = this.edge[x].getTo())) continue;
            if (priorityIndex[edgeFrom] > priorityIndex[edgeTo]) {
                int temp = edgeFrom;
                edgeFrom = edgeTo;
                edgeTo = temp;
                newEdges.add(new Edge(edgeFrom, edgeTo));
                continue;
            }
            newEdges.add(this.edge[x]);
        }
        Edge[] newEdge = new Edge[newEdges.size()];
        newEdges.toArray(newEdge);
        Graph dag = new Graph(this.nodecount, newEdge);
        dag.acyclic = true;
        return dag;
    }

    public Graph getReducedGraph(int[] topologicalOrder) {
        if (topologicalOrder.length != this.nodecount) {
            throw new IllegalArgumentException("topological ordering of nodes does not match nodecount");
        }
        if (!this.acyclic) {
            throw new RuntimeException("attempt to compute transitive reduction on a graph with cycles");
        }
        int[] priorityIndex = new int[this.nodecount];
        for (int x = 0; x < topologicalOrder.length; ++x) {
            priorityIndex[topologicalOrder[x]] = x;
        }
        LinkedList<Edge> newEdges = new LinkedList<Edge>();
        LinkedHashSet[] descendants = new LinkedHashSet[this.nodecount];
        for (int nodeIndex = topologicalOrder.length - 1; nodeIndex >= 0; --nodeIndex) {
            int daughterId;
            int nodeId = topologicalOrder[nodeIndex];
            LinkedHashSet<Integer> daughters = new LinkedHashSet<Integer>(this.edgesFrom[nodeId]);
            Object[] daughter = new IntSortNode[daughters.size()];
            int daughterIndex = 0;
            Iterator iter = daughters.iterator();
            while (iter.hasNext()) {
                daughterId = (Integer)iter.next();
                daughter[daughterIndex++] = new IntSortNode(priorityIndex[daughterId], daughterId);
            }
            Arrays.sort(daughter);
            for (daughterIndex = 0; daughterIndex < daughter.length; ++daughterIndex) {
                daughterId = ((IntSortNode)daughter[daughterIndex]).getSecond();
                Integer daughterIdObj = daughterId;
                if (descendants[nodeId] == null) {
                    descendants[nodeId] = descendants[daughterId] == null ? new LinkedHashSet() : new LinkedHashSet(descendants[daughterId]);
                    newEdges.add(new Edge(nodeId, daughterId));
                } else {
                    if (!descendants[nodeId].contains(daughterIdObj)) {
                        newEdges.add(new Edge(nodeId, daughterId));
                    }
                    if (descendants[daughterId] != null) {
                        descendants[nodeId].addAll(descendants[daughterId]);
                    }
                }
                descendants[nodeId].add(daughterIdObj);
            }
        }
        Edge[] newEdge = new Edge[newEdges.size()];
        newEdges.toArray(newEdge);
        Graph reducedGraph = new Graph(this.nodecount, newEdge);
        reducedGraph.acyclic = true;
        reducedGraph.reduced = true;
        return reducedGraph;
    }

    public Graph getReducedGraph() {
        int[] cycleEliminationPriority = this.getCycleEliminationVertexPriority();
        Graph dag = this.getGraphWithoutCycles(cycleEliminationPriority);
        return dag.getReducedGraph(cycleEliminationPriority);
    }

    public static boolean orderedSetComparison(int[] set1, int[] set2) {
        if (set2 == null) {
            return false;
        }
        if (set1 == null) {
            return true;
        }
        int smallerSize = Math.min(set1.length, set2.length);
        for (int x = 0; x < smallerSize; ++x) {
            if (set1[x] >= set2[x]) continue;
            return true;
        }
        return set1.length < set2.length;
    }

    public int[] getVertexLayers() {
        int x;
        if (!this.reduced) {
            throw new RuntimeException("attempt to compute vertex layers in a non-reduced graph");
        }
        int LAYER_WIDTH = Math.max((int)Math.pow(this.nodecount, 0.6366197723675814), 10);
        int[] vertexLabel = new int[this.nodecount];
        for (x = 0; x < this.nodecount; ++x) {
            vertexLabel[x] = 0;
        }
        int[][] parentLabels = new int[this.nodecount][];
        LinkedHashSet<Integer> eligible = new LinkedHashSet<Integer>(this.nodecount * 3 / 2);
        boolean[] onEligible = new boolean[this.nodecount];
        for (x = 0; x < this.nodecount; ++x) {
            if (this.edgesTo[x].size() == 0) {
                eligible.add(x);
                onEligible[x] = true;
                continue;
            }
            onEligible[x] = false;
        }
        int nextLabel = 1;
        while (eligible.size() > 0) {
            Iterator iter = eligible.iterator();
            Integer minElement = (Integer)iter.next();
            int minId = minElement;
            while (iter.hasNext()) {
                int nextId = (Integer)iter.next();
                if (!Graph.orderedSetComparison(parentLabels[nextId], parentLabels[minId])) continue;
                minId = nextId;
            }
            vertexLabel[minId] = nextLabel++;
            eligible.remove(minElement);
            onEligible[minId] = false;
            iter = this.edgesFrom[minId].iterator();
            block4: while (iter.hasNext()) {
                int childId = (Integer)iter.next();
                if (onEligible[childId]) continue;
                Iterator cpIter = this.edgesTo[childId].iterator();
                int[] childParentList = new int[this.edgesTo[childId].size()];
                int childParentListIndex = 0;
                while (cpIter.hasNext()) {
                    int childParentId = (Integer)cpIter.next();
                    if (vertexLabel[childParentId] == 0) continue block4;
                    childParentList[childParentListIndex++] = childParentId;
                }
                Arrays.sort(childParentList);
                parentLabels[childId] = new int[childParentList.length];
                int parentLabelsIndex = 0;
                for (x = childParentList.length - 1; x >= 0; --x) {
                    parentLabels[childId][parentLabelsIndex++] = vertexLabel[childParentList[x]];
                }
                eligible.add(childId);
                onEligible[childId] = true;
            }
        }
        int[] vertexLayer = new int[this.nodecount];
        for (x = 0; x < this.nodecount; ++x) {
            vertexLayer[x] = 0;
        }
        eligible.clear();
        LinkedHashSet<Integer> nominated = new LinkedHashSet<Integer>();
        for (x = 0; x < this.nodecount; ++x) {
            if (this.edgesFrom[x].size() != 0) continue;
            eligible.add(x);
        }
        int currentLayer = 1;
        while (eligible.size() > 0) {
            int currentLayerSize = 0;
            Object[] eligibleSort = new Integer[eligible.size()];
            eligible.toArray(eligibleSort);
            Arrays.sort(eligibleSort);
            for (int eligibleIndex = eligibleSort.length - 1; eligibleIndex >= 0 && currentLayerSize != LAYER_WIDTH; --eligibleIndex) {
                int nodeId = (Integer)eligibleSort[eligibleIndex];
                vertexLayer[nodeId] = currentLayer;
                ++currentLayerSize;
                block11: for (Integer parentObj : this.edgesTo[nodeId]) {
                    int parentId = parentObj;
                    if (vertexLayer[parentId] > 0) continue;
                    Iterator pcIter = this.edgesFrom[parentId].iterator();
                    while (pcIter.hasNext()) {
                        int parentChildId = (Integer)pcIter.next();
                        if (vertexLayer[parentChildId] != 0) continue;
                        continue block11;
                    }
                    nominated.add(parentObj);
                }
                eligible.remove(nodeId);
                nominated.remove(nodeId);
            }
            ++currentLayer;
            eligible.addAll(nominated);
        }
        return vertexLayer;
    }

    public int[] getHorizontalPosition(int[] vertexLayer) {
        double dtmp;
        int tmp;
        int rightIndex;
        int leftIndex;
        double[] rightSet;
        double[] leftSet;
        int revCrossCount;
        int nowCrossCount;
        int parentId;
        int i;
        double[] arrayBuffer;
        int rightnode;
        int leftnode;
        int scanpos;
        boolean done;
        int sweepCounter;
        int nodenum;
        int scanLayer;
        int x;
        if (!this.reduced) {
            throw new RuntimeException("attempt to compute horizontal position in a non-reduced graph");
        }
        int[] position = new int[this.nodecount];
        if (this.nodecount == 1) {
            position[0] = 1;
            return position;
        }
        double[] xPosition = new double[this.nodecount];
        double[] median = new double[this.nodecount];
        double[] baryCenter = new double[this.nodecount];
        int[] nextFreeSpotOnLayer = new int[this.nodecount + 1];
        LinkedList[] nodesOnLayer = new LinkedList[this.nodecount + 1];
        int topLayer = 0;
        for (x = 0; x < this.nodecount; ++x) {
            position[x] = 0;
            nextFreeSpotOnLayer[x + 1] = 1;
            int nLayer = vertexLayer[x];
            if (nodesOnLayer[nLayer] == null) {
                nodesOnLayer[nLayer] = new LinkedList();
            }
            nodesOnLayer[nLayer].add(x);
            if (nLayer <= topLayer) continue;
            topLayer = nLayer;
        }
        ListIterator iter = nodesOnLayer[topLayer].listIterator();
        double nextx = 0.0;
        while (iter.hasNext()) {
            int nodeId = (Integer)iter.next();
            xPosition[nodeId] = nextx;
            median[nodeId] = nextx;
            baryCenter[nodeId] = nextx;
            nextx += 1.0;
        }
        for (scanLayer = topLayer - 1; scanLayer > 0; --scanLayer) {
            int nodeInsertPos = 0;
            Object[] nodeOrder = new TwinDoubleSortNode[nodesOnLayer[scanLayer].size()];
            iter = nodesOnLayer[scanLayer].listIterator();
            while (iter.hasNext()) {
                int nodeId = (Integer)iter.next();
                if (this.edgesTo[nodeId].isEmpty()) {
                    median[nodeId] = 0.0;
                    baryCenter[nodeId] = 0.0;
                } else {
                    int parentNum = 0;
                    double[] parentX = new double[this.edgesTo[nodeId].size()];
                    ListIterator parentIter = this.edgesTo[nodeId].listIterator();
                    baryCenter[nodeId] = 0.0;
                    while (parentIter.hasNext()) {
                        int parentId2 = (Integer)parentIter.next();
                        int n = nodeId;
                        baryCenter[n] = baryCenter[n] + xPosition[parentId2];
                        parentX[parentNum++] = xPosition[parentId2];
                    }
                    Arrays.sort(parentX);
                    median[nodeId] = parentX[parentX.length / 2];
                    int n = nodeId;
                    baryCenter[n] = baryCenter[n] / (double)this.edgesTo[nodeId].size();
                }
                nodeOrder[nodeInsertPos++] = new TwinDoubleSortNode(median[nodeId], baryCenter[nodeId], nodeId);
            }
            double nextHigherMedian = -1.7976931348623157E308;
            int numNodesToSpread = 0;
            Arrays.sort(nodeOrder);
            for (x = 0; x < nodeOrder.length; ++x) {
                int nodeToPosition = ((TwinDoubleSortNode)nodeOrder[x]).getValue();
                if (x > 0 && median[nodeToPosition] == median[((TwinDoubleSortNode)nodeOrder[x - 1]).getValue()]) {
                    if (nextHigherMedian == -1.7976931348623157E308) {
                        numNodesToSpread = 1;
                        for (int y = x + 1; y < nodeOrder.length; ++y) {
                            if (median[((TwinDoubleSortNode)nodeOrder[y]).getValue()] > median[((TwinDoubleSortNode)nodeOrder[y - 1]).getValue()]) {
                                nextHigherMedian = median[((TwinDoubleSortNode)nodeOrder[y]).getValue()];
                                break;
                            }
                            ++numNodesToSpread;
                        }
                        if (nextHigherMedian == -1.7976931348623157E308) {
                            nextHigherMedian = median[((TwinDoubleSortNode)nodeOrder[x]).getValue()] + 1.0;
                        }
                    }
                    xPosition[nodeToPosition] = xPosition[((TwinDoubleSortNode)nodeOrder[x - 1]).getValue()] + (nextHigherMedian - xPosition[((TwinDoubleSortNode)nodeOrder[x - 1]).getValue()]) / (double)(numNodesToSpread-- + 1);
                    continue;
                }
                nextHigherMedian = -1.7976931348623157E308;
                xPosition[nodeToPosition] = median[nodeToPosition];
            }
            for (x = 0; x < nodeOrder.length; ++x) {
                position[((TwinDoubleSortNode)nodeOrder[x]).getValue()] = x + 1;
            }
        }
        double jitterIncrement = 4.9E-323;
        double jitterSize = 0.0;
        x = 0;
        while (x < this.nodecount) {
            int n = x++;
            xPosition[n] = xPosition[n] + jitterSize;
            jitterSize += jitterIncrement;
        }
        Object[] parent = new Object[this.nodecount];
        Object[] child = new Object[this.nodecount];
        for (scanLayer = topLayer - 1; scanLayer > 1; --scanLayer) {
            int[] nodeInPosition = new int[nodesOnLayer[scanLayer].size()];
            iter = nodesOnLayer[scanLayer].listIterator();
            while (iter.hasNext()) {
                nodeInPosition[position[nodenum] - 1] = nodenum = ((Integer)iter.next()).intValue();
            }
            sweepCounter = MAX_ADJACENT_EXCHANGE_PASSES;
            done = false;
            while (!done && sweepCounter-- > 0) {
                done = true;
                for (scanpos = 1; scanpos < nodeInPosition.length; ++scanpos) {
                    int childId;
                    ListIterator childIter;
                    ListIterator parentIter;
                    leftnode = nodeInPosition[scanpos - 1];
                    rightnode = nodeInPosition[scanpos];
                    if (parent[leftnode] == null) {
                        arrayBuffer = new double[this.edgesTo[leftnode].size()];
                        parentIter = this.edgesTo[leftnode].listIterator();
                        i = 0;
                        while (parentIter.hasNext()) {
                            parentId = (Integer)parentIter.next();
                            arrayBuffer[i++] = xPosition[parentId];
                        }
                        Arrays.sort(arrayBuffer);
                        parent[leftnode] = arrayBuffer;
                    }
                    if (child[leftnode] == null) {
                        arrayBuffer = new double[this.edgesFrom[leftnode].size()];
                        childIter = this.edgesFrom[leftnode].listIterator();
                        i = 0;
                        while (childIter.hasNext()) {
                            childId = (Integer)childIter.next();
                            arrayBuffer[i++] = xPosition[childId];
                        }
                        Arrays.sort(arrayBuffer);
                        child[leftnode] = arrayBuffer;
                    }
                    if (parent[rightnode] == null) {
                        arrayBuffer = new double[this.edgesTo[rightnode].size()];
                        parentIter = this.edgesTo[rightnode].listIterator();
                        i = 0;
                        while (parentIter.hasNext()) {
                            parentId = (Integer)parentIter.next();
                            arrayBuffer[i++] = xPosition[parentId];
                        }
                        Arrays.sort(arrayBuffer);
                        parent[rightnode] = arrayBuffer;
                    }
                    if (child[rightnode] == null) {
                        arrayBuffer = new double[this.edgesFrom[rightnode].size()];
                        childIter = this.edgesFrom[rightnode].listIterator();
                        i = 0;
                        while (childIter.hasNext()) {
                            childId = (Integer)childIter.next();
                            arrayBuffer[i++] = xPosition[childId];
                        }
                        Arrays.sort(arrayBuffer);
                        child[rightnode] = arrayBuffer;
                    }
                    nowCrossCount = 0;
                    revCrossCount = 0;
                    leftSet = (double[])parent[leftnode];
                    rightSet = (double[])parent[rightnode];
                    leftIndex = 0;
                    rightIndex = 0;
                    while (leftIndex < leftSet.length && rightIndex < rightSet.length) {
                        if (rightSet[rightIndex] < leftSet[leftIndex]) {
                            nowCrossCount += leftSet.length - leftIndex;
                            ++rightIndex;
                            continue;
                        }
                        ++leftIndex;
                    }
                    leftIndex = 0;
                    rightIndex = 0;
                    while (leftIndex < leftSet.length && rightIndex < rightSet.length) {
                        if (rightSet[rightIndex] > leftSet[leftIndex]) {
                            revCrossCount += rightSet.length - rightIndex;
                            ++leftIndex;
                            continue;
                        }
                        ++rightIndex;
                    }
                    leftSet = (double[])child[leftnode];
                    rightSet = (double[])child[rightnode];
                    leftIndex = 0;
                    rightIndex = 0;
                    while (leftIndex < leftSet.length && rightIndex < rightSet.length) {
                        if (rightSet[rightIndex] < leftSet[leftIndex]) {
                            nowCrossCount += leftSet.length - leftIndex;
                            ++rightIndex;
                            continue;
                        }
                        ++leftIndex;
                    }
                    leftIndex = 0;
                    rightIndex = 0;
                    while (leftIndex < leftSet.length && rightIndex < rightSet.length) {
                        if (rightSet[rightIndex] > leftSet[leftIndex]) {
                            revCrossCount += rightSet.length - rightIndex;
                            ++leftIndex;
                            continue;
                        }
                        ++rightIndex;
                    }
                    if (nowCrossCount <= revCrossCount) continue;
                    tmp = position[leftnode];
                    position[leftnode] = position[rightnode];
                    position[rightnode] = tmp;
                    nodeInPosition[scanpos] = leftnode;
                    nodeInPosition[scanpos - 1] = rightnode;
                    dtmp = xPosition[leftnode];
                    xPosition[leftnode] = xPosition[rightnode];
                    xPosition[rightnode] = dtmp;
                    done = false;
                }
            }
        }
        int[] nodeInPosition = new int[nodesOnLayer[1].size()];
        iter = nodesOnLayer[1].listIterator();
        while (iter.hasNext()) {
            nodeInPosition[position[nodenum] - 1] = nodenum = ((Integer)iter.next()).intValue();
        }
        sweepCounter = MAX_ADJACENT_EXCHANGE_PASSES;
        done = false;
        while (!done && sweepCounter-- > 0) {
            done = true;
            for (scanpos = 1; scanpos < nodeInPosition.length; ++scanpos) {
                leftnode = nodeInPosition[scanpos - 1];
                rightnode = nodeInPosition[scanpos];
                if (parent[leftnode] == null) {
                    arrayBuffer = new double[this.edgesTo[leftnode].size()];
                    ListIterator parentIter = this.edgesTo[leftnode].listIterator();
                    i = 0;
                    while (parentIter.hasNext()) {
                        parentId = (Integer)parentIter.next();
                        arrayBuffer[i++] = xPosition[parentId];
                    }
                    Arrays.sort(arrayBuffer);
                    parent[leftnode] = arrayBuffer;
                }
                if (parent[rightnode] == null) {
                    arrayBuffer = new double[this.edgesTo[rightnode].size()];
                    ListIterator parentIter = this.edgesTo[rightnode].listIterator();
                    i = 0;
                    while (parentIter.hasNext()) {
                        parentId = (Integer)parentIter.next();
                        arrayBuffer[i++] = xPosition[parentId];
                    }
                    Arrays.sort(arrayBuffer);
                    parent[rightnode] = arrayBuffer;
                }
                nowCrossCount = 0;
                revCrossCount = 0;
                leftSet = (double[])parent[leftnode];
                rightSet = (double[])parent[rightnode];
                leftIndex = 0;
                rightIndex = 0;
                while (leftIndex < leftSet.length && rightIndex < rightSet.length) {
                    if (rightSet[rightIndex] < leftSet[leftIndex]) {
                        nowCrossCount += leftSet.length - leftIndex;
                        ++rightIndex;
                        continue;
                    }
                    ++leftIndex;
                }
                leftIndex = 0;
                rightIndex = 0;
                while (leftIndex < leftSet.length && rightIndex < rightSet.length) {
                    if (rightSet[rightIndex] > leftSet[leftIndex]) {
                        revCrossCount += rightSet.length - rightIndex;
                        ++leftIndex;
                        continue;
                    }
                    ++rightIndex;
                }
                if (nowCrossCount <= revCrossCount) continue;
                tmp = position[leftnode];
                position[leftnode] = position[rightnode];
                position[rightnode] = tmp;
                nodeInPosition[scanpos] = leftnode;
                nodeInPosition[scanpos - 1] = rightnode;
                dtmp = xPosition[leftnode];
                xPosition[leftnode] = xPosition[rightnode];
                xPosition[rightnode] = dtmp;
                done = false;
            }
        }
        return position;
    }

    public int[] getHorizontalPositionMiddle(int[] vertexLayer) {
        double dtmp;
        int tmp;
        int rightIndex;
        int leftIndex;
        double[] rightSet;
        double[] leftSet;
        int revCrossCount;
        int nowCrossCount;
        int parentId;
        int i;
        double[] arrayBuffer;
        int rightnode;
        int leftnode;
        int scanpos;
        boolean done;
        int sweepCounter;
        int nodenum;
        int y;
        int numNodesToSpread;
        double nextHigherMedian;
        int parentId2;
        int parentNum;
        Object[] nodeOrder;
        int nodeInsertPos;
        int scanLayer;
        int x;
        if (!this.reduced) {
            throw new RuntimeException("attempt to compute horizontal position in a non-reduced graph");
        }
        int[] position = new int[this.nodecount];
        if (this.nodecount == 1) {
            position[0] = 1;
            return position;
        }
        double[] xPosition = new double[this.nodecount];
        double[] median = new double[this.nodecount];
        double[] baryCenter = new double[this.nodecount];
        int[] nextFreeSpotOnLayer = new int[this.nodecount + 1];
        LinkedList[] nodesOnLayer = new LinkedList[this.nodecount + 1];
        int topLayer = 0;
        int middleLayer = 0;
        for (x = 0; x < this.nodecount; ++x) {
            position[x] = 0;
            nextFreeSpotOnLayer[x + 1] = 1;
            int nLayer = vertexLayer[x];
            if (nodesOnLayer[nLayer] == null) {
                nodesOnLayer[nLayer] = new LinkedList();
            }
            nodesOnLayer[nLayer].add(x);
            if (nLayer <= topLayer) continue;
            topLayer = nLayer;
        }
        middleLayer = (topLayer + 1) / 2;
        ListIterator iter = nodesOnLayer[middleLayer].listIterator();
        double nextx = 0.0;
        while (iter.hasNext()) {
            int nodeId = (Integer)iter.next();
            xPosition[nodeId] = nextx;
            median[nodeId] = nextx;
            baryCenter[nodeId] = nextx;
            nextx += 1.0;
        }
        for (scanLayer = middleLayer + 1; scanLayer <= topLayer; ++scanLayer) {
            nodeInsertPos = 0;
            nodeOrder = new TwinDoubleSortNode[nodesOnLayer[scanLayer].size()];
            iter = nodesOnLayer[scanLayer].listIterator();
            while (iter.hasNext()) {
                int nodeId = (Integer)iter.next();
                if (this.edgesFrom[nodeId].isEmpty()) {
                    median[nodeId] = 0.0;
                    baryCenter[nodeId] = 0.0;
                } else {
                    parentNum = 0;
                    double[] parentX = new double[this.edgesFrom[nodeId].size()];
                    ListIterator parentIter = this.edgesFrom[nodeId].listIterator();
                    baryCenter[nodeId] = 0.0;
                    while (parentIter.hasNext()) {
                        parentId2 = (Integer)parentIter.next();
                        int n = nodeId;
                        baryCenter[n] = baryCenter[n] + xPosition[parentId2];
                        parentX[parentNum++] = xPosition[parentId2];
                    }
                    Arrays.sort(parentX);
                    median[nodeId] = parentX[parentX.length / 2];
                    int n = nodeId;
                    baryCenter[n] = baryCenter[n] / (double)this.edgesFrom[nodeId].size();
                }
                nodeOrder[nodeInsertPos++] = new TwinDoubleSortNode(median[nodeId], baryCenter[nodeId], nodeId);
            }
            nextHigherMedian = -1.7976931348623157E308;
            numNodesToSpread = 0;
            Arrays.sort(nodeOrder);
            for (x = 0; x < nodeOrder.length; ++x) {
                int nodeToPosition = ((TwinDoubleSortNode)nodeOrder[x]).getValue();
                if (x > 0 && median[nodeToPosition] == median[((TwinDoubleSortNode)nodeOrder[x - 1]).getValue()]) {
                    if (nextHigherMedian == -1.7976931348623157E308) {
                        numNodesToSpread = 1;
                        for (y = x + 1; y < nodeOrder.length; ++y) {
                            if (median[((TwinDoubleSortNode)nodeOrder[y]).getValue()] > median[((TwinDoubleSortNode)nodeOrder[y - 1]).getValue()]) {
                                nextHigherMedian = median[((TwinDoubleSortNode)nodeOrder[y]).getValue()];
                                break;
                            }
                            ++numNodesToSpread;
                        }
                        if (nextHigherMedian == -1.7976931348623157E308) {
                            nextHigherMedian = median[((TwinDoubleSortNode)nodeOrder[x]).getValue()] + 1.0;
                        }
                    }
                    xPosition[nodeToPosition] = xPosition[((TwinDoubleSortNode)nodeOrder[x - 1]).getValue()] + (nextHigherMedian - xPosition[((TwinDoubleSortNode)nodeOrder[x - 1]).getValue()]) / (double)(numNodesToSpread-- + 1);
                    continue;
                }
                nextHigherMedian = -1.7976931348623157E308;
                xPosition[nodeToPosition] = median[nodeToPosition];
            }
            for (x = 0; x < nodeOrder.length; ++x) {
                position[((TwinDoubleSortNode)nodeOrder[x]).getValue()] = x + 1;
            }
        }
        for (scanLayer = middleLayer - 1; scanLayer > 0; --scanLayer) {
            nodeInsertPos = 0;
            nodeOrder = new TwinDoubleSortNode[nodesOnLayer[scanLayer].size()];
            iter = nodesOnLayer[scanLayer].listIterator();
            while (iter.hasNext()) {
                int nodeId = (Integer)iter.next();
                if (this.edgesTo[nodeId].isEmpty()) {
                    median[nodeId] = 0.0;
                    baryCenter[nodeId] = 0.0;
                } else {
                    parentNum = 0;
                    double[] parentX = new double[this.edgesTo[nodeId].size()];
                    ListIterator parentIter = this.edgesTo[nodeId].listIterator();
                    baryCenter[nodeId] = 0.0;
                    while (parentIter.hasNext()) {
                        parentId2 = (Integer)parentIter.next();
                        int n = nodeId;
                        baryCenter[n] = baryCenter[n] + xPosition[parentId2];
                        parentX[parentNum++] = xPosition[parentId2];
                    }
                    Arrays.sort(parentX);
                    median[nodeId] = parentX[parentX.length / 2];
                    int n = nodeId;
                    baryCenter[n] = baryCenter[n] / (double)this.edgesTo[nodeId].size();
                }
                nodeOrder[nodeInsertPos++] = new TwinDoubleSortNode(median[nodeId], baryCenter[nodeId], nodeId);
            }
            nextHigherMedian = -1.7976931348623157E308;
            numNodesToSpread = 0;
            Arrays.sort(nodeOrder);
            for (x = 0; x < nodeOrder.length; ++x) {
                int nodeToPosition = ((TwinDoubleSortNode)nodeOrder[x]).getValue();
                if (x > 0 && median[nodeToPosition] == median[((TwinDoubleSortNode)nodeOrder[x - 1]).getValue()]) {
                    if (nextHigherMedian == -1.7976931348623157E308) {
                        numNodesToSpread = 1;
                        for (y = x + 1; y < nodeOrder.length; ++y) {
                            if (median[((TwinDoubleSortNode)nodeOrder[y]).getValue()] > median[((TwinDoubleSortNode)nodeOrder[y - 1]).getValue()]) {
                                nextHigherMedian = median[((TwinDoubleSortNode)nodeOrder[y]).getValue()];
                                break;
                            }
                            ++numNodesToSpread;
                        }
                        if (nextHigherMedian == -1.7976931348623157E308) {
                            nextHigherMedian = median[((TwinDoubleSortNode)nodeOrder[x]).getValue()] + 1.0;
                        }
                    }
                    xPosition[nodeToPosition] = xPosition[((TwinDoubleSortNode)nodeOrder[x - 1]).getValue()] + (nextHigherMedian - xPosition[((TwinDoubleSortNode)nodeOrder[x - 1]).getValue()]) / (double)(numNodesToSpread-- + 1);
                    continue;
                }
                nextHigherMedian = -1.7976931348623157E308;
                xPosition[nodeToPosition] = median[nodeToPosition];
            }
            for (x = 0; x < nodeOrder.length; ++x) {
                position[((TwinDoubleSortNode)nodeOrder[x]).getValue()] = x + 1;
            }
        }
        double jitterIncrement = 4.9E-323;
        double jitterSize = 0.0;
        x = 0;
        while (x < this.nodecount) {
            int n = x++;
            xPosition[n] = xPosition[n] + jitterSize;
            jitterSize += jitterIncrement;
        }
        Object[] parent = new Object[this.nodecount];
        Object[] child = new Object[this.nodecount];
        for (scanLayer = topLayer; scanLayer > 1; --scanLayer) {
            if (scanLayer == middleLayer) continue;
            int[] nodeInPosition = new int[nodesOnLayer[scanLayer].size()];
            iter = nodesOnLayer[scanLayer].listIterator();
            while (iter.hasNext()) {
                nodeInPosition[position[nodenum] - 1] = nodenum = ((Integer)iter.next()).intValue();
            }
            sweepCounter = MAX_ADJACENT_EXCHANGE_PASSES;
            done = false;
            while (!done && sweepCounter-- > 0) {
                done = true;
                for (scanpos = 1; scanpos < nodeInPosition.length; ++scanpos) {
                    int childId;
                    ListIterator childIter;
                    ListIterator parentIter;
                    leftnode = nodeInPosition[scanpos - 1];
                    rightnode = nodeInPosition[scanpos];
                    if (parent[leftnode] == null) {
                        arrayBuffer = new double[this.edgesTo[leftnode].size()];
                        parentIter = this.edgesTo[leftnode].listIterator();
                        i = 0;
                        while (parentIter.hasNext()) {
                            parentId = (Integer)parentIter.next();
                            arrayBuffer[i++] = xPosition[parentId];
                        }
                        Arrays.sort(arrayBuffer);
                        parent[leftnode] = arrayBuffer;
                    }
                    if (child[leftnode] == null) {
                        arrayBuffer = new double[this.edgesFrom[leftnode].size()];
                        childIter = this.edgesFrom[leftnode].listIterator();
                        i = 0;
                        while (childIter.hasNext()) {
                            childId = (Integer)childIter.next();
                            arrayBuffer[i++] = xPosition[childId];
                        }
                        Arrays.sort(arrayBuffer);
                        child[leftnode] = arrayBuffer;
                    }
                    if (parent[rightnode] == null) {
                        arrayBuffer = new double[this.edgesTo[rightnode].size()];
                        parentIter = this.edgesTo[rightnode].listIterator();
                        i = 0;
                        while (parentIter.hasNext()) {
                            parentId = (Integer)parentIter.next();
                            arrayBuffer[i++] = xPosition[parentId];
                        }
                        Arrays.sort(arrayBuffer);
                        parent[rightnode] = arrayBuffer;
                    }
                    if (child[rightnode] == null) {
                        arrayBuffer = new double[this.edgesFrom[rightnode].size()];
                        childIter = this.edgesFrom[rightnode].listIterator();
                        i = 0;
                        while (childIter.hasNext()) {
                            childId = (Integer)childIter.next();
                            arrayBuffer[i++] = xPosition[childId];
                        }
                        Arrays.sort(arrayBuffer);
                        child[rightnode] = arrayBuffer;
                    }
                    nowCrossCount = 0;
                    revCrossCount = 0;
                    leftSet = (double[])parent[leftnode];
                    rightSet = (double[])parent[rightnode];
                    leftIndex = 0;
                    rightIndex = 0;
                    while (leftIndex < leftSet.length && rightIndex < rightSet.length) {
                        if (rightSet[rightIndex] < leftSet[leftIndex]) {
                            nowCrossCount += leftSet.length - leftIndex;
                            ++rightIndex;
                            continue;
                        }
                        ++leftIndex;
                    }
                    leftIndex = 0;
                    rightIndex = 0;
                    while (leftIndex < leftSet.length && rightIndex < rightSet.length) {
                        if (rightSet[rightIndex] > leftSet[leftIndex]) {
                            revCrossCount += rightSet.length - rightIndex;
                            ++leftIndex;
                            continue;
                        }
                        ++rightIndex;
                    }
                    leftSet = (double[])child[leftnode];
                    rightSet = (double[])child[rightnode];
                    leftIndex = 0;
                    rightIndex = 0;
                    while (leftIndex < leftSet.length && rightIndex < rightSet.length) {
                        if (rightSet[rightIndex] < leftSet[leftIndex]) {
                            nowCrossCount += leftSet.length - leftIndex;
                            ++rightIndex;
                            continue;
                        }
                        ++leftIndex;
                    }
                    leftIndex = 0;
                    rightIndex = 0;
                    while (leftIndex < leftSet.length && rightIndex < rightSet.length) {
                        if (rightSet[rightIndex] > leftSet[leftIndex]) {
                            revCrossCount += rightSet.length - rightIndex;
                            ++leftIndex;
                            continue;
                        }
                        ++rightIndex;
                    }
                    if (nowCrossCount <= revCrossCount) continue;
                    tmp = position[leftnode];
                    position[leftnode] = position[rightnode];
                    position[rightnode] = tmp;
                    nodeInPosition[scanpos] = leftnode;
                    nodeInPosition[scanpos - 1] = rightnode;
                    dtmp = xPosition[leftnode];
                    xPosition[leftnode] = xPosition[rightnode];
                    xPosition[rightnode] = dtmp;
                    done = false;
                }
            }
        }
        if (middleLayer != 1) {
            int[] nodeInPosition = new int[nodesOnLayer[1].size()];
            iter = nodesOnLayer[1].listIterator();
            while (iter.hasNext()) {
                nodeInPosition[position[nodenum] - 1] = nodenum = ((Integer)iter.next()).intValue();
            }
            sweepCounter = MAX_ADJACENT_EXCHANGE_PASSES;
            done = false;
            while (!done && sweepCounter-- > 0) {
                done = true;
                for (scanpos = 1; scanpos < nodeInPosition.length; ++scanpos) {
                    leftnode = nodeInPosition[scanpos - 1];
                    rightnode = nodeInPosition[scanpos];
                    if (parent[leftnode] == null) {
                        arrayBuffer = new double[this.edgesTo[leftnode].size()];
                        ListIterator parentIter = this.edgesTo[leftnode].listIterator();
                        i = 0;
                        while (parentIter.hasNext()) {
                            parentId = (Integer)parentIter.next();
                            arrayBuffer[i++] = xPosition[parentId];
                        }
                        Arrays.sort(arrayBuffer);
                        parent[leftnode] = arrayBuffer;
                    }
                    if (parent[rightnode] == null) {
                        arrayBuffer = new double[this.edgesTo[rightnode].size()];
                        ListIterator parentIter = this.edgesTo[rightnode].listIterator();
                        i = 0;
                        while (parentIter.hasNext()) {
                            parentId = (Integer)parentIter.next();
                            arrayBuffer[i++] = xPosition[parentId];
                        }
                        Arrays.sort(arrayBuffer);
                        parent[rightnode] = arrayBuffer;
                    }
                    nowCrossCount = 0;
                    revCrossCount = 0;
                    leftSet = (double[])parent[leftnode];
                    rightSet = (double[])parent[rightnode];
                    leftIndex = 0;
                    rightIndex = 0;
                    while (leftIndex < leftSet.length && rightIndex < rightSet.length) {
                        if (rightSet[rightIndex] < leftSet[leftIndex]) {
                            nowCrossCount += leftSet.length - leftIndex;
                            ++rightIndex;
                            continue;
                        }
                        ++leftIndex;
                    }
                    leftIndex = 0;
                    rightIndex = 0;
                    while (leftIndex < leftSet.length && rightIndex < rightSet.length) {
                        if (rightSet[rightIndex] > leftSet[leftIndex]) {
                            revCrossCount += rightSet.length - rightIndex;
                            ++leftIndex;
                            continue;
                        }
                        ++rightIndex;
                    }
                    if (nowCrossCount <= revCrossCount) continue;
                    tmp = position[leftnode];
                    position[leftnode] = position[rightnode];
                    position[rightnode] = tmp;
                    nodeInPosition[scanpos] = leftnode;
                    nodeInPosition[scanpos - 1] = rightnode;
                    dtmp = xPosition[leftnode];
                    xPosition[leftnode] = xPosition[rightnode];
                    xPosition[rightnode] = dtmp;
                    done = false;
                }
            }
        }
        return position;
    }

    public int[] getHorizontalPositionReverse(int[] vertexLayer) {
        int scanLayer;
        int x;
        if (!this.reduced) {
            throw new RuntimeException("attempt to compute horizontal position in a non-reduced graph");
        }
        int[] position = new int[this.nodecount];
        if (this.nodecount == 1) {
            position[0] = 1;
            return position;
        }
        double[] xPosition = new double[this.nodecount];
        double[] median = new double[this.nodecount];
        double[] baryCenter = new double[this.nodecount];
        int[] nextFreeSpotOnLayer = new int[this.nodecount + 1];
        LinkedList[] nodesOnLayer = new LinkedList[this.nodecount + 1];
        int bottomLayer = 1;
        int topLayer = 0;
        for (x = 0; x < this.nodecount; ++x) {
            position[x] = 0;
            nextFreeSpotOnLayer[x + 1] = 1;
            int nLayer = vertexLayer[x];
            if (nodesOnLayer[nLayer] == null) {
                nodesOnLayer[nLayer] = new LinkedList();
            }
            nodesOnLayer[nLayer].add(x);
            if (nLayer <= topLayer) continue;
            topLayer = nLayer;
        }
        ListIterator iter = nodesOnLayer[bottomLayer].listIterator();
        double nextx = 0.0;
        while (iter.hasNext()) {
            int nodeId = (Integer)iter.next();
            xPosition[nodeId] = nextx;
            median[nodeId] = nextx;
            baryCenter[nodeId] = nextx;
            nextx += 1.0;
        }
        for (scanLayer = bottomLayer + 1; scanLayer <= topLayer; ++scanLayer) {
            int nodeInsertPos = 0;
            Object[] nodeOrder = new TwinDoubleSortNode[nodesOnLayer[scanLayer].size()];
            iter = nodesOnLayer[scanLayer].listIterator();
            while (iter.hasNext()) {
                int nodeId = (Integer)iter.next();
                if (this.edgesFrom[nodeId].isEmpty()) {
                    median[nodeId] = 0.0;
                    baryCenter[nodeId] = 0.0;
                } else {
                    int parentNum = 0;
                    double[] parentX = new double[this.edgesFrom[nodeId].size()];
                    ListIterator parentIter = this.edgesFrom[nodeId].listIterator();
                    baryCenter[nodeId] = 0.0;
                    while (parentIter.hasNext()) {
                        int parentId = (Integer)parentIter.next();
                        int n = nodeId;
                        baryCenter[n] = baryCenter[n] + xPosition[parentId];
                        parentX[parentNum++] = xPosition[parentId];
                    }
                    Arrays.sort(parentX);
                    median[nodeId] = parentX[parentX.length / 2];
                    int n = nodeId;
                    baryCenter[n] = baryCenter[n] / (double)this.edgesFrom[nodeId].size();
                }
                nodeOrder[nodeInsertPos++] = new TwinDoubleSortNode(median[nodeId], baryCenter[nodeId], nodeId);
            }
            double nextHigherMedian = -1.7976931348623157E308;
            int numNodesToSpread = 0;
            Arrays.sort(nodeOrder);
            for (x = 0; x < nodeOrder.length; ++x) {
                int nodeToPosition = ((TwinDoubleSortNode)nodeOrder[x]).getValue();
                if (x > 0 && median[nodeToPosition] == median[((TwinDoubleSortNode)nodeOrder[x - 1]).getValue()]) {
                    if (nextHigherMedian == -1.7976931348623157E308) {
                        numNodesToSpread = 1;
                        for (int y = x + 1; y < nodeOrder.length; ++y) {
                            if (median[((TwinDoubleSortNode)nodeOrder[y]).getValue()] > median[((TwinDoubleSortNode)nodeOrder[y - 1]).getValue()]) {
                                nextHigherMedian = median[((TwinDoubleSortNode)nodeOrder[y]).getValue()];
                                break;
                            }
                            ++numNodesToSpread;
                        }
                        if (nextHigherMedian == -1.7976931348623157E308) {
                            nextHigherMedian = median[((TwinDoubleSortNode)nodeOrder[x]).getValue()] + 1.0;
                        }
                    }
                    xPosition[nodeToPosition] = xPosition[((TwinDoubleSortNode)nodeOrder[x - 1]).getValue()] + (nextHigherMedian - xPosition[((TwinDoubleSortNode)nodeOrder[x - 1]).getValue()]) / (double)(numNodesToSpread-- + 1);
                    continue;
                }
                nextHigherMedian = -1.7976931348623157E308;
                xPosition[nodeToPosition] = median[nodeToPosition];
            }
            for (x = 0; x < nodeOrder.length; ++x) {
                position[((TwinDoubleSortNode)nodeOrder[x]).getValue()] = x + 1;
            }
        }
        double jitterIncrement = 4.9E-323;
        double jitterSize = 0.0;
        x = 0;
        while (x < this.nodecount) {
            int n = x++;
            xPosition[n] = xPosition[n] + jitterSize;
            jitterSize += jitterIncrement;
        }
        Object[] parent = new Object[this.nodecount];
        Object[] child = new Object[this.nodecount];
        for (scanLayer = bottomLayer + 1; scanLayer <= topLayer; ++scanLayer) {
            int[] nodeInPosition = new int[nodesOnLayer[scanLayer].size()];
            iter = nodesOnLayer[scanLayer].listIterator();
            while (iter.hasNext()) {
                int nodenum;
                nodeInPosition[position[nodenum] - 1] = nodenum = ((Integer)iter.next()).intValue();
            }
            int sweepCounter = MAX_ADJACENT_EXCHANGE_PASSES;
            boolean done = false;
            while (!done && sweepCounter-- > 0) {
                done = true;
                for (int scanpos = 1; scanpos < nodeInPosition.length; ++scanpos) {
                    int childId;
                    ListIterator childIter;
                    int parentId;
                    int i;
                    ListIterator parentIter;
                    double[] arrayBuffer;
                    int leftnode = nodeInPosition[scanpos - 1];
                    int rightnode = nodeInPosition[scanpos];
                    if (parent[leftnode] == null) {
                        arrayBuffer = new double[this.edgesFrom[leftnode].size()];
                        parentIter = this.edgesFrom[leftnode].listIterator();
                        i = 0;
                        while (parentIter.hasNext()) {
                            parentId = (Integer)parentIter.next();
                            arrayBuffer[i++] = xPosition[parentId];
                        }
                        Arrays.sort(arrayBuffer);
                        parent[leftnode] = arrayBuffer;
                    }
                    if (child[leftnode] == null) {
                        arrayBuffer = new double[this.edgesTo[leftnode].size()];
                        childIter = this.edgesTo[leftnode].listIterator();
                        i = 0;
                        while (childIter.hasNext()) {
                            childId = (Integer)childIter.next();
                            arrayBuffer[i++] = xPosition[childId];
                        }
                        Arrays.sort(arrayBuffer);
                        child[leftnode] = arrayBuffer;
                    }
                    if (parent[rightnode] == null) {
                        arrayBuffer = new double[this.edgesFrom[rightnode].size()];
                        parentIter = this.edgesFrom[rightnode].listIterator();
                        i = 0;
                        while (parentIter.hasNext()) {
                            parentId = (Integer)parentIter.next();
                            arrayBuffer[i++] = xPosition[parentId];
                        }
                        Arrays.sort(arrayBuffer);
                        parent[rightnode] = arrayBuffer;
                    }
                    if (child[rightnode] == null) {
                        arrayBuffer = new double[this.edgesTo[rightnode].size()];
                        childIter = this.edgesTo[rightnode].listIterator();
                        i = 0;
                        while (childIter.hasNext()) {
                            childId = (Integer)childIter.next();
                            arrayBuffer[i++] = xPosition[childId];
                        }
                        Arrays.sort(arrayBuffer);
                        child[rightnode] = arrayBuffer;
                    }
                    int nowCrossCount = 0;
                    int revCrossCount = 0;
                    double[] leftSet = (double[])parent[leftnode];
                    double[] rightSet = (double[])parent[rightnode];
                    int leftIndex = 0;
                    int rightIndex = 0;
                    while (leftIndex < leftSet.length && rightIndex < rightSet.length) {
                        if (rightSet[rightIndex] < leftSet[leftIndex]) {
                            nowCrossCount += leftSet.length - leftIndex;
                            ++rightIndex;
                            continue;
                        }
                        ++leftIndex;
                    }
                    leftIndex = 0;
                    rightIndex = 0;
                    while (leftIndex < leftSet.length && rightIndex < rightSet.length) {
                        if (rightSet[rightIndex] > leftSet[leftIndex]) {
                            revCrossCount += rightSet.length - rightIndex;
                            ++leftIndex;
                            continue;
                        }
                        ++rightIndex;
                    }
                    leftSet = (double[])child[leftnode];
                    rightSet = (double[])child[rightnode];
                    leftIndex = 0;
                    rightIndex = 0;
                    while (leftIndex < leftSet.length && rightIndex < rightSet.length) {
                        if (rightSet[rightIndex] < leftSet[leftIndex]) {
                            nowCrossCount += leftSet.length - leftIndex;
                            ++rightIndex;
                            continue;
                        }
                        ++leftIndex;
                    }
                    leftIndex = 0;
                    rightIndex = 0;
                    while (leftIndex < leftSet.length && rightIndex < rightSet.length) {
                        if (rightSet[rightIndex] > leftSet[leftIndex]) {
                            revCrossCount += rightSet.length - rightIndex;
                            ++leftIndex;
                            continue;
                        }
                        ++rightIndex;
                    }
                    if (nowCrossCount <= revCrossCount) continue;
                    int tmp = position[leftnode];
                    position[leftnode] = position[rightnode];
                    position[rightnode] = tmp;
                    nodeInPosition[scanpos] = leftnode;
                    nodeInPosition[scanpos - 1] = rightnode;
                    double dtmp = xPosition[leftnode];
                    xPosition[leftnode] = xPosition[rightnode];
                    xPosition[rightnode] = dtmp;
                    done = false;
                }
            }
        }
        return position;
    }

    public static void main(String[] args) {
        try {
            Graph graph = new Graph(new InputStreamReader(System.in));
            int[] cI = graph.componentIndex();
            int[] renumber = new int[cI.length];
            Graph[] component = graph.partition(cI, renumber);
            for (int x = 0; x < component.length; ++x) {
                Graph red = component[x].getReducedGraph();
                int[] layer = red.getVertexLayers();
                int[] nArray = red.getHorizontalPosition(layer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error detected reading graph\nExiting\n");
        }
    }
}

