/*
 * Decompiled with CFR 0.152.
 */
package csapps.layout.algorithms.graphPartition;

import cern.colt.map.PrimeFinder;
import java.util.HashMap;
import java.util.Map;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class Layout {
    Map<Long, Double> nodeXMap;
    Map<Long, Double> nodeYMap;
    CyNetwork gp;

    public Layout(CyNetwork gp) {
        this.gp = gp;
        this.nodeXMap = new HashMap<Long, Double>(PrimeFinder.nextPrime((int)gp.getNodeCount()));
        this.nodeYMap = new HashMap<Long, Double>(PrimeFinder.nextPrime((int)gp.getNodeCount()));
    }

    public Layout(CyNetworkView view, boolean load_current_values) {
        this((CyNetwork)view.getModel());
        if (load_current_values) {
            for (View nv : view.getNodeViews()) {
                this.setX((View<CyNode>)nv, (double)((Double)nv.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION)));
                this.setY((View<CyNode>)nv, (double)((Double)nv.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION)));
            }
        }
    }

    public void applyLayout(CyNetworkView view) {
        for (View nv : view.getNodeViews()) {
            nv.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)this.getX((View<CyNode>)nv));
            nv.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)this.getY((View<CyNode>)nv));
        }
    }

    public boolean setX(Long node, double x) {
        if (this.nodeXMap.containsKey(node)) {
            return false;
        }
        this.nodeXMap.put(node, x);
        return true;
    }

    public boolean setY(Long node, double y) {
        if (this.nodeYMap.containsKey(node)) {
            return false;
        }
        this.nodeYMap.put(node, y);
        return true;
    }

    public boolean setX(CyNode node, double x) {
        return this.setX(node.getSUID(), x);
    }

    public boolean setY(CyNode node, double y) {
        return this.setY(node.getSUID(), y);
    }

    public boolean setX(View<CyNode> node, double x) {
        return this.setX(((CyNode)node.getModel()).getSUID(), x);
    }

    public boolean setY(View<CyNode> node, double y) {
        return this.setY(((CyNode)node.getModel()).getSUID(), y);
    }

    public double getX(Long node) {
        return this.nodeXMap.get(node);
    }

    public double getY(Long node) {
        return this.nodeYMap.get(node);
    }

    public double getX(CyNode node) {
        return this.nodeXMap.get(node.getSUID());
    }

    public double getY(CyNode node) {
        return this.nodeYMap.get(node.getSUID());
    }

    public double getX(View<CyNode> node) {
        return this.nodeXMap.get(((CyNode)node.getModel()).getSUID());
    }

    public double getY(View<CyNode> node) {
        return this.nodeYMap.get(((CyNode)node.getModel()).getSUID());
    }
}

