/*
 * Decompiled with CFR 0.152.
 */
package csapps.layout.algorithms.graphPartition;

import csapps.layout.algorithms.graphPartition.DegreeSortedCircleContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.layout.AbstractPartitionLayoutTask;
import org.cytoscape.view.layout.LayoutNode;
import org.cytoscape.view.layout.LayoutPartition;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.undo.UndoSupport;

public class DegreeSortedCircleLayoutTask
extends AbstractPartitionLayoutTask {
    private static final String DEGREE_ATTR_NAME = "degree.layout";
    private final CyNetwork network;

    public DegreeSortedCircleLayoutTask(String displayName, CyNetworkView networkView, Set<View<CyNode>> nodesToLayOut, DegreeSortedCircleContext context, String attrName, UndoSupport undo) {
        super(displayName, context.singlePartition, networkView, nodesToLayOut, attrName, undo);
        this.network = (CyNetwork)networkView.getModel();
    }

    public void layoutPartition(LayoutPartition partition) {
        CyTable table = this.network.getDefaultNodeTable();
        if (table.getColumn(DEGREE_ATTR_NAME) == null) {
            table.createColumn(DEGREE_ATTR_NAME, Integer.class, false);
        }
        ArrayList<LayoutNode> nodes = new ArrayList<LayoutNode>();
        for (LayoutNode ln : partition.getNodeList()) {
            if (ln.isLocked()) continue;
            nodes.add(ln);
        }
        if (this.cancelled) {
            return;
        }
        Collections.sort(nodes, new Comparator<LayoutNode>(){

            @Override
            public int compare(LayoutNode o1, LayoutNode o2) {
                CyNode node1 = o1.getNode();
                CyNode node2 = o2.getNode();
                int d1 = DegreeSortedCircleLayoutTask.this.network.getAdjacentEdgeList(node1, CyEdge.Type.ANY).size();
                int d2 = DegreeSortedCircleLayoutTask.this.network.getAdjacentEdgeList(node2, CyEdge.Type.ANY).size();
                o1.getRow().set(DegreeSortedCircleLayoutTask.DEGREE_ATTR_NAME, (Object)d1);
                o2.getRow().set(DegreeSortedCircleLayoutTask.DEGREE_ATTR_NAME, (Object)d2);
                return d2 - d1;
            }

            @Override
            public boolean equals(Object o) {
                return false;
            }
        });
        if (this.cancelled) {
            return;
        }
        int r = 100 * (int)Math.sqrt(nodes.size());
        double phi = Math.PI * 2 / (double)nodes.size();
        partition.resetNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            LayoutNode node = (LayoutNode)nodes.get(i);
            node.setX((double)r + (double)r * Math.sin((double)i * phi));
            node.setY((double)r + (double)r * Math.cos((double)i * phi));
            partition.moveNodeToLocation(node);
        }
    }
}

