/*
 * Decompiled with CFR 0.152.
 */
package csapps.layout.algorithms.cose;

import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.util.ListSingleSelection;

public class CoSELayoutContext
implements TunableValidator {
    public LayoutQuality layoutQuality = LayoutQuality.DEFAULT;
    @Tunable(description="Incremental:", gravity=1.1, context="both", longDescription="Incremental; whether the algorithm will be applied incrementally; boolean values only, ```true``` or ```false```; defaults to ```false```", exampleStringValue="false")
    public boolean incremental = false;
    @Tunable(description="Ideal edge length:", tooltip="Any positive integer", gravity=2.0, context="both", longDescription="Ideal edge length, any positive integer", exampleStringValue="50")
    public int idealEdgeLength = 50;
    @Tunable(description="Spring strength (0-100):", gravity=2.1, context="both", longDescription="Spring strength (0-100)", exampleStringValue="50")
    public int springStrength = 50;
    @Tunable(description="Repulsion strength (0-100):", gravity=2.2, context="both", longDescription="Repulsion strength (0-100)", exampleStringValue="50")
    public int repulsionStrength = 50;
    @Tunable(description="Gravity strength (0-100):", gravity=2.3, context="both", longDescription="Gravity strength (0-100)", exampleStringValue="50")
    public int gravityStrength = 50;
    @Tunable(description="Compound gravity strength (0-100):", gravity=2.4, context="both", longDescription="Compound gravity strength (0-100)", exampleStringValue="50")
    public int compoundGravityStrength = 50;
    @Tunable(description="Gravity range (0-100):", gravity=2.5, context="both", longDescription="Gravity range (0-100)", exampleStringValue="50")
    public int gravityRange = 50;
    @Tunable(description="Compound gravity range (0-100):", gravity=2.6, context="both", longDescription="Compound gravity range (0-100)", exampleStringValue="50")
    public int compoundGravityRange = 50;
    @Tunable(description="Use smart edge length calculation:", gravity=3.0, context="both", longDescription="Use smart edge length calculation; boolean values only, ```true``` or ```false```; defaults to ```true```", exampleStringValue="true")
    public boolean smartEdgeLengthCalc = true;
    @Tunable(description="Use smart repulsion range calculation:", gravity=3.1, context="both", longDescription="Use smart repulsion range calculation; boolean values only, ```true``` or ```false```; defaults to ```true```", exampleStringValue="true")
    public boolean smartRepulsionRangeCalc = true;

    @Tunable(description="Layout quality:", gravity=1.0, context="both", longDescription="Layout quality; allowed values are ```Proof```, ```Default``` and ```Draft```", exampleStringValue="Default")
    public ListSingleSelection<LayoutQuality> getLayoutQuality() {
        ListSingleSelection list = new ListSingleSelection((Object[])new LayoutQuality[]{LayoutQuality.PROOF, LayoutQuality.DEFAULT, LayoutQuality.DRAFT});
        list.setSelectedValue((Object)this.layoutQuality);
        return list;
    }

    public void setLayoutQuality(ListSingleSelection<LayoutQuality> list) {
        this.layoutQuality = (LayoutQuality)((Object)list.getSelectedValue());
    }

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        return TunableValidator.ValidationState.OK;
    }

    public static enum LayoutQuality {
        PROOF(0, "Proof"),
        DEFAULT(1, "Default"),
        DRAFT(2, "Draft");

        private int value;
        private String name;

        private LayoutQuality(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }
    }
}

