/*
 * Decompiled with CFR 0.152.
 */
package csapps.layout.algorithms.bioLayout;

import csapps.layout.Profile;
import csapps.layout.algorithms.bioLayout.BioLayoutAlgorithmTask;
import csapps.layout.algorithms.bioLayout.BioLayoutKKContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.layout.LayoutEdge;
import org.cytoscape.view.layout.LayoutNode;
import org.cytoscape.view.layout.LayoutPartition;
import org.cytoscape.view.layout.LayoutPoint;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.undo.UndoSupport;

public class BioLayoutKKAlgorithmTask
extends BioLayoutAlgorithmTask {
    protected static double EPSILON = 1.0E-7;
    private int m_numLayoutPasses = 10;
    private double m_averageIterationsPerNode = 40.0;
    private double m_nodeDistanceStrengthConstant = 15.0;
    private double m_nodeDistanceRestLengthConstant = 45.0;
    private double[] m_nodeDistanceSpringScalars;
    private double m_disconnectedNodeDistanceSpringStrength = 0.05;
    private double m_disconnectedNodeDistanceSpringRestLength = 2000.0;
    private double m_anticollisionSpringStrength;
    private double[] m_anticollisionSpringScalars;
    private double[][] m_nodeDistanceSpringRestLengths;
    private double[][] m_nodeDistanceSpringStrengths;
    private int m_layoutPass = 2;
    private int m_nodeCount;
    private LayoutPartition partition;
    Profile calculationProfile;
    Profile distanceProfile;
    private BioLayoutKKContext context;

    public BioLayoutKKAlgorithmTask(String displayName, CyNetworkView networkView, Set<View<CyNode>> nodesToLayOut, BioLayoutKKContext context, boolean supportWeights, String attrName, UndoSupport undo) {
        super(displayName, networkView, nodesToLayOut, context.singlePartition, attrName, undo);
        this.context = context;
        this.supportWeights = supportWeights;
        this.m_layoutPass = context.m_layoutPass;
        this.edgeWeighter = context.edgeWeighter;
        this.edgeWeighter.setWeightAttribute(this.layoutAttribute);
        this.m_averageIterationsPerNode = context.m_averageIterationsPerNode;
        this.m_nodeDistanceStrengthConstant = context.m_nodeDistanceStrengthConstant;
        this.m_nodeDistanceRestLengthConstant = context.m_nodeDistanceRestLengthConstant;
        this.m_disconnectedNodeDistanceSpringStrength = context.m_disconnectedNodeDistanceSpringStrength;
        this.m_disconnectedNodeDistanceSpringRestLength = context.m_disconnectedNodeDistanceSpringRestLength;
        this.m_anticollisionSpringStrength = context.m_anticollisionSpringStrength;
        this.m_layoutPass = 2;
    }

    public String getName() {
        if (this.supportWeights) {
            return "kamada-kawai-noweight";
        }
        return "kamada-kawai";
    }

    public String toString() {
        if (this.supportWeights) {
            return "Edge-weighted Spring Embedded";
        }
        return "Spring Embedded";
    }

    public void setNumberOfIterationsPerNode(int value) {
        this.m_averageIterationsPerNode = value;
    }

    public void setNumberOfIterationsPerNode(String value) {
        Integer val = Integer.valueOf(value);
        this.m_averageIterationsPerNode = val.intValue();
    }

    public void setNumberOfLayoutPasses(int value) {
        this.m_numLayoutPasses = value;
    }

    public void setNumberOfLayoutPasses(String value) {
        Integer val = Integer.valueOf(value);
        this.m_numLayoutPasses = val;
    }

    public void setDistanceSpringStrength(double value) {
        this.m_nodeDistanceStrengthConstant = value;
    }

    public void setDistanceSpringStrength(String value) {
        Double val = new Double(value);
        this.m_nodeDistanceStrengthConstant = val;
    }

    public void setDistanceRestLength(double value) {
        this.m_nodeDistanceRestLengthConstant = value;
    }

    public void setDistanceRestLength(String value) {
        Double val = new Double(value);
        this.m_nodeDistanceRestLengthConstant = val;
    }

    public void setDisconnectedSpringStrength(double value) {
        this.m_disconnectedNodeDistanceSpringStrength = value;
    }

    public void setDisconnectedSpringStrength(String value) {
        Double val = new Double(value);
        this.m_disconnectedNodeDistanceSpringStrength = val;
    }

    public void setDisconnectedRestLength(double value) {
        this.m_disconnectedNodeDistanceSpringRestLength = value;
    }

    public void setDisconnectedRestLength(String value) {
        Double val = new Double(value);
        this.m_disconnectedNodeDistanceSpringRestLength = val;
    }

    public void setAnticollisionSpringStrength(double value) {
        this.m_anticollisionSpringStrength = value;
    }

    public void setAnticollisionSpringStrength(String value) {
        Double val = new Double(value);
        this.m_anticollisionSpringStrength = val;
    }

    @Override
    public void layoutPartition(LayoutPartition partition) {
        int i;
        LayoutPoint initialLocation = null;
        this.partition = partition;
        this.m_nodeCount = partition.nodeCount();
        this.m_nodeDistanceSpringScalars = new double[this.m_numLayoutPasses];
        for (i = 0; i < this.m_numLayoutPasses; ++i) {
            this.m_nodeDistanceSpringScalars[i] = 1.0;
        }
        this.m_anticollisionSpringScalars = new double[this.m_numLayoutPasses];
        this.m_anticollisionSpringScalars[0] = 0.0;
        for (i = 1; i < this.m_numLayoutPasses; ++i) {
            this.m_anticollisionSpringScalars[i] = 1.0;
        }
        double euclideanDistanceThreshold = (this.m_nodeCount + partition.edgeCount()) / 10;
        int numIterations = (int)((double)this.m_nodeCount * this.m_averageIterationsPerNode / (double)this.m_numLayoutPasses);
        ArrayList<PartialDerivatives> partialsList = new ArrayList<PartialDerivatives>();
        double[] potentialEnergy = new double[1];
        if (potentialEnergy[0] != 0.0) {
            throw new RuntimeException();
        }
        PartialDerivatives furthestNodePartials = null;
        this.m_nodeDistanceSpringRestLengths = new double[this.m_nodeCount][this.m_nodeCount];
        this.m_nodeDistanceSpringStrengths = new double[this.m_nodeCount][this.m_nodeCount];
        initialLocation = partition.getAverageLocation();
        if (this.context.randomize) {
            partition.randomizeLocations();
        }
        partition.calculateEdgeWeights();
        if (this.cancelled) {
            return;
        }
        this.taskMonitor.setProgress(0.02);
        this.taskMonitor.setStatusMessage("Calculating node distances");
        int[][] nodeDistances = this.calculateNodeDistances();
        if (this.cancelled) {
            return;
        }
        this.taskMonitor.setProgress(0.04);
        this.taskMonitor.setStatusMessage("Calculating spring constants");
        this.calculateSpringData(nodeDistances);
        double percentCompletedBeforePasses = 5.0;
        double percentCompletedAfterPass1 = 60.0;
        double percentCompletedAfterFinalPass = 95.0;
        double currentProgress = 5.0;
        this.m_layoutPass = 0;
        while (this.m_layoutPass < this.m_numLayoutPasses) {
            Profile passTimer = new Profile();
            passTimer.start();
            double percentProgressPerIter = this.m_layoutPass == 0 ? 55.0 / (double)(this.m_nodeCount + numIterations) : 35.0 / (double)((this.m_nodeCount + numIterations) * (this.m_numLayoutPasses - 1));
            potentialEnergy[0] = 0.0;
            partialsList.clear();
            furthestNodePartials = null;
            this.taskMonitor.setStatusMessage("Calculating partial derivatives -- pass " + (this.m_layoutPass + 1) + " of " + this.m_numLayoutPasses);
            for (LayoutNode v : partition.getNodeList()) {
                if (this.cancelled) {
                    return;
                }
                this.taskMonitor.setProgress(currentProgress / 100.0);
                if (v.isLocked()) continue;
                PartialDerivatives partials = new PartialDerivatives(v);
                this.calculatePartials(partials, null, potentialEnergy, false);
                partialsList.add(partials);
                if (furthestNodePartials == null || partials.euclideanDistance > furthestNodePartials.euclideanDistance) {
                    furthestNodePartials = partials;
                }
                currentProgress += percentProgressPerIter;
            }
            this.taskMonitor.setStatusMessage("Executing spring logic -- pass " + (this.m_layoutPass + 1) + " of " + this.m_numLayoutPasses);
            for (int iterations_i = 0; iterations_i < numIterations && furthestNodePartials.euclideanDistance >= euclideanDistanceThreshold; ++iterations_i) {
                if (this.cancelled) {
                    return;
                }
                this.taskMonitor.setProgress(currentProgress / 100.0);
                furthestNodePartials = this.moveNode(furthestNodePartials, partialsList, potentialEnergy);
                currentProgress += percentProgressPerIter;
            }
            ++this.m_layoutPass;
        }
        this.taskMonitor.setProgress(0.95);
        this.taskMonitor.setStatusMessage("Updating display");
        partition.resetNodes();
        for (LayoutNode v : partition.getNodeList()) {
            partition.moveNodeToLocation(v);
        }
        double xDelta = 0.0;
        double yDelta = 0.0;
        LayoutPoint finalLocation = partition.getAverageLocation();
        xDelta = finalLocation.getX() - initialLocation.getX();
        yDelta = finalLocation.getY() - initialLocation.getY();
        partition.resetNodes();
        for (LayoutNode v : partition.getNodeList()) {
            if (v.isLocked()) continue;
            v.decrement(xDelta, yDelta);
            partition.moveNodeToLocation(v);
        }
    }

    private int[][] calculateNodeDistances() {
        int[][] distances = new int[this.m_nodeCount][];
        LinkedList<Integer> queue = new LinkedList<Integer>();
        boolean[] completedNodes = new boolean[this.m_nodeCount];
        for (LayoutNode v : this.partition.getNodeList()) {
            int fromNode = v.getIndex();
            if (distances[fromNode] == null) {
                distances[fromNode] = new int[this.m_nodeCount];
            }
            Arrays.fill(distances[fromNode], Integer.MAX_VALUE);
            distances[fromNode][fromNode] = 0;
            Arrays.fill(completedNodes, false);
            queue.add(fromNode);
            while (!queue.isEmpty()) {
                int index = (Integer)queue.removeFirst();
                if (completedNodes[index]) continue;
                completedNodes[index] = true;
                int toNode = index;
                int toNodeDistance = distances[fromNode][index];
                if (index < fromNode) {
                    for (int i = 0; i < this.m_nodeCount; ++i) {
                        int distanceThroughToNode;
                        if (distances[index][i] == Integer.MAX_VALUE || (distanceThroughToNode = toNodeDistance + distances[index][i]) > distances[fromNode][i]) continue;
                        if (distances[index][i] == 1) {
                            completedNodes[i] = true;
                        }
                        distances[fromNode][i] = distanceThroughToNode;
                    }
                    continue;
                }
                List neighborList = v.getNeighbors();
                for (LayoutNode neighbor_v : neighborList) {
                    int neighbor = neighbor_v.getIndex();
                    if (completedNodes[neighbor]) continue;
                    int neighborDistance = distances[fromNode][neighbor];
                    if (toNodeDistance == Integer.MAX_VALUE || neighborDistance <= toNodeDistance + 1) continue;
                    distances[fromNode][neighbor] = toNodeDistance + 1;
                    queue.addLast(neighbor);
                }
            }
        }
        return distances;
    }

    private void calculateSpringData(int[][] nodeDistances) {
        for (int node_i = 0; node_i < this.m_nodeCount; ++node_i) {
            Arrays.fill(this.m_nodeDistanceSpringRestLengths[node_i], this.m_disconnectedNodeDistanceSpringRestLength);
            Arrays.fill(this.m_nodeDistanceSpringStrengths[node_i], this.m_disconnectedNodeDistanceSpringStrength);
        }
        for (LayoutEdge edge : this.partition.getEdgeList()) {
            double weight;
            int node_i = edge.getSource().getIndex();
            int node_j = edge.getTarget().getIndex();
            double d = weight = this.context.unweighted ? this.edgeWeighter.defaultEdgeWeight : edge.getWeight();
            if (nodeDistances[node_i][node_j] == Integer.MAX_VALUE) continue;
            this.m_nodeDistanceSpringRestLengths[node_i][node_j] = this.m_nodeDistanceRestLengthConstant * (double)nodeDistances[node_i][node_j] / weight;
            this.m_nodeDistanceSpringRestLengths[node_j][node_i] = this.m_nodeDistanceSpringRestLengths[node_i][node_j];
            this.m_nodeDistanceSpringStrengths[node_i][node_j] = this.m_nodeDistanceStrengthConstant / (double)(nodeDistances[node_i][node_j] * nodeDistances[node_i][node_j]);
            this.m_nodeDistanceSpringStrengths[node_j][node_i] = this.m_nodeDistanceSpringStrengths[node_i][node_j];
        }
    }

    private double calculateSpringPartial(int pass, double distToTouch, int nodeIndex, int otherNodeIndex, double eucDist, double value, double radius) {
        double incrementalChange = this.m_nodeDistanceSpringScalars[pass] * (this.m_nodeDistanceSpringStrengths[nodeIndex][otherNodeIndex] * (value - this.m_nodeDistanceSpringRestLengths[nodeIndex][otherNodeIndex] * value / eucDist));
        if (distToTouch < 0.0) {
            incrementalChange += this.m_anticollisionSpringScalars[pass] * (this.m_anticollisionSpringStrength * (value - radius * value / eucDist));
        }
        return incrementalChange;
    }

    private double calculateSpringPartial3(int pass, double distToTouch, int nodeIndex, int otherNodeIndex, double eucDist3, double value, double radius) {
        double incrementalChange = this.m_nodeDistanceSpringScalars[pass] * (this.m_nodeDistanceSpringStrengths[nodeIndex][otherNodeIndex] * (1.0 - this.m_nodeDistanceSpringRestLengths[nodeIndex][otherNodeIndex] * value / eucDist3));
        if (distToTouch < 0.0) {
            incrementalChange += this.m_anticollisionSpringScalars[this.m_layoutPass] * (this.m_anticollisionSpringStrength * (1.0 - radius * value / eucDist3));
        }
        return incrementalChange;
    }

    private double calculateSpringPartialCross(int pass, double distToTouch, int nodeIndex, int otherNodeIndex, double eucDist3, double value, double radius) {
        double incrementalChange = this.m_nodeDistanceSpringScalars[pass] * (this.m_nodeDistanceSpringStrengths[nodeIndex][otherNodeIndex] * (this.m_nodeDistanceSpringRestLengths[nodeIndex][otherNodeIndex] * value / eucDist3));
        if (distToTouch < 0.0) {
            incrementalChange += this.m_anticollisionSpringScalars[this.m_layoutPass] * (this.m_anticollisionSpringStrength * radius * value) / eucDist3;
        }
        return incrementalChange;
    }

    private double calculatePE(int pass, double distToRest, double distToTouch, int nodeIndex, int otherNodeIndex) {
        double incrementalChange = this.m_nodeDistanceSpringScalars[pass] * (this.m_nodeDistanceSpringStrengths[nodeIndex][otherNodeIndex] * (distToRest * distToRest) / 2.0);
        if (distToTouch < 0.0) {
            incrementalChange += this.m_anticollisionSpringScalars[pass] * (this.m_anticollisionSpringStrength * (distToTouch * distToTouch) / 2.0);
        }
        return incrementalChange;
    }

    private PartialDerivatives calculatePartials(PartialDerivatives partials, List partialsList, double[] potentialEnergy, boolean reversed) {
        partials.reset();
        LayoutNode node = partials.node;
        double nodeRadius = node.getWidth() / 2.0;
        double nodeX = node.getX();
        double nodeY = node.getY();
        PartialDerivatives otherPartials = null;
        PartialDerivatives furthestPartials = null;
        Iterator iterator = partialsList == null ? this.partition.nodeIterator() : partialsList.iterator();
        double[] xTable = new double[]{0.01, 0.01, -0.01, -0.01};
        double[] yTable = new double[]{0.01, -0.01, 0.01, -0.01};
        int offsetTable = 0;
        int nodeIndex = node.getIndex();
        while (iterator.hasNext()) {
            double otherNodeY;
            double deltaY;
            LayoutNode otherNode;
            if (partialsList == null) {
                otherNode = (LayoutNode)iterator.next();
            } else {
                otherPartials = (PartialDerivatives)iterator.next();
                otherNode = otherPartials.node;
            }
            if (node == otherNode) continue;
            double otherNodeRadius = otherNode.getWidth() / 2.0;
            double otherNodeX = otherNode.getX();
            double deltaX = nodeX - otherNodeX;
            double euclideanDistance = Math.sqrt(deltaX * deltaX + (deltaY = nodeY - (otherNodeY = otherNode.getY())) * deltaY);
            if ((double)((float)euclideanDistance) < 1.0E-4) {
                otherNodeX += xTable[offsetTable];
                otherNodeY += yTable[offsetTable++];
                if (offsetTable > 3) {
                    offsetTable = 0;
                }
                otherNode.setX(otherNodeX);
                otherNode.setY(otherNodeY);
                euclideanDistance = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
            }
            int otherNodeIndex = otherNode.getIndex();
            double radius = nodeRadius + otherNodeRadius;
            double euclideanDistanceCubed = euclideanDistance * euclideanDistance * euclideanDistance;
            double distanceFromTouching = euclideanDistance - (nodeRadius + otherNodeRadius);
            double distanceFromRest = euclideanDistance - this.m_nodeDistanceSpringRestLengths[nodeIndex][otherNodeIndex];
            if (!reversed) {
                partials.x += this.calculateSpringPartial(this.m_layoutPass, distanceFromTouching, nodeIndex, otherNodeIndex, euclideanDistance, deltaX, radius);
                partials.y += this.calculateSpringPartial(this.m_layoutPass, distanceFromTouching, nodeIndex, otherNodeIndex, euclideanDistance, deltaY, radius);
                partials.xx += this.calculateSpringPartial3(this.m_layoutPass, distanceFromTouching, nodeIndex, otherNodeIndex, euclideanDistanceCubed, deltaY * deltaY, radius);
                partials.yy += this.calculateSpringPartial3(this.m_layoutPass, distanceFromTouching, nodeIndex, otherNodeIndex, euclideanDistanceCubed, deltaX * deltaX, radius);
                partials.xy += this.calculateSpringPartialCross(this.m_layoutPass, distanceFromTouching, nodeIndex, otherNodeIndex, euclideanDistanceCubed, deltaX * deltaY, radius);
                potentialEnergy[0] = potentialEnergy[0] + this.calculatePE(this.m_layoutPass, distanceFromRest, distanceFromTouching, nodeIndex, otherNodeIndex);
            }
            if (otherPartials == null) continue;
            if (!reversed) {
                otherPartials.x += this.calculateSpringPartial(this.m_layoutPass, distanceFromTouching, otherNodeIndex, nodeIndex, euclideanDistance, -deltaX, radius);
                otherPartials.y += this.calculateSpringPartial(this.m_layoutPass, distanceFromTouching, otherNodeIndex, nodeIndex, euclideanDistance, -deltaY, radius);
                otherPartials.xx += this.calculateSpringPartial3(this.m_layoutPass, distanceFromTouching, otherNodeIndex, nodeIndex, euclideanDistanceCubed, deltaY * deltaY, radius);
                otherPartials.yy += this.calculateSpringPartial3(this.m_layoutPass, distanceFromTouching, otherNodeIndex, nodeIndex, euclideanDistanceCubed, deltaX * deltaX, radius);
                otherPartials.xy += this.calculateSpringPartialCross(this.m_layoutPass, distanceFromTouching, nodeIndex, otherNodeIndex, euclideanDistanceCubed, deltaX * deltaY, radius);
                potentialEnergy[0] = potentialEnergy[0] + this.calculatePE(this.m_layoutPass, distanceFromRest, distanceFromTouching, nodeIndex, otherNodeIndex);
            } else {
                otherPartials.x -= this.calculateSpringPartial(this.m_layoutPass, distanceFromTouching, otherNodeIndex, nodeIndex, euclideanDistance, -deltaX, radius);
                otherPartials.y -= this.calculateSpringPartial(this.m_layoutPass, distanceFromTouching, otherNodeIndex, nodeIndex, euclideanDistance, -deltaY, radius);
                otherPartials.xx -= this.calculateSpringPartial3(this.m_layoutPass, distanceFromTouching, nodeIndex, otherNodeIndex, euclideanDistanceCubed, deltaY * deltaY, radius);
                otherPartials.yy -= this.calculateSpringPartial3(this.m_layoutPass, distanceFromTouching, nodeIndex, otherNodeIndex, euclideanDistanceCubed, deltaX * deltaX, radius);
                otherPartials.xy -= this.calculateSpringPartialCross(this.m_layoutPass, distanceFromTouching, nodeIndex, otherNodeIndex, euclideanDistanceCubed, deltaX * deltaY, radius);
                potentialEnergy[0] = potentialEnergy[0] - this.calculatePE(this.m_layoutPass, distanceFromRest, distanceFromTouching, nodeIndex, otherNodeIndex);
            }
            otherPartials.euclideanDistance = Math.sqrt(otherPartials.x * otherPartials.x + otherPartials.y * otherPartials.y);
            if (furthestPartials != null && !(otherPartials.euclideanDistance > furthestPartials.euclideanDistance)) continue;
            furthestPartials = otherPartials;
        }
        if (!reversed) {
            partials.euclideanDistance = Math.sqrt(partials.x * partials.x + partials.y * partials.y);
        }
        if (furthestPartials == null || partials.euclideanDistance > furthestPartials.euclideanDistance) {
            furthestPartials = partials;
        }
        return furthestPartials;
    }

    private PartialDerivatives moveNode(PartialDerivatives partials, List partialsList, double[] potentialEnergy) {
        PartialDerivatives startingPartials = new PartialDerivatives(partials);
        this.calculatePartials(partials, partialsList, potentialEnergy, true);
        try {
            this.simpleMoveNode(startingPartials);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return this.calculatePartials(partials, partialsList, potentialEnergy, false);
    }

    private void simpleMoveNode(PartialDerivatives partials) {
        LayoutNode node = partials.node;
        if (node.isLocked()) {
            return;
        }
        double denominator = partials.xx * partials.yy - partials.xy * partials.xy;
        if ((double)((float)denominator) == 0.0) {
            return;
        }
        double deltaX = (-partials.x * partials.yy - -partials.y * partials.xy) / denominator;
        double deltaY = (-partials.y * partials.xx - -partials.x * partials.xy) / denominator;
        node.setLocation(node.getX() + deltaX, node.getY() + deltaY);
    }

    private class PartialDerivatives {
        final LayoutNode node;
        double x;
        double y;
        double xx;
        double yy;
        double xy;
        double euclideanDistance;

        PartialDerivatives(LayoutNode node) {
            this.node = node;
        }

        PartialDerivatives(PartialDerivatives copyFrom) {
            this.node = copyFrom.node;
            this.copyFrom(copyFrom);
        }

        String printPartial() {
            String retVal = "Partials for node " + this.node.getIndex() + " are: " + this.x + "," + this.y + "," + this.xx + "," + this.yy + "," + this.xy + " dist = " + this.euclideanDistance;
            return retVal;
        }

        void reset() {
            this.x = 0.0;
            this.y = 0.0;
            this.xx = 0.0;
            this.yy = 0.0;
            this.xy = 0.0;
            this.euclideanDistance = 0.0;
        }

        void copyFrom(PartialDerivatives otherPartialDerivatives) {
            this.x = otherPartialDerivatives.x;
            this.y = otherPartialDerivatives.y;
            this.xx = otherPartialDerivatives.xx;
            this.yy = otherPartialDerivatives.yy;
            this.xy = otherPartialDerivatives.xy;
            this.euclideanDistance = otherPartialDerivatives.euclideanDistance;
        }
    }
}

