/*
 * Decompiled with CFR 0.152.
 */
package csapps.layout.algorithms;

import csapps.layout.algorithms.StackedNodeLayoutContext;
import java.util.Set;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.layout.AbstractLayoutTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.UndoSupport;

public class StackedNodeLayoutTask
extends AbstractLayoutTask {
    private StackedNodeLayoutContext context;

    public StackedNodeLayoutTask(String displayName, CyNetworkView networkView, StackedNodeLayoutContext context, Set<View<CyNode>> nodesToLayOut, String attr, UndoSupport undo) {
        super(displayName, networkView, nodesToLayOut, attr, undo);
        this.context = context;
    }

    protected final void doLayout(TaskMonitor taskMonitor) {
        this.construct(this.nodesToLayOut);
    }

    public void construct(Set<View<CyNode>> nodes) {
        double yPosition = 0.0;
        double xPosition = 0.0;
        for (View<CyNode> nodeView : nodes) {
            if (xPosition == 0.0 && yPosition == 0.0) {
                xPosition = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
                yPosition = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
            }
            int y = new Float(((Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_HEIGHT)).toString()).intValue();
            int x = new Float(((Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_WIDTH)).toString()).intValue();
            if (this.context.y_offset > 0.0) {
                yPosition += (double)(y / 2);
            }
            if (this.context.x_offset > 0.0) {
                xPosition += (double)(x / 2);
            }
            nodeView.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)xPosition);
            nodeView.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)yPosition);
            if (this.context.y_offset > 0.0) {
                yPosition += (double)(y / 2);
            }
            if (this.context.x_offset > 0.0) {
                xPosition += (double)(x / 2);
            }
            yPosition += this.context.y_offset;
            xPosition += this.context.x_offset;
        }
    }
}

