/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.impl.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import org.cytoscape.view.table.internal.impl.icon.VisualPropertyIcon;

public class FontFaceIcon
extends VisualPropertyIcon<Font> {
    private static final String TEXT = "A";
    private static final int FONT_SIZE = 28;

    public FontFaceIcon(Font value, int width, int height, String name) {
        super(value, width, height, name);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.value != null) {
            Font font = new Font(((Font)this.value).getFontName(), ((Font)this.value).getStyle(), 28);
            BufferedImage bi = this.createLargeImage(TEXT, font, c.getForeground());
            this.downSample(bi, c, g, x, y);
        }
    }

    private BufferedImage createLargeImage(String text, Font font, Color color) {
        FontRenderContext frc = new FontRenderContext(null, true, true);
        TextLayout layout = new TextLayout(text, font, frc);
        Rectangle r = layout.getPixelBounds(null, 0.0f, 0.0f);
        BufferedImage bi = new BufferedImage(r.width, r.height, 2);
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(color);
        layout.draw(g2d, 0.0f, -r.y);
        g2d.dispose();
        return bi;
    }

    private void downSample(BufferedImage bi, Component c, Graphics g, int x, int y) {
        int iw = bi.getWidth();
        int ih = bi.getHeight();
        double scale = Math.min((double)this.width / (double)iw, (double)this.height / (double)ih);
        AffineTransform at = new AffineTransform();
        if (scale < 0.0) {
            at.scale(scale, scale);
        }
        AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle2D r2d = scaleOp.getBounds2D(bi);
        double sh = r2d.getHeight();
        double sw = r2d.getWidth();
        int vpad = (int)((double)y + ((double)this.height - sh) / 2.0);
        int hpad = (int)((double)x + ((double)this.width - sw) / 2.0);
        g2d.drawImage(bi, scaleOp, hpad, vpad);
    }
}

