/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.impl;

import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.DynamicTaskFactoryProvisioner;
import org.cytoscape.task.TableCellTaskFactory;
import org.cytoscape.task.TableColumnTaskFactory;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.OpenBrowser;
import org.cytoscape.util.swing.PopupMenuGravityTracker;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.table.internal.impl.BrowserTableModel;
import org.cytoscape.view.table.internal.util.TableBrowserUtil;
import org.cytoscape.view.table.internal.util.ValidatedObjectAndEditString;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.Togglable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopupMenuHelper {
    private static float SMALL_ICON_FONT_SIZE = 14.0f;
    private static int SMALL_ICON_SIZE = 16;
    private final Map<TableCellTaskFactory, Map<?, ?>> tableCellFactoryMap;
    private final Map<TableColumnTaskFactory, Map<?, ?>> tableColumnFactoryMap;
    private final CyServiceRegistrar serviceRegistrar;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public PopupMenuHelper(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.tableCellFactoryMap = new HashMap();
        this.tableColumnFactoryMap = new HashMap();
    }

    public void createColumnHeaderMenu(CyColumn column, Class<? extends CyIdentifiable> tableType, Component invoker, int x, int y, final JTable table) {
        if (this.tableColumnFactoryMap.isEmpty()) {
            return;
        }
        JPopupMenu menu = new JPopupMenu();
        PopupMenuGravityTracker tracker = new PopupMenuGravityTracker(menu);
        DynamicTaskFactoryProvisioner factoryProvisioner = (DynamicTaskFactoryProvisioner)this.serviceRegistrar.getService(DynamicTaskFactoryProvisioner.class);
        for (Map.Entry<TableColumnTaskFactory, Map<?, ?>> entry : this.tableColumnFactoryMap.entrySet()) {
            TableColumnTaskFactory taskFactory = entry.getKey();
            TaskFactory provisioner = factoryProvisioner.createFor(taskFactory, column);
            this.createMenuItem(provisioner, tracker, entry.getValue(), tableType);
        }
        Font iconFont = ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(SMALL_ICON_FONT_SIZE);
        final TextIcon copyIcon = new TextIcon("\uf0c5", iconFont, SMALL_ICON_SIZE, SMALL_ICON_SIZE);
        menu.add(new JSeparator());
        menu.add(new JMenuItem(new AbstractAction("Copy Column Values"){
            {
                super(arg0);
                this.putValue("SmallIcon", copyIcon);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Action action = table.getActionMap().get("copy");
                if (action != null) {
                    action.actionPerformed(new ActionEvent(table, e.getID(), "copy"));
                }
            }
        }));
        PopupMenuHelper.sanitize(menu);
        if (menu.getSubElements().length > 0) {
            menu.show(invoker, x, y);
        }
    }

    public JPopupMenu createTableCellMenu(final CyColumn column, final Object primaryKeyValue, final Class<? extends CyIdentifiable> tableType, Component invoker, final int x, final int y, final JTable table) {
        String urlString;
        JPopupMenu menu = new JPopupMenu();
        Object value = column.getTable().getRow(primaryKeyValue).get(column.getName(), column.getType());
        if (value != null && (urlString = value.toString()) != null && (urlString.startsWith("http:") || urlString.startsWith("https:"))) {
            menu.add(this.getOpenLinkMenu(value.toString()));
        }
        PopupMenuGravityTracker tracker = new PopupMenuGravityTracker(menu);
        DynamicTaskFactoryProvisioner factoryProvisioner = (DynamicTaskFactoryProvisioner)this.serviceRegistrar.getService(DynamicTaskFactoryProvisioner.class);
        for (Map.Entry<TableCellTaskFactory, Map<?, ?>> entry : this.tableCellFactoryMap.entrySet()) {
            TableCellTaskFactory taskFactory = entry.getKey();
            TaskFactory provisioner = factoryProvisioner.createFor(taskFactory, column, primaryKeyValue);
            this.createMenuItem(provisioner, tracker, entry.getValue(), tableType);
        }
        menu.add(new JSeparator());
        Font iconFont = ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(SMALL_ICON_FONT_SIZE);
        final TextIcon editIcon = new TextIcon("\uf044", iconFont, SMALL_ICON_SIZE, SMALL_ICON_SIZE);
        final TextIcon copyIcon = new TextIcon("\uf0c5", iconFont, SMALL_ICON_SIZE, SMALL_ICON_SIZE);
        final TextIcon pasteIcon = new TextIcon("\uf0ea", iconFont, SMALL_ICON_SIZE, SMALL_ICON_SIZE);
        menu.add(new JMenuItem(new AbstractAction("Edit"){
            {
                super(arg0);
                this.putValue("SmallIcon", editIcon);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Point point = new Point(x, y);
                int row = table.rowAtPoint(point);
                int column = table.columnAtPoint(point);
                table.editCellAt(row, column);
                table.transferFocus();
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Copy"){
            {
                super(arg0);
                this.putValue("SmallIcon", copyIcon);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int column;
                Point point = new Point(x, y);
                int row = table.rowAtPoint(point);
                Object object = table.getValueAt(row, column = table.columnAtPoint(point));
                String data = object instanceof ValidatedObjectAndEditString ? TableBrowserUtil.createCopyString((ValidatedObjectAndEditString)object) : (object != null ? object.toString() : "");
                StringSelection stringSelection = new StringSelection(data);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Paste"){
            {
                super(arg0);
                this.putValue("SmallIcon", pasteIcon);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                CyRow sourceRow = column.getTable().getRow(primaryKeyValue);
                String columnName = column.getName();
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                try {
                    String pasteValue = (String)clipboard.getData(DataFlavor.stringFlavor);
                    List<Object> parsedData = TableBrowserUtil.parseCellInput(column.getTable(), columnName, pasteValue);
                    if (parsedData.get(0) != null) {
                        sourceRow.set(columnName, parsedData.get(0));
                    } else {
                        JOptionPane.showMessageDialog(null, parsedData.get(1), "Invalid Value", 0);
                    }
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    JOptionPane.showMessageDialog(null, ex.getMessage(), "Invalid Value", 0);
                    logger.warn("Error pasting cell value", (Throwable)ex);
                }
            }
        }));
        menu.add(new JSeparator());
        menu.add(new JMenuItem(new AbstractAction("Copy Selected"){
            {
                super(arg0);
                this.putValue("SmallIcon", copyIcon);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Action action = table.getActionMap().get("copy");
                if (action != null) {
                    action.actionPerformed(new ActionEvent(table, e.getID(), "copy"));
                }
            }
        }));
        if (tableType == CyNode.class || tableType == CyEdge.class) {
            menu.add(new JSeparator());
            String name = String.format("Select %s from selected rows", tableType == CyNode.class ? "nodes" : "edges");
            JMenuItem mi = new JMenuItem(new AbstractAction(name){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PopupMenuHelper.this.selectElementsFromSelectedRows(table, tableType);
                }

                @Override
                public boolean isEnabled() {
                    CyApplicationManager applicationManager = (CyApplicationManager)PopupMenuHelper.this.serviceRegistrar.getService(CyApplicationManager.class);
                    return table.getSelectedRowCount() > 0 && applicationManager.getCurrentNetwork() != null;
                }
            });
            menu.add(mi);
        }
        PopupMenuHelper.sanitize(menu);
        if (menu.getSubElements().length > 0) {
            menu.show(invoker, x, y);
        }
        return menu;
    }

    private void createMenuItem(TaskFactory tf, PopupMenuGravityTracker tracker, Map<?, ?> props, Class<? extends CyIdentifiable> tableType) {
        boolean insertSepAfter;
        Icon icon;
        Object title;
        if (!tf.isReady() || !this.enabledFor(tableType, props)) {
            return;
        }
        String menuGravity = (String)props.get("menuGravity");
        double gravity = menuGravity != null ? Double.parseDouble(menuGravity) : -1.0;
        boolean insertSepBefore = this.getBooleanProperty(props, "insertSeparatorBefore");
        if (insertSepBefore) {
            tracker.addMenuSeparator(gravity - 1.0E-4);
        }
        if ((title = (String)props.get("title")) == null) {
            title = "Unidentified Task: " + Integer.toString(tf.hashCode());
        }
        boolean togglable = tf instanceof Togglable;
        PopupAction action = new PopupAction(tf, (String)title);
        JMenuItem mi = togglable ? new JCheckBoxMenuItem(action) : new JMenuItem(action);
        tracker.addMenuItem(mi, gravity);
        Object iconId = props.get("smallIconID");
        if (iconId != null && !iconId.toString().trim().isEmpty() && (icon = ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIcon(iconId.toString())) != null) {
            mi.setIcon(icon);
        }
        if (togglable) {
            mi.setSelected(tf.isOn());
        }
        if (insertSepAfter = this.getBooleanProperty(props, "insertSeparatorAfter")) {
            tracker.addMenuSeparator(gravity + 1.0E-4);
        }
    }

    private boolean enabledFor(Class<? extends CyIdentifiable> tableType, Map<?, ?> props) {
        String types = (String)props.get("tableTypes");
        if (types == null) {
            return true;
        }
        for (String type : types.split(",")) {
            if ("all".equals(type = type.trim())) {
                return true;
            }
            if ("node".equals(type) && CyNode.class.equals(tableType)) {
                return true;
            }
            if ("edge".equals(type) && CyEdge.class.equals(tableType)) {
                return true;
            }
            if ("network".equals(type) && CyNetwork.class.equals(tableType)) {
                return true;
            }
            if (!"unassigned".equals(type) || tableType != null) continue;
            return true;
        }
        return false;
    }

    public void addTableColumnTaskFactory(TableColumnTaskFactory newFactory, Map<?, ?> properties) {
        this.tableColumnFactoryMap.put(newFactory, properties);
    }

    public void removeTableColumnTaskFactory(TableColumnTaskFactory factory, Map<?, ?> properties) {
        this.tableColumnFactoryMap.remove(factory);
    }

    public void addTableCellTaskFactory(TableCellTaskFactory newFactory, Map<?, ?> properties) {
        this.tableCellFactoryMap.put(newFactory, properties);
    }

    public void removeTableCellTaskFactory(TableCellTaskFactory factory, Map<?, ?> properties) {
        this.tableCellFactoryMap.remove(factory);
    }

    protected JMenuItem getOpenLinkMenu(Object url) {
        JMenuItem openLinkItem = new JMenuItem();
        openLinkItem.setText("Open URL in web browser...");
        if (url == null) {
            openLinkItem.setEnabled(false);
        } else if (!url.toString().startsWith("http:") && !url.toString().startsWith("https:")) {
            openLinkItem.setEnabled(false);
        } else {
            openLinkItem.addActionListener(evt -> {
                OpenBrowser openBrowser = (OpenBrowser)this.serviceRegistrar.getService(OpenBrowser.class);
                openBrowser.openURL(url.toString());
            });
        }
        return openLinkItem;
    }

    private void selectElementsFromSelectedRows(final JTable table, final Class<? extends CyIdentifiable> tableType) {
        Thread t = new Thread(){

            @Override
            public void run() {
                CyApplicationManager applicationManager = (CyApplicationManager)PopupMenuHelper.this.serviceRegistrar.getService(CyApplicationManager.class);
                CyNetwork net = applicationManager.getCurrentNetwork();
                if (net != null) {
                    BrowserTableModel tableModel = (BrowserTableModel)table.getModel();
                    int[] selectedRows = table.getSelectedRows();
                    HashSet<CyRow> targetRows = new HashSet<CyRow>();
                    for (int rowIndex : selectedRows) {
                        ValidatedObjectAndEditString selected = (ValidatedObjectAndEditString)tableModel.getValueAt(table.convertRowIndexToModel(rowIndex), "SUID");
                        targetRows.add(tableModel.getCyRow(selected.getValidatedObject()));
                    }
                    CyTable cyTable = tableType == CyNode.class ? net.getDefaultNodeTable() : net.getDefaultEdgeTable();
                    for (CyRow cyRow : cyTable.getAllRows()) {
                        cyRow.set("selected", (Object)targetRows.contains(cyRow));
                    }
                    CyNetworkView view = applicationManager.getCurrentNetworkView();
                    if (view != null) {
                        ((CyEventHelper)PopupMenuHelper.this.serviceRegistrar.getService(CyEventHelper.class)).flushPayloadEvents();
                        view.updateView();
                    }
                }
            }
        };
        t.start();
    }

    private boolean getBooleanProperty(Map<?, ?> props, String property) {
        String value = (String)props.get(property);
        if (value == null || value.length() == 0) {
            return false;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void sanitize(JPopupMenu menu) {
        boolean hasSeparator = false;
        for (int i = 0; i < menu.getComponentCount(); ++i) {
            Component comp = menu.getComponent(i);
            if (comp instanceof JSeparator) {
                if (hasSeparator || i == 0 || i == menu.getComponentCount() - 1) {
                    comp.setVisible(false);
                    continue;
                }
                hasSeparator = true;
                continue;
            }
            if (!comp.isVisible()) continue;
            hasSeparator = false;
        }
    }

    private class PopupAction
    extends AbstractAction {
        private final TaskFactory tf;

        PopupAction(TaskFactory tf, String menuLabel) {
            super(menuLabel);
            this.tf = tf;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TaskManager taskManager = (TaskManager)PopupMenuHelper.this.serviceRegistrar.getService(TaskManager.class);
            if (taskManager != null && this.tf != null) {
                taskManager.execute(this.tf.createTaskIterator());
            }
        }
    }
}

