/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.equation;

import java.util.Collection;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class ItemListPanel<T>
extends JPanel {
    private final String title;
    private JPanel topPanel;
    private JList<T> list;
    private JScrollPane scrollPane;

    public ItemListPanel(String title) {
        this.title = title;
        this.init();
    }

    private void init() {
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getTopPanel()).addComponent(this.getScrollPane()));
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.getTopPanel()).addComponent(this.getScrollPane()));
    }

    public void addElements(Collection<T> items) {
        DefaultListModel model = (DefaultListModel)this.getList().getModel();
        model.addAll(items);
    }

    public void addElement(T element) {
        DefaultListModel model = (DefaultListModel)this.getList().getModel();
        model.addElement(element);
    }

    public void clearSelection() {
        this.getList().clearSelection();
    }

    public T getSelectedValue() {
        return this.getList().getSelectedValue();
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            JLabel label = new JLabel(this.title);
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{label});
            this.topPanel = new JPanel();
            this.topPanel.setOpaque(!LookAndFeelUtil.isAquaLAF());
            this.topPanel.setLayout(new BoxLayout(this.topPanel, 0));
            this.topPanel.add(label);
            this.topPanel.add(Box.createHorizontalGlue());
        }
        return this.topPanel;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.getList());
            this.scrollPane.setVerticalScrollBarPolicy(22);
            this.scrollPane.setHorizontalScrollBarPolicy(31);
        }
        return this.scrollPane;
    }

    public JList<T> getList() {
        if (this.list == null) {
            this.list = new JList(new DefaultListModel());
            this.list.setSelectionMode(0);
        }
        return this.list;
    }
}

