/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.equation;

import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.model.table.CyTableViewManager;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.table.internal.TableRenderingEngineImpl;
import org.cytoscape.view.table.internal.equation.EquationEditorDialogFactory;
import org.cytoscape.view.table.internal.impl.BrowserTable;
import org.cytoscape.view.table.internal.impl.BrowserTableModel;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class EquationEditorTask
extends AbstractTask {
    private final CyServiceRegistrar registrar;
    private final CyTable table;

    public EquationEditorTask(CyServiceRegistrar registrar, CyTable table) {
        this.registrar = registrar;
        this.table = table;
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Open Equation Editor");
        BrowserTable browserTable = EquationEditorTask.getBrowserTable(this.table, this.registrar);
        if (browserTable == null) {
            return;
        }
        BrowserTableModel browserTableModel = browserTable.getBrowserTableModel();
        if (browserTableModel == null || browserTable.getCellEditor() != null) {
            return;
        }
        int cellRow = browserTable.getSelectedRow();
        int cellCol = browserTable.getSelectedColumn();
        int colIndex = -1;
        if (cellRow >= 0 && cellCol >= 0) {
            String colName = browserTable.getColumnName(cellCol);
            colIndex = browserTableModel.mapColumnNameToColumnIndex(colName);
        }
        if (cellRow == -1 || cellCol == -1 || !browserTableModel.isCellEditable(cellRow, colIndex)) {
            JFrame rootFrame = ((CySwingApplication)this.registrar.getService(CySwingApplication.class)).getJFrame();
            JOptionPane.showMessageDialog(rootFrame, "Can't enter a formula w/o a selected cell.", "Information", 1);
            return;
        }
        EquationEditorDialogFactory mediator = (EquationEditorDialogFactory)this.registrar.getService(EquationEditorDialogFactory.class);
        SwingUtilities.invokeLater(() -> mediator.openEquationEditorDialog(browserTable));
    }

    public static BrowserTable getBrowserTable(CyTable table, CyServiceRegistrar registrar) {
        CyTableViewManager tableViewManager = (CyTableViewManager)registrar.getService(CyTableViewManager.class);
        CyTableView view = tableViewManager.getTableView(table);
        TableRenderingEngineImpl re = EquationEditorTask.getRenderingEngine(view, registrar);
        if (re == null) {
            return null;
        }
        return re.getBrowserTable();
    }

    private static TableRenderingEngineImpl getRenderingEngine(CyTableView view, CyServiceRegistrar registrar) {
        RenderingEngineManager renderingEngineManager = (RenderingEngineManager)registrar.getService(RenderingEngineManager.class);
        Collection renderingEngines = renderingEngineManager.getRenderingEngines((View)view);
        for (RenderingEngine re : renderingEngines) {
            if (!"org.cytoscape.view.table.renderer".equals(re.getRendererId())) continue;
            return (TableRenderingEngineImpl)re;
        }
        return null;
    }
}

