/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.equation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.HyperlinkEvent;
import org.cytoscape.application.swing.CyColumnPresentationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.equations.Equation;
import org.cytoscape.equations.EquationCompiler;
import org.cytoscape.equations.EquationParser;
import org.cytoscape.equations.Function;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.table.internal.equation.ApplyWorker;
import org.cytoscape.view.table.internal.equation.EquationEditorPanel;
import org.cytoscape.view.table.internal.equation.FunctionInfo;
import org.cytoscape.view.table.internal.equation.ItemListPanel;
import org.cytoscape.view.table.internal.equation.SyntaxAreaPanel;
import org.cytoscape.view.table.internal.equation.TutorialItems;
import org.cytoscape.view.table.internal.impl.BrowserTable;
import org.cytoscape.view.table.internal.impl.BrowserTableModel;
import org.cytoscape.view.table.internal.util.TableBrowserUtil;

public class EquationEditorMediator {
    private final CyServiceRegistrar registrar;
    private final BrowserTable browserTable;
    private final EquationEditorPanel builderPanel;
    private final CyColumn column;
    private final int currentRowIndex;

    private EquationEditorMediator(CyColumn column, BrowserTable browserTable, EquationEditorPanel builderPanel, CyServiceRegistrar registrar) {
        this.browserTable = browserTable;
        this.registrar = registrar;
        this.builderPanel = builderPanel;
        this.column = column;
        this.currentRowIndex = browserTable.convertRowIndexToModel(browserTable.getSelectedRow());
    }

    public static void openEquationEditorDialog(BrowserTable browserTable, String equation, CyServiceRegistrar registrar) {
        JFrame parent = ((CySwingApplication)registrar.getService(CySwingApplication.class)).getJFrame();
        JDialog dialog = new JDialog(parent);
        BrowserTableModel tableModel = browserTable.getBrowserTableModel();
        int cellCol = browserTable.convertColumnIndexToModel(browserTable.getSelectedColumn());
        CyColumn column = tableModel.getCyColumn(cellCol);
        EquationEditorPanel builderPanel = new EquationEditorPanel(registrar, browserTable);
        EquationEditorMediator mediator = new EquationEditorMediator(column, browserTable, builderPanel, registrar);
        mediator.wireTogether(dialog);
        String attribName = column.getName();
        dialog.setTitle("Formula Builder for " + attribName);
        dialog.setModal(true);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)builderPanel, "Center");
        dialog.setPreferredSize(new Dimension(600, 600));
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        builderPanel.getSyntaxPanel().getSyntaxTextArea().addAncestorListener((AncestorListener)new RequestFocusListener());
        builderPanel.getSyntaxPanel().setText(equation);
        dialog.setVisible(true);
    }

    private void wireTogether(JDialog dialog) {
        this.initializeTutorialList();
        this.initializeFunctionList();
        this.initializeAttributeList();
        this.builderPanel.getCloseButton().addActionListener(e -> dialog.dispose());
        SyntaxAreaPanel syntaxPanel = this.builderPanel.getSyntaxPanel();
        syntaxPanel.getApplyButton().addActionListener(e -> this.handleApply(true));
        syntaxPanel.getEvalButton().addActionListener(e -> this.handleApply(false));
        this.builderPanel.getInfoPanel().getTextArea().addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.handleInsert();
            }
        });
    }

    private void initializeTutorialList() {
        this.builderPanel.getTutorialPanel().addElements(TutorialItems.getTutorialItems());
        JList<String> list = this.builderPanel.getTutorialPanel().getList();
        list.addListSelectionListener(e -> {
            String item = (String)list.getSelectedValue();
            if (item != null) {
                this.builderPanel.getAttributePanel().clearSelection();
                this.builderPanel.getFunctionPanel().clearSelection();
                String docs = TutorialItems.getTutorialDocs(item);
                this.builderPanel.getInfoPanel().setText(docs);
            }
        });
    }

    private void initializeFunctionList() {
        this.initializeFunctionListContents();
        this.initializeFunctionListComponents();
    }

    private void initializeFunctionListContents() {
        EquationParser equationParser = (EquationParser)this.registrar.getService(EquationParser.class);
        TreeMap<String, SortedMap> categories = new TreeMap<String, SortedMap>();
        for (Function f : equationParser.getRegisteredFunctions()) {
            for (String category : EquationEditorMediator.getCategoriesFor(f)) {
                SortedMap sortedMap = categories.computeIfAbsent(category, k -> new TreeMap());
                sortedMap.put(f.getName(), f);
            }
        }
        ItemListPanel<FunctionInfo> functionPanel = this.builderPanel.getFunctionPanel();
        List<String> topCategories = Arrays.asList("Numeric", "Text", "List", "Logic", "Network");
        for (String string : topCategories) {
            SortedMap functions = (SortedMap)categories.remove(string);
            if (functions == null) continue;
            functionPanel.addElement(FunctionInfo.category(string));
            for (Map.Entry entry : functions.entrySet()) {
                Function f = (Function)entry.getValue();
                functionPanel.addElement(FunctionInfo.function(f));
            }
        }
        for (Map.Entry entry : categories.entrySet()) {
            String categoryName = (String)entry.getKey();
            SortedMap functions = (SortedMap)entry.getValue();
            functionPanel.addElement(FunctionInfo.category(categoryName));
            for (Map.Entry functionEntry : functions.entrySet()) {
                Function f = (Function)functionEntry.getValue();
                functionPanel.addElement(FunctionInfo.function(f));
            }
        }
    }

    private static String[] getCategoriesFor(Function f) {
        String categoryList = f.getCategoryName();
        if (categoryList == null || categoryList.isBlank()) {
            return new String[]{"Other"};
        }
        String[] split = categoryList.split(",");
        if (split == null) {
            return new String[]{"Other"};
        }
        return split;
    }

    private void initializeFunctionListComponents() {
        ItemListPanel<FunctionInfo> functionPanel = this.builderPanel.getFunctionPanel();
        JList<FunctionInfo> list = functionPanel.getList();
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                FunctionInfo functionInfo = (FunctionInfo)value;
                if (functionInfo.isCategoryHeader()) {
                    Font font = this.getFont();
                    Font bold = font.deriveFont(1);
                    this.setFont(bold);
                    this.setText(functionInfo.getName());
                    this.setBackground(EquationEditorMediator.slightlyDarker(this.getBackground()));
                } else {
                    this.setText("  " + functionInfo.getName());
                }
                return this;
            }
        });
        list.addMouseListener(new ListInsertListener());
        list.addListSelectionListener(e -> {
            FunctionInfo functionInfo = (FunctionInfo)list.getSelectedValue();
            if (functionInfo != null) {
                this.builderPanel.getAttributePanel().clearSelection();
                this.builderPanel.getTutorialPanel().clearSelection();
                if (functionInfo.isCategoryHeader()) {
                    this.builderPanel.getInfoPanel().setText("");
                } else {
                    Function f = functionInfo.getFunction();
                    String docs = TutorialItems.getFunctionDocs(f);
                    this.builderPanel.getInfoPanel().setText(docs);
                }
            }
        });
    }

    private static Color slightlyDarker(Color color) {
        double f = 0.9;
        return new Color(Math.max((int)((double)color.getRed() * f), 0), Math.max((int)((double)color.getGreen() * f), 0), Math.max((int)((double)color.getBlue() * f), 0));
    }

    private void initializeAttributeList() {
        this.builderPanel.getAttributePanel().getList().setCellRenderer(new DefaultListCellRenderer(){
            CyColumnPresentationManager presentationManager;
            {
                this.presentationManager = (CyColumnPresentationManager)EquationEditorMediator.this.registrar.getService(CyColumnPresentationManager.class);
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int i, boolean selected, boolean hasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, i, selected, hasFocus);
                CyColumn col = (CyColumn)value;
                this.presentationManager.setLabel(col.getName(), (JLabel)this);
                return this;
            }
        });
        BrowserTableModel model = (BrowserTableModel)this.browserTable.getModel();
        CyTable table = model.getDataTable();
        ArrayList<CyColumn> columns = new ArrayList<CyColumn>(table.getColumns());
        columns.sort(Comparator.comparing(col -> col.isPrimaryKey() && "SUID".equals(col.getName())).thenComparing(CyColumn::getNamespace, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(CyColumn::getNameOnly, Comparator.naturalOrder()));
        this.builderPanel.getAttributePanel().addElements(columns);
        JList<CyColumn> list = this.builderPanel.getAttributePanel().getList();
        list.addMouseListener(new ListInsertListener());
        list.addListSelectionListener(e -> {
            CyColumn col = (CyColumn)list.getSelectedValue();
            if (col != null) {
                this.builderPanel.getFunctionPanel().clearSelection();
                this.builderPanel.getTutorialPanel().clearSelection();
                String docs = TutorialItems.getColumnDocs(col);
                this.builderPanel.getInfoPanel().setText(docs);
            }
        });
    }

    private void handleInsert() {
        SyntaxAreaPanel syntaxPanel = this.builderPanel.getSyntaxPanel();
        int offset = syntaxPanel.getCaretPosition();
        if (offset < 0) {
            return;
        }
        FunctionInfo function = this.builderPanel.getFunctionPanel().getSelectedValue();
        if (function != null && !function.isCategoryHeader()) {
            syntaxPanel.insertText(offset, function.getName() + "(", ")");
            return;
        }
        CyColumn col = this.builderPanel.getAttributePanel().getSelectedValue();
        if (col != null) {
            String ref = EquationEditorMediator.getAttributeReference(col);
            syntaxPanel.insertText(offset, ref, null);
            return;
        }
    }

    public static String getAttributeReference(CyColumn column) {
        String name = column.getName();
        boolean simple = name.chars().allMatch(Character::isAlphabetic);
        if (simple) {
            return "$" + name;
        }
        return "${" + name + "}";
    }

    private String getEquationText() {
        Object equation = this.builderPanel.getSyntaxPanel().getText();
        if (!((String)(equation = ((String)equation).trim())).startsWith("=")) {
            equation = "=" + (String)equation;
        }
        return equation;
    }

    private void handleApply(boolean insert) {
        Equation equation = this.compileEquation(this.column);
        if (equation != null) {
            Collection<CyRow> rows = this.getRowsForApply();
            this.applyToRows(equation, this.column, rows, insert);
        }
    }

    private Equation compileEquation(CyColumn col) {
        String attribName;
        Map<String, Class<?>> attrNameToTypeMap;
        BrowserTableModel tableModel = this.browserTable.getBrowserTableModel();
        CyTable attribs = tableModel.getDataTable();
        String equationText = this.getEquationText();
        EquationCompiler compiler = (EquationCompiler)this.registrar.getService(EquationCompiler.class);
        boolean success = compiler.compile(equationText, attrNameToTypeMap = TableBrowserUtil.getAttNameToTypeMap(attribs, attribName = col.getName()));
        if (!success) {
            int location = compiler.getErrorLocation();
            String msg = compiler.getLastErrorMsg();
            this.builderPanel.getSyntaxPanel().showSyntaxError(location, msg);
            return null;
        }
        return compiler.getEquation();
    }

    private Collection<CyRow> getRowsForApply() {
        BrowserTableModel tableModel = this.browserTable.getBrowserTableModel();
        ApplyScope scope = this.builderPanel.getSyntaxPanel().getApplyScope();
        switch (scope) {
            case CURRENT_CELL: {
                return Collections.singletonList(tableModel.getCyRow(this.currentRowIndex));
            }
            case CURRENT_SELECTION: {
                return tableModel.getDataTable().getMatchingRows("selected", (Object)true);
            }
            case ENTIRE_COLUMN: {
                return tableModel.getDataTable().getAllRows();
            }
        }
        return Collections.emptyList();
    }

    private void applyToRows(Equation equation, CyColumn col, Collection<CyRow> rows, boolean insert) {
        ApplyWorker worker = new ApplyWorker(this.registrar, this.builderPanel, equation, col, rows, insert);
        worker.execute();
    }

    private class ListInsertListener
    extends MouseAdapter {
        private ListInsertListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                EquationEditorMediator.this.handleInsert();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int index;
            JList list = (JList)e.getSource();
            if (e.isPopupTrigger() && (index = list.locationToIndex(e.getPoint())) != -1 && list.getCellBounds(index, index).contains(e.getPoint())) {
                list.setSelectedIndex(index);
                JPopupMenu menu = new JPopupMenu();
                menu.add(new AbstractAction("Insert"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EquationEditorMediator.this.handleInsert();
                    }
                });
                menu.show(list, e.getX(), e.getY());
            }
        }
    }

    private static class RequestFocusListener
    implements AncestorListener {
        private RequestFocusListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent e) {
            JComponent c = e.getComponent();
            c.requestFocusInWindow();
            c.removeAncestorListener(this);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }

    public static enum ApplyScope {
        CURRENT_CELL("Current cell only"),
        CURRENT_SELECTION("Current selection"),
        ENTIRE_COLUMN("Entire column");

        private final String text;

        private ApplyScope(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public static ApplyScope[] values(boolean includeSelected) {
            if (includeSelected) {
                return ApplyScope.values();
            }
            return new ApplyScope[]{CURRENT_CELL, ENTIRE_COLUMN};
        }
    }
}

