/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal;

import java.util.Collection;
import java.util.HashSet;
import javax.swing.table.TableColumn;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.events.TableViewChangedEvent;
import org.cytoscape.view.model.events.TableViewChangedListener;
import org.cytoscape.view.model.events.ViewChangeRecord;
import org.cytoscape.view.model.table.CyColumnView;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;
import org.cytoscape.view.presentation.property.table.TableMode;
import org.cytoscape.view.table.internal.impl.BrowserTable;
import org.cytoscape.view.table.internal.impl.BrowserTableColumnModel;
import org.cytoscape.view.table.internal.impl.BrowserTableColumnModelGravityEvent;
import org.cytoscape.view.table.internal.impl.BrowserTableColumnModelListener;
import org.cytoscape.view.table.internal.impl.BrowserTableModel;
import org.cytoscape.view.table.internal.util.ViewUtil;

public class VisualPropertyChangeListener
implements TableViewChangedListener {
    private final CyTableView tableView;
    private final BrowserTable browserTable;

    public VisualPropertyChangeListener(BrowserTable browserTable, CyTableView tableView) {
        this.tableView = tableView;
        this.browserTable = browserTable;
        this.handleTableColumnReorder();
    }

    private void handleTableColumnReorder() {
        BrowserTableColumnModel colModel = (BrowserTableColumnModel)this.browserTable.getColumnModel();
        colModel.addBrowserTableColumnModelListener(new BrowserTableColumnModelListener(){

            @Override
            public void columnGravityChanged(BrowserTableColumnModelGravityEvent event) {
                View colView1 = VisualPropertyChangeListener.this.tableView.getColumnView(event.getColumn1Suid().longValue());
                View colView2 = VisualPropertyChangeListener.this.tableView.getColumnView(event.getColumn2Suid().longValue());
                double colGrav1 = event.getColumn1Gravity();
                double colGrav2 = event.getColumn2Gravity();
                colView1.setLockedValue(BasicTableVisualLexicon.COLUMN_GRAVITY, (Object)colGrav1);
                colView2.setLockedValue(BasicTableVisualLexicon.COLUMN_GRAVITY, (Object)colGrav2);
            }
        });
    }

    public void handleEvent(TableViewChangedEvent<?> e) {
        if (e.getSource() != this.tableView) {
            return;
        }
        boolean reorderCols = false;
        for (ViewChangeRecord record : e.getPayloadCollection()) {
            VisualProperty vp = record.getVisualProperty();
            Object value = record.getValue();
            Object model = record.getView().getModel();
            if (model instanceof CyColumn) {
                CyColumnView colView = (CyColumnView)record.getView();
                this.updateColumnVP(colView, vp, value);
                if (vp != BasicTableVisualLexicon.COLUMN_GRAVITY) continue;
                reorderCols = true;
                continue;
            }
            if (model instanceof CyRow) {
                View rowView = record.getView();
                this.updateRowVP((View<CyRow>)rowView, vp, value);
                continue;
            }
            if (!(model instanceof CyTable)) continue;
            if (vp == BasicTableVisualLexicon.TABLE_VIEW_MODE) {
                this.changeSelectionMode((TableMode)value);
                continue;
            }
            if (vp == BasicTableVisualLexicon.TABLE_ROW_HEIGHT) {
                ViewUtil.invokeOnEDT(() -> this.browserTable.resetRowHeight());
                continue;
            }
            if (vp == BasicTableVisualLexicon.TABLE_GRID_VISIBLE) {
                ViewUtil.invokeOnEDT(() -> this.browserTable.setShowGrid(Boolean.TRUE.equals(value)));
                continue;
            }
            if (vp != BasicTableVisualLexicon.TABLE_ALTERNATE_ROW_COLORS) continue;
            ViewUtil.invokeOnEDT(() -> this.browserTable.repaint());
        }
        if (reorderCols) {
            BrowserTableColumnModel colModel = (BrowserTableColumnModel)this.browserTable.getColumnModel();
            colModel.reorderColumnsToRespectGravity();
        }
    }

    private void updateColumnVP(CyColumnView colView, VisualProperty<?> vp, Object value) {
        BrowserTableColumnModel colModel = (BrowserTableColumnModel)this.browserTable.getColumnModel();
        if (vp == BasicTableVisualLexicon.COLUMN_VISIBLE) {
            boolean visible = Boolean.TRUE.equals(value);
            TableColumn col = colModel.getTableColumn(colView.getSUID());
            colModel.setColumnVisible(col, visible);
        } else if (vp == BasicTableVisualLexicon.CELL_BACKGROUND_PAINT) {
            ViewUtil.invokeOnEDT(() -> this.browserTable.repaint());
        } else if (vp == BasicTableVisualLexicon.COLUMN_FORMAT) {
            ViewUtil.invokeOnEDT(() -> this.browserTable.repaint());
        } else if (vp == BasicTableVisualLexicon.COLUMN_WIDTH) {
            TableColumn col;
            int width;
            if (value instanceof Number && (width = ((Number)value).intValue()) > 0 && width != (col = colModel.getTableColumn(colView.getSUID())).getWidth()) {
                ViewUtil.invokeOnEDT(() -> {
                    col.setPreferredWidth(width);
                    col.setWidth(width);
                    this.browserTable.revalidate();
                    this.browserTable.repaint();
                });
            }
        } else if (vp == BasicTableVisualLexicon.COLUMN_TEXT_WRAPPED) {
            ViewUtil.invokeOnEDT(() -> {
                if (Boolean.TRUE.equals(value)) {
                    this.browserTable.revalidate();
                    this.browserTable.repaint();
                } else {
                    this.browserTable.resetRowHeight();
                }
                this.browserTable.fireRowHeightChange(0, this.browserTable.getRowHeight());
            });
        } else if (vp == BasicTableVisualLexicon.COLUMN_GRAVITY) {
            if (value instanceof Number) {
                double gravity = ((Number)value).doubleValue();
                TableColumn column = colModel.getTableColumn(colView.getSUID());
                if (column != null) {
                    colModel.setColumnGravity(column, gravity);
                }
            }
        } else if (vp == BasicTableVisualLexicon.COLUMN_SELECTED && value instanceof Boolean) {
            boolean selected = Boolean.TRUE.equals(value);
            int idx = this.browserTable.getColumnModel().getColumnIndex(colView.getSUID());
            if (idx >= 0 && idx < this.browserTable.getColumnCount() && selected != this.browserTable.isColumnSelected(idx)) {
                if (selected) {
                    this.browserTable.addColumnSelectionInterval(idx, idx);
                } else {
                    this.browserTable.removeColumnSelectionInterval(idx, idx);
                }
            }
        }
    }

    private void updateRowVP(View<CyRow> rowView, VisualProperty<?> vp, Object value) {
        if (vp == BasicTableVisualLexicon.ROW_HEIGHT) {
            int h;
            if (value instanceof Number && (h = ((Number)value).intValue()) > 0) {
                BrowserTableModel tableModel = this.browserTable.getBrowserTableModel();
                String pkName = ((CyTable)this.tableView.getModel()).getPrimaryKey().getName();
                Object pk = ((CyRow)rowView.getModel()).getRaw(pkName);
                if (pk != null) {
                    int idx = tableModel.indexOfRow((CyRow)rowView.getModel());
                    if ((idx = this.browserTable.convertRowIndexToView(idx)) >= 0 && idx < this.browserTable.getRowCount() && h != this.browserTable.getRowHeight(idx)) {
                        this.browserTable.setRowHeight(idx, h);
                    }
                }
            }
        } else if (vp == BasicTableVisualLexicon.ROW_SELECTED && value instanceof Boolean) {
            boolean selected = Boolean.TRUE.equals(value);
            BrowserTableModel tableModel = this.browserTable.getBrowserTableModel();
            String pkName = ((CyTable)this.tableView.getModel()).getPrimaryKey().getName();
            Object pk = ((CyRow)rowView.getModel()).getRaw(pkName);
            if (pk != null) {
                int idx = tableModel.indexOfRow((CyRow)rowView.getModel());
                if ((idx = this.browserTable.convertRowIndexToView(idx)) >= 0 && idx < this.browserTable.getRowCount() && selected != this.browserTable.isRowSelected(idx)) {
                    if (selected) {
                        this.browserTable.addRowSelectionInterval(idx, idx);
                    } else {
                        this.browserTable.removeRowSelectionInterval(idx, idx);
                    }
                }
            }
        }
    }

    private void changeSelectionMode(TableMode tableMode) {
        BrowserTableModel tableModel = this.browserTable.getBrowserTableModel();
        BrowserTableModel.ViewMode viewMode = BrowserTableModel.ViewMode.fromVisualPropertyValue(tableMode);
        tableModel.setViewMode(viewMode);
        tableModel.updateViewMode();
        if (viewMode == BrowserTableModel.ViewMode.ALL && ((CyTable)this.tableView.getModel()).getColumn("selected") != null) {
            HashSet<Long> suidSelected = new HashSet<Long>();
            HashSet<Long> suidUnselected = new HashSet<Long>();
            Collection selectedRows = ((CyTable)this.tableView.getModel()).getMatchingRows("selected", (Object)Boolean.TRUE);
            for (CyRow row : selectedRows) {
                suidSelected.add((Long)row.get("SUID", Long.class));
            }
            if (!suidSelected.isEmpty()) {
                this.browserTable.changeRowSelection(suidSelected, suidUnselected);
            }
        }
    }
}

