/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.Printable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableModel;
import org.cytoscape.equations.EquationCompiler;
import org.cytoscape.event.DebounceTimer;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.events.TableViewChangedListener;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.table.internal.VisualPropertyChangeListener;
import org.cytoscape.view.table.internal.impl.BrowserTable;
import org.cytoscape.view.table.internal.impl.BrowserTableModel;
import org.cytoscape.view.table.internal.impl.BrowserTableRowHeader;
import org.cytoscape.view.table.internal.impl.BrowserTableRowHeaderRenderer;
import org.cytoscape.view.table.internal.impl.PopupMenuHelper;
import org.cytoscape.view.table.internal.impl.icon.VisualPropertyIconFactory;
import org.cytoscape.view.table.internal.util.ViewUtil;

public class TableRenderingEngineImpl
implements RenderingEngine<CyTable> {
    private static float SMALL_ICON_FONT_SIZE = 14.0f;
    private static int SMALL_ICON_SIZE = 16;
    private final CyTableView tableView;
    private final VisualLexicon lexicon;
    private final PopupMenuHelper popupMenuHelper;
    private final CyServiceRegistrar registrar;
    private BrowserTable browserTable;
    private BrowserTableRowHeader rowHeader;
    private CornerPanel cornerPanel;
    private VisualPropertyChangeListener vpChangeListener;
    private final Icon copyIcon;
    private boolean ignoreHeaderSelectionEvents;
    private boolean ignoreTableSelectionEvents;
    private final DebounceTimer rowSelectionTimer;

    public TableRenderingEngineImpl(CyTableView tableView, VisualLexicon lexicon, PopupMenuHelper popupMenuHelper, CyServiceRegistrar registrar) {
        this.tableView = tableView;
        this.lexicon = lexicon;
        this.popupMenuHelper = popupMenuHelper;
        this.registrar = registrar;
        IconManager iconManager = (IconManager)registrar.getService(IconManager.class);
        Font iconFont = iconManager.getIconFont(SMALL_ICON_FONT_SIZE);
        this.copyIcon = new TextIcon("\uf0c5", iconFont, SMALL_ICON_SIZE, SMALL_ICON_SIZE);
        this.rowSelectionTimer = new DebounceTimer(25);
    }

    public void install(JComponent component) {
        this.vpChangeListener = new VisualPropertyChangeListener(this.getBrowserTable(), this.tableView);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.getBrowserTable());
        scrollPane.setRowHeaderView(this.getRowHeader());
        scrollPane.setCorner("UPPER_LEADING_CORNER", this.getCornerPanel());
        scrollPane.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (!evt.isPopupTrigger()) {
                    TableRenderingEngineImpl.this.getBrowserTable().clearSelection();
                }
            }
        });
        component.setLayout(new BorderLayout());
        component.add(scrollPane);
        this.getBrowserTable().addPropertyChangeListener("rowHeight", evt -> this.getRowHeader().update());
        this.getBrowserTable().addPropertyChangeListener("rowHeightChanged", evt -> this.getRowHeader().update());
        this.getBrowserTable().getModel().addTableModelListener(evt -> {
            this.getRowHeader().updateModel();
            this.getCornerPanel().update();
        });
        this.getBrowserTable().getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent evt) {
                TableRenderingEngineImpl.this.getRowHeader().update();
                TableRenderingEngineImpl.this.getCornerPanel().update();
            }

            @Override
            public void columnRemoved(TableColumnModelEvent evt) {
                TableRenderingEngineImpl.this.getRowHeader().update();
                TableRenderingEngineImpl.this.getCornerPanel().update();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent evt) {
                if (!TableRenderingEngineImpl.this.ignoreTableSelectionEvents) {
                    TableRenderingEngineImpl.this.updateHeader();
                }
            }

            @Override
            public void columnMoved(TableColumnModelEvent evt) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent evt) {
            }
        });
        this.getBrowserTable().getSelectionModel().addListSelectionListener(evt -> {
            if (!this.ignoreTableSelectionEvents && !this.rowSelectionTimer.isShutdown()) {
                this.rowSelectionTimer.debounce(() -> ViewUtil.invokeOnEDT(() -> {
                    this.ignoreHeaderSelectionEvents = true;
                    try {
                        boolean allColumnsSelected = this.isAllTableColumnsSelected();
                        BrowserTable tbl = this.getBrowserTable();
                        BrowserTableRowHeader rh = this.getRowHeader();
                        int rowCount = tbl.getRowCount();
                        for (int i = 0; i < rowCount; ++i) {
                            if (allColumnsSelected && tbl.isRowSelected(i)) {
                                if (rh.isSelectedIndex(i)) continue;
                                rh.addSelectionInterval(i, i);
                                continue;
                            }
                            if (!rh.isSelectedIndex(i)) continue;
                            rh.removeSelectionInterval(i, i);
                        }
                    }
                    finally {
                        this.ignoreHeaderSelectionEvents = false;
                    }
                    this.updateHeader();
                }));
            }
        });
        this.getRowHeader().getSelectionModel().addListSelectionListener(evt -> {
            if (!evt.getValueIsAdjusting() && !this.ignoreHeaderSelectionEvents) {
                int rowCount = this.getBrowserTable().getRowCount();
                int columnCount = this.getBrowserTable().getColumnCount();
                if (rowCount > 0 && columnCount > 0) {
                    int[] indices = this.getRowHeader().getSelectionModel().getSelectedIndices();
                    this.ignoreTableSelectionEvents = true;
                    try {
                        for (int i = 0; i < rowCount; ++i) {
                            if (Arrays.binarySearch(indices, i) >= 0) {
                                if (this.getBrowserTable().isRowSelected(i)) continue;
                                this.getBrowserTable().addRowSelectionInterval(i, i);
                                continue;
                            }
                            if (!this.getBrowserTable().isRowSelected(i)) continue;
                            this.getBrowserTable().removeRowSelectionInterval(i, i);
                        }
                        this.getBrowserTable().getColumnModel().getSelectionModel().addSelectionInterval(0, columnCount - 1);
                    }
                    finally {
                        this.ignoreTableSelectionEvents = false;
                    }
                    this.updateHeader();
                }
            }
        });
        this.registerServices();
    }

    public void dispose() {
        this.rowSelectionTimer.shutdown();
        this.unregisterServices();
    }

    public Collection<View<CyRow>> getSelectedRows() {
        CyRow row;
        View rowView;
        TableModel model;
        int selectedRow = this.getBrowserTable().getSelectedRow();
        if (selectedRow >= 0 && (model = this.getBrowserTable().getModel()) instanceof BrowserTableModel && (rowView = this.tableView.getRowView(row = ((BrowserTableModel)model).getCyRow(selectedRow))) != null) {
            return Collections.singletonList(rowView);
        }
        return Collections.emptyList();
    }

    public View<CyColumn> getSelectedColumn() {
        int selectedColumn = this.getBrowserTable().getSelectedColumn();
        if (selectedColumn >= 0) {
            int cellColum = this.getBrowserTable().convertColumnIndexToModel(selectedColumn);
            String colName = this.getBrowserTable().getColumnName(cellColum);
            CyColumn column = ((CyTable)this.tableView.getModel()).getColumn(colName);
            return this.tableView.getColumnView(column);
        }
        return null;
    }

    public CyTableView getViewModel() {
        return this.tableView;
    }

    public String getRendererId() {
        return "org.cytoscape.view.table.renderer";
    }

    public VisualLexicon getVisualLexicon() {
        return this.lexicon;
    }

    public Properties getProperties() {
        return null;
    }

    public Printable createPrintable() {
        return null;
    }

    public Image createImage(int width, int height) {
        return null;
    }

    public <V> Icon createIcon(VisualProperty<V> vp, V value, int width, int height) {
        return VisualPropertyIconFactory.createIcon(value, width, height);
    }

    public void printCanvas(Graphics printCanvas) {
    }

    public BrowserTable getBrowserTable() {
        if (this.browserTable == null) {
            EquationCompiler compiler = (EquationCompiler)this.registrar.getService(EquationCompiler.class);
            this.browserTable = new BrowserTable(this.popupMenuHelper, this.registrar);
            BrowserTableModel model = new BrowserTableModel(this.tableView, compiler);
            this.browserTable.setAutoResizeMode(0);
            this.browserTable.setModel(model);
            if (this.browserTable.getDropTarget() != null) {
                this.browserTable.getDropTarget().setActive(false);
            }
        }
        return this.browserTable;
    }

    private BrowserTableRowHeader getRowHeader() {
        if (this.rowHeader == null) {
            this.rowHeader = new BrowserTableRowHeader(this.getBrowserTable());
            this.rowHeader.setOpaque(false);
            this.rowHeader.setFixedCellWidth(20);
            this.rowHeader.setCellRenderer(new BrowserTableRowHeaderRenderer(this.getBrowserTable()));
            this.rowHeader.setBackground(this.getBrowserTable().getBackground());
            this.rowHeader.setForeground(this.getBrowserTable().getForeground());
            this.rowHeader.setCursor(new Cursor(1));
            this.rowHeader.getActionMap().put("copy", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TableRenderingEngineImpl.this.copyFromTable(evt.getID());
                }
            });
            this.rowHeader.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    this.maybeShowPopup(evt);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    this.maybeShowPopup(evt);
                }

                private void maybeShowPopup(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        int index = TableRenderingEngineImpl.this.rowHeader.locationToIndex(evt.getPoint());
                        if (index >= 0 && !TableRenderingEngineImpl.this.rowHeader.isSelectedIndex(index)) {
                            TableRenderingEngineImpl.this.rowHeader.setSelectedIndex(index);
                        }
                        JPopupMenu popup = new JPopupMenu();
                        JMenuItem mi = new JMenuItem("Copy", TableRenderingEngineImpl.this.copyIcon);
                        mi.addActionListener(mie -> TableRenderingEngineImpl.this.copyFromTable(mie.getID()));
                        popup.add(mi);
                        popup.show(TableRenderingEngineImpl.this.rowHeader, evt.getX(), evt.getY());
                    }
                }
            });
        }
        return this.rowHeader;
    }

    private CornerPanel getCornerPanel() {
        if (this.cornerPanel == null) {
            this.cornerPanel = new CornerPanel();
            this.cornerPanel.setToolTipText("Select All");
            this.cornerPanel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.cornerPanel.setCursor(new Cursor(1));
            this.cornerPanel.update();
            this.cornerPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (TableRenderingEngineImpl.this.cornerPanel.isEnabled()) {
                        TableRenderingEngineImpl.this.getBrowserTable().selectAll();
                        TableRenderingEngineImpl.this.updateHeader();
                        this.maybeShowPopup(evt);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    this.maybeShowPopup(evt);
                }

                private void maybeShowPopup(MouseEvent evt) {
                    if (TableRenderingEngineImpl.this.cornerPanel.isEnabled() && evt.isPopupTrigger()) {
                        if (LookAndFeelUtil.isWindows()) {
                            TableRenderingEngineImpl.this.getBrowserTable().selectAll();
                            TableRenderingEngineImpl.this.updateHeader();
                        }
                        JPopupMenu popup = new JPopupMenu();
                        JMenuItem mi = new JMenuItem("Copy", TableRenderingEngineImpl.this.copyIcon);
                        mi.addActionListener(mie -> TableRenderingEngineImpl.this.copyFromTable(mie.getID()));
                        popup.add(mi);
                        popup.show(TableRenderingEngineImpl.this.cornerPanel, evt.getX(), evt.getY());
                    }
                }
            });
        }
        return this.cornerPanel;
    }

    private void registerServices() {
        this.registrar.registerAllServices((Object)this.getBrowserTable(), new Properties());
        this.registrar.registerAllServices((Object)this.getBrowserTable().getModel(), new Properties());
        this.registrar.registerService((Object)this.vpChangeListener, TableViewChangedListener.class, new Properties());
    }

    private void unregisterServices() {
        this.registrar.unregisterAllServices((Object)this.getBrowserTable());
        this.registrar.unregisterAllServices((Object)this.getBrowserTable().getModel());
        this.registrar.unregisterService((Object)this.vpChangeListener, TableViewChangedListener.class);
    }

    private void copyFromTable(int eventId) {
        Action action = this.getBrowserTable().getActionMap().get("copy");
        if (action != null) {
            action.actionPerformed(new ActionEvent(this.getBrowserTable(), eventId, "copy"));
        }
    }

    private void updateHeader() {
        this.getRowHeader().update();
        this.getBrowserTable().getTableHeader().repaint();
        this.getCornerPanel().update();
    }

    private boolean isAllTableColumnsSelected() {
        return this.getBrowserTable().getColumnModel().getSelectedColumnCount() == this.getBrowserTable().getColumnModel().getColumnCount();
    }

    private boolean isAllTableCellsSelected() {
        return this.getBrowserTable().getSelectedRowCount() == this.getBrowserTable().getRowCount() && this.isAllTableColumnsSelected();
    }

    private class CornerPanel
    extends JPanel {
        private CornerPanel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!this.isEnabled()) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color fg = null;
            if (TableRenderingEngineImpl.this.isAllTableCellsSelected()) {
                fg = UIManager.getColor("Table.focusCellBackground");
            } else {
                fg = UIManager.getColor("Label.foreground");
                fg = new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), 60);
            }
            g2.setColor(fg);
            int w = this.getWidth();
            int h = this.getHeight();
            int pad = 3;
            g2.fillPolygon(new int[]{w - pad, w - pad, pad}, new int[]{pad, h - pad, h - pad}, 3);
            g2.dispose();
        }

        void update() {
            this.setEnabled(TableRenderingEngineImpl.this.getBrowserTable().getRowCount() > 0 && TableRenderingEngineImpl.this.getBrowserTable().getColumnCount() > 0);
            boolean allSelected = TableRenderingEngineImpl.this.isAllTableCellsSelected();
            this.setBackground(UIManager.getColor(allSelected ? "Table.background" : "TableHeader.background"));
            this.repaint();
        }
    }
}

