/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.aMatReader.internal.tasks;

import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.cytoscape.aMatReader.internal.ResourceManager;
import org.cytoscape.aMatReader.internal.tasks.AMatReaderWrapperTask;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

public class FileChooserTask
extends AbstractTask {
    private final ResourceManager resourceManager;
    private JFileChooser chooser;

    public FileChooserTask(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                File[] files = FileChooserTask.this.getMatrixFiles();
                if (files.length > 0) {
                    try {
                        String networkName = FileChooserTask.this.predictNetworkName(files);
                        AMatReaderWrapperTask task = new AMatReaderWrapperTask(files, networkName, FileChooserTask.this.resourceManager);
                        FileChooserTask.this.resourceManager.taskManager.execute(new TaskIterator(new Task[]{task}));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private String predictNetworkName(File[] files) throws Exception {
        if (files.length == 0) {
            throw new Exception("No files provided");
        }
        String name = files.length > 1 ? files[0].getParentFile().getName() : files[0].getName();
        return name;
    }

    private JFileChooser getChooser() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
            this.chooser.setMultiSelectionEnabled(true);
            this.chooser.setFileSelectionMode(0);
            this.chooser.setAcceptAllFileFilterUsed(true);
            this.chooser.setFileFilter(new FileFilter(){
                String[] suffixes = new String[]{".mat", ".adj", ".txt", ".tsv", ".csv"};

                @Override
                public String getDescription() {
                    return String.format("Adjacency Matrices (%s)", String.join((CharSequence)", ", this.suffixes));
                }

                @Override
                public boolean accept(File f) {
                    String name = f.getName();
                    for (String suf : this.suffixes) {
                        if (!name.endsWith(suf)) continue;
                        return true;
                    }
                    return f.isDirectory();
                }
            });
            this.chooser.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.chooser.setApproveButtonText("Import files");
        }
        return this.chooser;
    }

    private File[] getMatrixFiles() {
        int response = this.getChooser().showOpenDialog(this.resourceManager.PARENT_FRAME);
        if (response == 0) {
            return this.chooser.getSelectedFiles();
        }
        return new File[0];
    }
}

