/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing.internal;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.FileChooserFilter;
import org.cytoscape.util.swing.FileUtil;

class FileUtilImpl
implements FileUtil {
    private final CyServiceRegistrar serviceRegistrar;

    FileUtilImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public File getFile(Component parent, String title, int loadSaveCustom, Collection<FileChooserFilter> filters) {
        return this.getFile(parent, title, loadSaveCustom, null, null, filters);
    }

    public File getFile(Component parent, String title, int loadSaveCustom, String startDir, String customApproveText, Collection<FileChooserFilter> filters) {
        File[] result = this.getFiles(parent, title, loadSaveCustom, startDir, customApproveText, false, filters);
        return result == null || result.length <= 0 ? null : result[0];
    }

    public File getFile(Component parent, String title, int loadSaveCustom, String startDir, String fileName, String customApproveText, Collection<FileChooserFilter> filters) {
        File[] result = this.getFiles(parent, title, loadSaveCustom, startDir, fileName, customApproveText, false, filters);
        return result == null || result.length <= 0 ? null : result[0];
    }

    public File[] getFiles(Component parent, String title, int loadSaveCustom, Collection<FileChooserFilter> filters) {
        return this.getFiles(parent, title, loadSaveCustom, null, null, true, filters);
    }

    public File[] getFiles(Component parent, String title, int loadSaveCustom, String startDir, String customApproveText, Collection<FileChooserFilter> filters) {
        return this.getFiles(parent, title, loadSaveCustom, startDir, customApproveText, true, filters);
    }

    public File[] getFiles(Component parent, String title, int loadSaveCustom, String startDir, String customApproveText, boolean multiselect, Collection<FileChooserFilter> filters) {
        return this.getFiles(parent, title, loadSaveCustom, startDir, null, customApproveText, multiselect, filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getFiles(Component parent, String title, int loadSaveCustom, String startDir, String fileName, String customApproveText, boolean multiselect, Collection<FileChooserFilter> filters) {
        if (parent == null) {
            throw new NullPointerException("\"parent\" must not be null.");
        }
        String osName = System.getProperty("os.name");
        CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        if (osName.startsWith("Mac")) {
            String fileDialogForDirectories = System.getProperty("apple.awt.fileDialogForDirectories");
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            try {
                FileDialog chooser;
                if (parent instanceof Frame) {
                    chooser = new FileDialog((Frame)parent, title, loadSaveCustom);
                } else if (parent instanceof Dialog) {
                    chooser = new FileDialog((Dialog)parent, title, loadSaveCustom);
                } else if (parent instanceof JMenuItem) {
                    JComponent jcomponent = (JComponent)((JPopupMenu)parent.getParent()).getInvoker();
                    chooser = new FileDialog((Frame)jcomponent.getTopLevelAncestor(), title, loadSaveCustom);
                } else {
                    throw new IllegalArgumentException("Cannot (not implemented yet) create a dialog own by a parent component of type: " + parent.getClass().getCanonicalName());
                }
                if (startDir != null) {
                    chooser.setDirectory(startDir);
                } else {
                    chooser.setDirectory(applicationManager.getCurrentDirectory().getAbsolutePath());
                }
                if (fileName != null) {
                    chooser.setFile(fileName);
                }
                chooser.setModal(true);
                chooser.setFilenameFilter(new CombinedFilenameFilter(filters));
                chooser.setLocationRelativeTo(parent);
                chooser.setMultipleMode(multiselect);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    File[] results;
                    Object newFileName;
                    if (loadSaveCustom == 1) {
                        newFileName = chooser.getFile();
                        String fileNameWithExt = this.addFileExt(filters, (String)newFileName);
                        if (!fileNameWithExt.equals(newFileName)) {
                            int answer;
                            File file = new File(chooser.getDirectory() + File.separator + fileNameWithExt);
                            if (file.exists() && (answer = JOptionPane.showConfirmDialog(parent, "The file '" + file.getName() + "' already exists. Are you sure you want to overwrite it?", "File exists", 0, 2)) == 1) {
                                File[] fileArray = this.getFiles(parent, title, loadSaveCustom, file.getParent(), customApproveText, multiselect, filters);
                                return fileArray;
                            }
                            newFileName = fileNameWithExt;
                        }
                        results = new File[]{new File(chooser.getDirectory() + File.separator + (String)newFileName)};
                    } else {
                        results = chooser.getFiles();
                    }
                    if (chooser.getDirectory() != null) {
                        applicationManager.setCurrentDirectory(new File(chooser.getDirectory()));
                    }
                    newFileName = results;
                    return newFileName;
                }
            }
            finally {
                if (fileDialogForDirectories != null) {
                    System.setProperty("apple.awt.fileDialogForDirectories", fileDialogForDirectories);
                }
            }
            return null;
        }
        JFileChooser chooser = startDir != null ? new JFileChooser(new File(startDir)) : new JFileChooser(applicationManager.getCurrentDirectory());
        if (fileName != null) {
            chooser.setSelectedFile(new File(fileName));
        }
        chooser.setMultiSelectionEnabled(multiselect);
        chooser.setDialogTitle(title);
        chooser.setAcceptAllFileFilterUsed(loadSaveCustom == 0);
        int i = 0;
        FileChooserFilter defaultFilter = null;
        for (FileChooserFilter filter : filters) {
            if (++i == filters.size() && defaultFilter == null) {
                defaultFilter = filter;
            } else if (defaultFilter == null && filter.getDescription().startsWith("All ")) {
                defaultFilter = filter;
            }
            chooser.addChoosableFileFilter((FileFilter)filter);
        }
        File[] results = null;
        File tmp = null;
        if (loadSaveCustom == 0) {
            if (chooser.showOpenDialog(parent) == 0) {
                if (multiselect) {
                    results = chooser.getSelectedFiles();
                } else {
                    tmp = chooser.getSelectedFile();
                    if (tmp != null) {
                        results = new File[]{tmp};
                    }
                }
                if (filters != null && !filters.isEmpty()) {
                    boolean extensionFound = false;
                    for (int k = 0; k < results.length; ++k) {
                        String path = results[k].getPath();
                        for (FileChooserFilter filter : filters) {
                            String[] filterExtensions = filter.getExtensions();
                            for (int t = 0; t < filterExtensions.length; ++t) {
                                if (!filterExtensions[t].equals("") && !path.endsWith("." + filterExtensions[t])) continue;
                                extensionFound = true;
                            }
                        }
                        if (!extensionFound) {
                            int index = path.lastIndexOf(".");
                            Object message = index == -1 ? "Chosen file does not have an extension." : "Chosen file has wrong extension '" + path.substring(index) + "' .";
                            JOptionPane.showMessageDialog(chooser, (String)message + " Please choose another file.", "File extension incorrect", 2);
                            return null;
                        }
                        extensionFound = false;
                    }
                }
            }
        } else if (loadSaveCustom == 1) {
            if (chooser.showSaveDialog(parent) == 0) {
                if (multiselect) {
                    results = chooser.getSelectedFiles();
                } else {
                    tmp = chooser.getSelectedFile();
                    if (tmp != null) {
                        results = new File[]{tmp};
                    }
                }
                for (int k = 0; k < results.length; ++k) {
                    int answer;
                    File file = results[k];
                    String filePath = file.getAbsolutePath();
                    String filePathWithExt = this.addFileExt(filters, filePath);
                    if (!filePathWithExt.equals(filePath)) {
                        results[k] = file = new File(filePathWithExt);
                    }
                    if (!file.exists() || (answer = JOptionPane.showConfirmDialog(chooser, "The file '" + file.getName() + "' already exists. Are you sure you want to overwrite it?", "File exists", 0, 2)) != 1) continue;
                    return this.getFiles(parent, title, loadSaveCustom, file.getParent(), customApproveText, multiselect, filters);
                }
            }
        } else if (chooser.showDialog(parent, customApproveText) == 0) {
            if (multiselect) {
                results = chooser.getSelectedFiles();
            } else {
                tmp = chooser.getSelectedFile();
                if (tmp != null) {
                    results = new File[]{tmp};
                }
            }
        }
        if (results != null && chooser.getCurrentDirectory().getPath() != null) {
            applicationManager.setCurrentDirectory(chooser.getCurrentDirectory());
        }
        return results;
    }

    private String addFileExt(Collection<FileChooserFilter> filters, String fileName) {
        String ext;
        String upperName;
        LinkedHashSet<String> extSet = new LinkedHashSet<String>();
        for (FileChooserFilter filter : filters) {
            String[] exts;
            for (String ext2 : exts = filter.getExtensions()) {
                extSet.add(ext2);
            }
        }
        if (extSet.size() == 1 && !(upperName = ((String)fileName).toUpperCase()).endsWith("." + (ext = (String)extSet.iterator().next()).toUpperCase())) {
            fileName = (String)fileName + "." + ext;
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFolder(Component parent, String title, String startDir) {
        if (parent == null) {
            throw new NullPointerException("\"parent\" must not be null.");
        }
        CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Mac")) {
            String property = System.getProperty("apple.awt.fileDialogForDirectories");
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            try {
                FileDialog chooser;
                if (parent instanceof Dialog) {
                    chooser = new FileDialog((Dialog)parent, title, 0);
                } else if (parent instanceof Frame) {
                    chooser = new FileDialog((Frame)parent, title, 0);
                } else {
                    throw new IllegalArgumentException("parent must be Dialog or Frame");
                }
                if (startDir != null) {
                    chooser.setDirectory(startDir);
                } else {
                    chooser.setDirectory(applicationManager.getCurrentDirectory().getAbsolutePath());
                }
                chooser.setModal(true);
                chooser.setLocationRelativeTo(parent);
                chooser.setVisible(true);
                String file = chooser.getFile();
                String dir = chooser.getDirectory();
                if (file == null || dir == null) {
                    File file2 = null;
                    return file2;
                }
                File file3 = new File(dir + File.separator + file);
                return file3;
            }
            finally {
                if (property != null) {
                    System.setProperty("apple.awt.fileDialogForDirectories", property);
                }
            }
        }
        JFileChooser chooser = startDir != null ? new JFileChooser(new File(startDir)) : new JFileChooser(applicationManager.getCurrentDirectory());
        chooser.setDialogTitle(title);
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        File result = null;
        if (chooser.showOpenDialog(parent) == 0) {
            result = chooser.getSelectedFile();
        }
        if (result != null && chooser.getCurrentDirectory().getPath() != null) {
            applicationManager.setCurrentDirectory(chooser.getCurrentDirectory());
        }
        return result;
    }

    private static final class CombinedFilenameFilter
    implements FilenameFilter {
        private final Collection<FileChooserFilter> filters;

        CombinedFilenameFilter(Collection<FileChooserFilter> filters) {
            this.filters = filters;
        }

        @Override
        public boolean accept(File dir, String name) {
            if (this.filters.isEmpty()) {
                return true;
            }
            File path = new File(dir, name);
            for (FileChooserFilter filter : this.filters) {
                if (!filter.accept(path)) continue;
                return true;
            }
            return false;
        }
    }
}

