/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing.internal;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteProvider;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.internal.ColorBlindAwareColorChooserPanel;
import org.cytoscape.util.swing.internal.ColorIcon;
import org.cytoscape.util.swing.internal.ColorPanelSelectionModel;

public class ColorPaletteProviderPanel
extends ColorBlindAwareColorChooserPanel
implements ActionListener {
    private Map<String, JPanel> paletteMap;
    private PaletteProvider provider;
    private PaletteType paletteType;
    private List<Palette> palettes;
    private boolean paletteOnly;
    private int paletteSize;

    public ColorPaletteProviderPanel(PaletteProvider provider, PaletteType type, int size, boolean paletteOnly) {
        this.provider = provider;
        this.paletteType = type;
        this.paletteOnly = paletteOnly;
        this.paletteSize = size;
        this.palettes = new ArrayList<Palette>();
        for (Object paletteId : provider.listPaletteIdentifiers(type, false)) {
            this.palettes.add(provider.getPalette(paletteId, size));
        }
    }

    protected JPanel createPalette(Palette palette, Border normalBorder, Border selectedBorder) {
        JPanel panel = new JPanel();
        BoxLayout layout = new BoxLayout(panel, 1);
        panel.setLayout(layout);
        Color[] colors = palette.getColors(this.paletteSize);
        for (int colorIndex = 0; colorIndex < this.paletteSize; ++colorIndex) {
            Color clr = colors[colorIndex];
            JButton colorButton = new JButton();
            colorButton.setActionCommand(palette.getName() + ":" + String.valueOf(clr.getRGB()));
            colorButton.addActionListener(this);
            colorButton.setIcon(new ColorIcon(clr, 15, 15, this.paletteOnly));
            colorButton.setBorder(BorderFactory.createEmptyBorder());
            colorButton.setToolTipText(palette.getName());
            panel.add(colorButton);
        }
        if (palette.getName().equals(this.selectedPalette)) {
            panel.setBorder(selectedBorder);
        } else {
            panel.setBorder(normalBorder);
        }
        if (this.paletteMap == null) {
            this.paletteMap = new HashMap<String, JPanel>();
        }
        this.paletteMap.put(palette.getName(), panel);
        return panel;
    }

    @Override
    protected void buildChooser() {
        ColorPanelSelectionModel model;
        Palette p;
        this.setLayout(new FlowLayout(2, 0, 0));
        Border border = BorderFactory.createEmptyBorder(2, 6, 2, 6);
        Border selectedBorder = BorderFactory.createLineBorder(UIManager.getColor("List.selectionBackground"), 2);
        if (this.selectedPalette == null && (p = (model = (ColorPanelSelectionModel)this.getColorSelectionModel()).getPalette()) != null) {
            this.selectedPalette = p.getName();
        }
        for (Palette palette : this.palettes) {
            if (this.isShowColorBlindSafe() && !palette.isColorBlindSafe()) continue;
            palette.reverse(this.reverseColors);
            JPanel button = this.createPalette(palette, border, selectedBorder);
            this.add(button);
            this.currentButtons.add(button);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ColorSelectionModel model = this.getColorSelectionModel();
        String command = ((JButton)e.getSource()).getActionCommand();
        String[] colorSplit = command.split(":");
        this.selectedPalette = colorSplit[0];
        Color color = new Color(Integer.parseInt(colorSplit[1]));
        if (!this.paletteOnly) {
            model.setSelectedColor(color);
        }
        for (Palette palette : this.palettes) {
            JPanel selectedPanel = this.paletteMap.get(palette.getName());
            if (palette.getName().equals(this.selectedPalette)) {
                ((ColorPanelSelectionModel)model).setPalette(palette);
                selectedPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4), BorderFactory.createLineBorder(UIManager.getColor("List.selectionBackground"), 2)));
                continue;
            }
            selectedPanel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
        }
    }

    @Override
    public String getDisplayName() {
        return this.provider.getProviderName() + " " + this.getTypeName();
    }

    @Override
    public void setSelectedPalette(String palette) {
        this.selectedPalette = palette;
        ColorSelectionModel model = this.getColorSelectionModel();
        for (Palette plt : this.palettes) {
            JPanel selectedPanel = this.paletteMap.get(plt.getName());
            if (plt.getName().equals(this.selectedPalette)) {
                ((ColorPanelSelectionModel)model).setPalette(plt);
                selectedPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4), BorderFactory.createLineBorder(UIManager.getColor("List.selectionBackground"), 2)));
                continue;
            }
            selectedPanel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
        }
    }

    public void stateChanged(ChangeEvent ce) {
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    private String getTypeName() {
        if (this.paletteType.equals(BrewerType.DIVERGING)) {
            return "Diverging";
        }
        if (this.paletteType.equals(BrewerType.SEQUENTIAL)) {
            return "Sequential";
        }
        if (this.paletteType.equals(BrewerType.QUALITATIVE)) {
            return "Qualitative";
        }
        return "";
    }
}

