/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.opencl.layout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.cytoscape.view.layout.EdgeWeighter;
import org.cytoscape.view.layout.LayoutEdge;
import org.cytoscape.view.layout.LayoutNode;
import org.cytoscape.view.layout.LayoutPartition;

public class SlimNetwork {
    public float left;
    public float top;
    public float width;
    public float height;
    public float massCenterX;
    public float massCenterY;
    public float[] nodePosX;
    public float[] nodePosY;
    public int numNodes;
    public int numNodesPadded;
    public int numEdgesSparse;
    public int numEdgesUnique;
    public int numEdgesUniquePadded;
    float[] nodeMass;
    int[] edgeOffsetsSparse;
    int[] edgeCounts;
    public int[] edges;
    public float[] edgeCoeffs;
    public float[] edgeLengths;
    public int[] edgeUniqueSources;
    public int[] edgeUniqueTargets;
    public float[] edgeMassStart;
    public float[] edgeMassEnd;
    public HashMap<LayoutNode, Integer> nodeToIndex;

    public SlimNetwork(LayoutPartition part, Boolean deterministic, float defaultNodeMass, float springCoefficient, float springLength, EdgeWeighter edgeWeighter, int padding) {
        int i;
        List nodeList = part.getNodeList();
        List edgeList = part.getEdgeList();
        if (deterministic.booleanValue()) {
            Collections.sort(nodeList);
            Collections.sort(edgeList);
        }
        this.numNodesPadded = this.nextMultipleOf(nodeList.size(), padding);
        this.nodeMass = new float[this.numNodesPadded];
        this.edgeOffsetsSparse = new int[nodeList.size()];
        this.edgeCounts = new int[nodeList.size()];
        this.numEdgesSparse = 0;
        this.numEdgesUnique = 0;
        this.nodeToIndex = new HashMap();
        HashMap nodeEdges = new HashMap();
        final HashMap<LayoutNode, LayoutNode[]> nodeNeighbors = new HashMap<LayoutNode, LayoutNode[]>();
        for (LayoutNode ln : nodeList) {
            nodeEdges.put(ln, new ArrayList());
            List neighbors = ln.getNeighbors();
            HashSet<LayoutNode> uniqueNeighbors = new HashSet<LayoutNode>();
            for (LayoutNode neighbor : neighbors) {
                if (neighbor == ln) continue;
                uniqueNeighbors.add(neighbor);
            }
            LayoutNode[] uniqueArray = new LayoutNode[uniqueNeighbors.size()];
            nodeNeighbors.put(ln, uniqueNeighbors.toArray(uniqueArray));
            this.numEdgesSparse += this.nextMultipleOf(uniqueNeighbors.size(), padding);
            this.numEdgesUnique += uniqueNeighbors.size();
        }
        this.numEdgesUnique /= 2;
        this.numEdgesUniquePadded = this.nextMultipleOf(this.numEdgesUnique, padding);
        for (Object le : edgeList) {
            Object tgt;
            LayoutNode src = le.getSource();
            if (src == (tgt = le.getTarget())) continue;
            ((ArrayList)nodeEdges.get(src)).add(le);
            ((ArrayList)nodeEdges.get(tgt)).add(le);
        }
        class LayoutNodeComparator
        implements Comparator<LayoutNode> {
            LayoutNodeComparator() {
            }

            @Override
            public int compare(LayoutNode a, LayoutNode b) {
                return ((LayoutNode[])nodeNeighbors.get(a)).length - ((LayoutNode[])nodeNeighbors.get(b)).length;
            }
        }
        nodeList.sort(new LayoutNodeComparator());
        int n = 0;
        for (LayoutNode ln : nodeList) {
            this.nodeToIndex.put(ln, n++);
        }
        this.edges = new int[this.numEdgesSparse];
        this.edgeCoeffs = new float[this.numEdgesSparse];
        this.edgeLengths = new float[this.numEdgesSparse];
        this.edgeUniqueSources = new int[this.numEdgesUniquePadded];
        this.edgeUniqueTargets = new int[this.numEdgesUniquePadded];
        this.edgeMassStart = new float[this.numEdgesUniquePadded];
        this.edgeMassEnd = new float[this.numEdgesUniquePadded];
        int eSparse = 0;
        int eUnique = 0;
        HashSet<Long> edgesConsidered = new HashSet<Long>();
        for (LayoutNode ln : nodeList) {
            int i2;
            int id = this.nodeToIndex.get(ln);
            this.nodeMass[id] = defaultNodeMass;
            LayoutNode[] uniqueNeighbors = (LayoutNode[])nodeNeighbors.get(ln);
            int[] sortedEdges = new int[uniqueNeighbors.length];
            for (int i3 = 0; i3 < uniqueNeighbors.length; ++i3) {
                sortedEdges[i3] = this.nodeToIndex.get(uniqueNeighbors[i3]);
            }
            Arrays.sort(sortedEdges);
            HashMap<Integer, Integer> order = new HashMap<Integer, Integer>();
            for (int i4 = 0; i4 < sortedEdges.length; ++i4) {
                order.put(sortedEdges[i4], i4);
            }
            float[] coeffs = new float[sortedEdges.length];
            float[] lengths = new float[sortedEdges.length];
            float[] samples = new float[sortedEdges.length];
            ArrayList unsortedEdges = (ArrayList)nodeEdges.get(ln);
            for (LayoutEdge le : unsortedEdges) {
                int position;
                int tgtId = this.nodeToIndex.get(le.getTarget());
                if (tgtId == id) {
                    tgtId = this.nodeToIndex.get(le.getSource());
                }
                int n2 = position = ((Integer)order.get(tgtId)).intValue();
                coeffs[n2] = coeffs[n2] + springCoefficient;
                int n3 = position;
                lengths[n3] = lengths[n3] + SlimNetwork.getSpringLength(springLength, le);
                int n4 = position;
                samples[n4] = samples[n4] + 1.0f;
            }
            for (i2 = 0; i2 < lengths.length; ++i2) {
                int n5 = i2;
                lengths[n5] = lengths[n5] / samples[i2];
            }
            this.edgeOffsetsSparse[id] = eSparse;
            this.edgeCounts[id] = sortedEdges.length;
            for (i2 = 0; i2 < sortedEdges.length; ++i2) {
                this.edges[eSparse + i2] = sortedEdges[i2];
                this.edgeCoeffs[eSparse + i2] = coeffs[i2];
                this.edgeLengths[eSparse + i2] = lengths[i2];
                long edgeHash = SlimNetwork.getEdgeHash(id, sortedEdges[i2]);
                if (edgesConsidered.contains(edgeHash)) continue;
                edgesConsidered.add(edgeHash);
                int sourceId = Math.min(id, sortedEdges[i2]);
                int targetId = Math.max(id, sortedEdges[i2]);
                this.edgeUniqueSources[eUnique] = sourceId;
                this.edgeUniqueTargets[eUnique] = targetId;
                this.edgeMassStart[eUnique] = defaultNodeMass;
                this.edgeMassEnd[eUnique] = defaultNodeMass;
                ++eUnique;
            }
            eSparse += this.nextMultipleOf(sortedEdges.length, padding);
        }
        for (i = nodeList.size(); i < this.numNodesPadded; ++i) {
            this.nodeMass[i] = 0.0f;
        }
        for (i = eUnique; i < this.numEdgesUniquePadded; ++i) {
            this.edgeMassStart[i] = 0.0f;
            this.edgeMassEnd[i] = 0.0f;
        }
        this.numNodes = nodeList.size();
        this.nodePosX = new float[this.numNodesPadded];
        this.nodePosY = new float[this.numNodesPadded];
        for (LayoutNode node : nodeList) {
            int nodeIndex = this.nodeToIndex.get(node);
            this.nodePosX[nodeIndex] = (float)node.getX();
            this.nodePosY[nodeIndex] = (float)node.getY();
        }
        this.updateMetrics();
    }

    public void updateMetrics() {
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        this.massCenterX = 0.0f;
        this.massCenterY = 0.0f;
        for (int i = 0; i < this.numNodes; ++i) {
            float x = this.nodePosX[i];
            float y = this.nodePosY[i];
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
            maxX = Math.max(maxX, x);
            maxY = Math.max(maxY, y);
            this.massCenterX += x;
            this.massCenterY += y;
        }
        this.left = minX;
        this.top = minY;
        this.width = maxX - minX + 100.0f;
        this.height = maxY - minY + 100.0f;
        this.massCenterX /= (float)this.numNodes;
        this.massCenterY /= (float)this.numNodes;
    }

    public void offset(float x, float y) {
        int i = 0;
        while (i < this.numNodes) {
            int n = i;
            this.nodePosX[n] = this.nodePosX[n] + x;
            int n2 = i++;
            this.nodePosY[n2] = this.nodePosY[n2] + y;
        }
        this.left += x;
        this.top += y;
        this.massCenterX += x;
        this.massCenterY += y;
    }

    static float getSpringLength(float defaultLength, LayoutEdge e) {
        float weight = (float)e.getWeight();
        return defaultLength / weight;
    }

    static long getEdgeHash(int node1, int node2) {
        if (node1 <= node2) {
            return ((long)node1 << 32) + (long)node2;
        }
        return ((long)node2 << 32) + (long)node1;
    }

    private int nextMultipleOf(int n, int multipleOf) {
        return (n + multipleOf - 1) / multipleOf * multipleOf;
    }
}

