/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.application.CyVersion;

public class AppHelper {
    private static Pattern COMPAT_VERSION_REGEX = Pattern.compile("^(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?([\\-\\.\\w]+)?$");

    public static boolean isCompatible(CyVersion cyVer, String compatibleCytoscapeVersions) {
        String[] compatVers;
        String compatVersStr = compatibleCytoscapeVersions;
        for (String compatVer : compatVers = compatVersStr.split(",")) {
            Matcher matcher = COMPAT_VERSION_REGEX.matcher(compatVer);
            if (!matcher.matches()) continue;
            String majorStr = matcher.group(1);
            int major = Integer.parseInt(majorStr);
            String minorStr = matcher.group(2);
            int minor = minorStr != null ? Integer.parseInt(minorStr) : 0;
            String patchStr = matcher.group(3);
            int patch = patchStr != null ? Integer.parseInt(patchStr) : 0;
            String tagStr = matcher.group(4);
            if (cyVer.getMajorVersion() != major || cyVer.getMinorVersion() < minor || cyVer.getBugFixVersion() < patch) continue;
            return true;
        }
        return false;
    }
}

