/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.ui;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.cytoscape.app.internal.ui.Article;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class PubMedParser {
    static final String REQUEST_URL_BASE = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/esummary.fcgi?db=pubmed&id=";
    protected DocumentBuilder xmlParser = null;

    PubMedParser() {
    }

    protected static String makeRequestURL(Iterable<String> pmids) {
        StringBuffer buffer = new StringBuffer(REQUEST_URL_BASE);
        Iterator<String> iterator = pmids.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        return buffer.toString();
    }

    protected static DocumentBuilder newXmlParser() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder;
    }

    protected Document xmlRequest(String url) throws ParserConfigurationException, MalformedURLException, IOException, SAXException {
        if (this.xmlParser == null) {
            this.xmlParser = PubMedParser.newXmlParser();
        }
        InputStream inputStream = new URL(url).openConnection().getInputStream();
        Document doc = this.xmlParser.parse(inputStream);
        inputStream.close();
        return doc;
    }

    protected static Article parseArticle(Node docSum) {
        String pmid = null;
        String pubDate = null;
        String source = null;
        String title = null;
        ArrayList<String> authors = new ArrayList<String>();
        String volume = null;
        String issue = null;
        String pages = null;
        NodeList items = docSum.getChildNodes();
        for (int i = 0; i < items.getLength(); ++i) {
            Node nameNode;
            Node item = items.item(i);
            String content = item.getTextContent();
            if ("Id".equals(item.getNodeName())) {
                pmid = content;
                continue;
            }
            if (!"Item".equals(item.getNodeName()) || (nameNode = item.getAttributes().getNamedItem("Name")) == null) continue;
            String name = nameNode.getTextContent();
            if ("PubDate".equals(name)) {
                pubDate = content;
                continue;
            }
            if ("Source".equals(name)) {
                source = content;
                continue;
            }
            if ("AuthorList".equals(name)) {
                NodeList authorList = item.getChildNodes();
                for (int j = 0; j < authorList.getLength(); ++j) {
                    Node author = authorList.item(j);
                    if (!"Item".equals(author.getNodeName())) continue;
                    authors.add(author.getTextContent());
                }
                continue;
            }
            if ("Title".equals(name)) {
                title = content;
                continue;
            }
            if ("Volume".equals(name)) {
                volume = content;
                continue;
            }
            if ("Issue".equals(name)) {
                issue = content;
                continue;
            }
            if (!"Pages".equals(name)) continue;
            pages = content;
        }
        return new Article(pmid, pubDate, source, title, authors, volume, issue, pages);
    }

    protected static <K, V> K keyForValue(Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Map<String, Article> retrieveArticles(Map<String, String> pmids) throws ParserConfigurationException, MalformedURLException, IOException, SAXException {
        HashMap<String, Article> articles = new HashMap<String, Article>();
        Document root = this.xmlRequest(PubMedParser.makeRequestURL(pmids.values()));
        NodeList results = root.getChildNodes();
        for (int i = 0; i < results.getLength(); ++i) {
            Node result = results.item(i);
            NodeList docSums = result.getChildNodes();
            for (int j = 0; j < docSums.getLength(); ++j) {
                Node docSum = docSums.item(j);
                if (!"DocSum".equals(docSum.getNodeName())) continue;
                Article article = PubMedParser.parseArticle(docSum);
                String name = PubMedParser.keyForValue(pmids, article.getPmid());
                articles.put(name, article);
            }
        }
        return articles;
    }
}

