/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.cytoscape.app.internal.event.AppsChangedEvent;
import org.cytoscape.app.internal.event.AppsChangedListener;
import org.cytoscape.app.internal.exception.AppDisableException;
import org.cytoscape.app.internal.exception.AppInstallException;
import org.cytoscape.app.internal.exception.AppUninstallException;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.manager.BundleApp;
import org.cytoscape.app.internal.manager.SimpleApp;
import org.cytoscape.app.internal.net.WebQuerier;
import org.cytoscape.app.internal.util.DebugHelper;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class CurrentlyInstalledAppsPanel
extends JPanel {
    private JScrollPane appsAvailableScrollPane;
    private JTable appsAvailableTable;
    private JLabel appsInstalledLabel;
    private JLabel descriptionLabel;
    private JScrollPane descriptionScrollPane;
    private JTextArea descriptionTextArea;
    private JButton enableSelectedButton;
    private JButton disableSelectedButton;
    private JButton uninstallSelectedButton;
    private JCheckBox showCoreAppsCheckbox;
    private AppManager appManager;
    private AppsChangedListener appListener;

    public CurrentlyInstalledAppsPanel(AppManager appManager) {
        this.appManager = appManager;
        this.initComponents();
        this.setupAppListener();
        this.setupDescriptionListener();
        this.populateTable();
    }

    private void initComponents() {
        this.appsAvailableScrollPane = new JScrollPane();
        this.appsAvailableTable = new JTable();
        this.appsInstalledLabel = new JLabel("0 Apps installed.");
        this.enableSelectedButton = new JButton("Enable");
        this.disableSelectedButton = new JButton("Disable");
        this.uninstallSelectedButton = new JButton("Uninstall");
        this.descriptionLabel = new JLabel("App Information:");
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        this.showCoreAppsCheckbox = new JCheckBox("Show Core Apps");
        this.appsAvailableScrollPane.setViewportView(this.appsAvailableTable);
        this.enableSelectedButton.setEnabled(false);
        this.enableSelectedButton.addActionListener(this::enableSelectedButtonActionPerformed);
        this.disableSelectedButton.setEnabled(false);
        this.disableSelectedButton.addActionListener(this::disableSelectedButtonActionPerformed);
        this.uninstallSelectedButton.setEnabled(false);
        this.uninstallSelectedButton.addActionListener(this::uninstallSelectedButtonActionPerformed);
        this.descriptionScrollPane.setHorizontalScrollBarPolicy(31);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setFocusable(false);
        this.descriptionScrollPane.setViewportView(this.descriptionTextArea);
        this.showCoreAppsCheckbox.setSelected(false);
        this.showCoreAppsCheckbox.addActionListener(this::showCoreAppsActionPerformed);
        LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.enableSelectedButton, this.disableSelectedButton, this.uninstallSelectedButton});
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.showCoreAppsCheckbox});
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.appsInstalledLabel).addComponent(this.appsAvailableScrollPane, -1, 634, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.descriptionLabel).addGap(0, Short.MAX_VALUE, Short.MAX_VALUE).addComponent(this.showCoreAppsCheckbox)).addComponent(this.descriptionScrollPane).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.enableSelectedButton).addComponent(this.disableSelectedButton).addComponent(this.uninstallSelectedButton).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.appsInstalledLabel).addComponent(this.appsAvailableScrollPane, -1, 311, Short.MAX_VALUE).addGroup(layout.createParallelGroup().addComponent(this.descriptionLabel).addComponent(this.showCoreAppsCheckbox)).addComponent(this.descriptionScrollPane, -2, 106, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.enableSelectedButton).addComponent(this.disableSelectedButton).addComponent(this.uninstallSelectedButton)));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                CurrentlyInstalledAppsPanel.this.appManager.getWebQuerier().findAppDescriptions(CurrentlyInstalledAppsPanel.this.appManager.getApps());
            }
        });
        this.updateLabels();
    }

    private void enableSelectedButtonActionPerformed(ActionEvent evt) {
        Set<App> selectedApps = this.getSelectedApps();
        for (App app : selectedApps) {
            if (app.getStatus() == App.AppStatus.INSTALLED) continue;
            try {
                this.appManager.installApp(app);
            }
            catch (AppInstallException e) {
                e.printStackTrace();
            }
        }
        this.enableSelectedButton.setEnabled(false);
        this.disableSelectedButton.setEnabled(true);
        this.uninstallSelectedButton.setEnabled(true);
    }

    private void disableSelectedButtonActionPerformed(ActionEvent evt) {
        Set<App> selectedApps = this.getSelectedApps();
        Map<App, Collection<App>> otherAppsDependingOn = this.getOtherAppsDependingOn(selectedApps);
        if (otherAppsDependingOn != null && !this.continueWithConflicts(otherAppsDependingOn)) {
            return;
        }
        for (App app : selectedApps) {
            if (app.getStatus().equals((Object)App.AppStatus.DISABLED)) continue;
            try {
                this.appManager.disableApp(app);
            }
            catch (AppDisableException e) {
                e.printStackTrace();
            }
        }
        this.disableSelectedButton.setEnabled(false);
        this.enableSelectedButton.setEnabled(true);
        this.uninstallSelectedButton.setEnabled(true);
    }

    private void uninstallSelectedButtonActionPerformed(ActionEvent evt) {
        Set<App> selectedApps = this.getSelectedApps();
        Map<App, Collection<App>> otherAppsDependingOn = this.getOtherAppsDependingOn(selectedApps);
        if (otherAppsDependingOn != null && !this.continueWithConflicts(otherAppsDependingOn)) {
            return;
        }
        for (App app : selectedApps) {
            if (app.getStatus() != App.AppStatus.INSTALLED && app.getStatus() != App.AppStatus.DISABLED && app.getStatus() != App.AppStatus.FAILED_TO_LOAD && app.getStatus() != App.AppStatus.FAILED_TO_START) continue;
            try {
                this.appManager.uninstallApp(app);
            }
            catch (AppUninstallException e) {
                e.printStackTrace();
            }
        }
        this.uninstallSelectedButton.setEnabled(false);
        this.disableSelectedButton.setEnabled(true);
        this.enableSelectedButton.setEnabled(true);
        this.appsAvailableTable.clearSelection();
    }

    private void showCoreAppsActionPerformed(ActionEvent evt) {
        this.populateTable();
    }

    private Set<App> getSelectedApps() {
        HashSet<App> selectedApps = new HashSet<App>();
        int[] selectedRows = this.appsAvailableTable.getSelectedRows();
        for (int index = 0; index < selectedRows.length; ++index) {
            App app = (App)this.appsAvailableTable.getModel().getValueAt(this.appsAvailableTable.convertRowIndexToModel(selectedRows[index]), 0);
            selectedApps.add(app);
        }
        return selectedApps;
    }

    private void setupAppListener() {
        this.appListener = new AppsChangedListener(){

            @Override
            public void appsChanged(AppsChangedEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int rowIndex;
                        Set<App> selectedApps = CurrentlyInstalledAppsPanel.this.getSelectedApps();
                        DefaultTableModel tableModel = (DefaultTableModel)CurrentlyInstalledAppsPanel.this.appsAvailableTable.getModel();
                        for (rowIndex = tableModel.getRowCount() - 1; rowIndex >= 0; --rowIndex) {
                            tableModel.removeRow(rowIndex);
                        }
                        CurrentlyInstalledAppsPanel.this.populateTable();
                        CurrentlyInstalledAppsPanel.this.updateLabels();
                        for (rowIndex = 0; rowIndex < tableModel.getRowCount(); ++rowIndex) {
                            if (!selectedApps.contains(tableModel.getValueAt(rowIndex, 0))) continue;
                            CurrentlyInstalledAppsPanel.this.appsAvailableTable.addRowSelectionInterval(rowIndex, rowIndex);
                        }
                    }
                });
            }
        };
        this.appManager.addAppListener(this.appListener);
    }

    private void populateTable() {
        boolean showCoreApps = this.showCoreAppsCheckbox.isSelected();
        DefaultTableModel tableModel = new DefaultTableModel(new Object[0][], new String[]{"App", "Name", "Version", "Status"}){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        Set<App> apps = this.appManager.getApps();
        for (App app : apps) {
            if (app.isHidden()) continue;
            tableModel.addRow(new Object[]{app, app, app, app});
        }
        if (showCoreApps) {
            for (App app : apps) {
                if (!app.isBundledApp()) continue;
                tableModel.addRow(new Object[]{app, app, app, app});
            }
        }
        this.appsAvailableTable.setModel(tableModel);
        this.appsAvailableTable.getColumnModel().getColumn(1).setPreferredWidth(195);
        this.appsAvailableTable.removeColumn(this.appsAvailableTable.getColumn("App"));
        this.appsAvailableTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (component instanceof JLabel) {
                    JLabel label = (JLabel)component;
                    App app = (App)value;
                    String status = app.getReadableStatus();
                    if (status.equals(App.AppStatus.FAILED_TO_LOAD.toString()) || status.equals(App.AppStatus.FAILED_TO_START.toString())) {
                        this.setForeground(LookAndFeelUtil.getErrorColor());
                    } else {
                        this.setForeground(null);
                    }
                    if (column == 0) {
                        StringBuilder name = new StringBuilder(app.getAppName());
                        if (app.getAppFile() == null) {
                            name.append(" (file moved)");
                        }
                        label.setText(name.toString());
                    } else if (column == 1) {
                        StringBuilder ver = new StringBuilder(app.getVersion());
                        if (app.isBundledApp()) {
                            ver.append(" (core app)");
                        }
                        label.setText(ver.toString());
                    } else if (column == 2) {
                        label.setText(status);
                        File file = app.getAppFile();
                        if (file != null) {
                            label.setToolTipText(file.getAbsolutePath());
                        }
                    }
                }
                return component;
            }
        });
        this.updateLabels();
    }

    private void updateLabels() {
        boolean showCoreApps = this.showCoreAppsCheckbox.isSelected();
        int listedCount = 0;
        Set<App> apps = this.appManager.getApps();
        for (App app : apps) {
            if (!app.isHidden()) {
                ++listedCount;
                continue;
            }
            DebugHelper.print(this, "Hidden app: " + app.getAppName() + ", status: " + app.getStatus());
        }
        if (showCoreApps) {
            for (App app : apps) {
                if (!app.isBundledApp()) continue;
                ++listedCount;
            }
        }
        this.appsInstalledLabel.setText(listedCount + " App(s) listed.");
    }

    private void setupDescriptionListener() {
        this.appsAvailableTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CurrentlyInstalledAppsPanel.this.updateDescriptionBox();
            }
        });
    }

    private void updateDescriptionBox() {
        Set<App> selectedApps = this.getSelectedApps();
        int numSelected = selectedApps.size();
        if (numSelected == 0) {
            this.descriptionTextArea.setText("");
            this.enableSelectedButton.setEnabled(false);
            this.disableSelectedButton.setEnabled(false);
            this.uninstallSelectedButton.setEnabled(false);
        } else if (numSelected == 1) {
            App selectedApp = selectedApps.iterator().next();
            Object type = "Type of app: ";
            type = selectedApp instanceof BundleApp ? (String)type + "OSGi Bundle-based app" : (selectedApp instanceof SimpleApp ? (String)type + "Standard Java Jar-based app" : (String)type + "Unknown");
            if (selectedApp.isBundledApp()) {
                type = (String)type + "  (Core App)";
            }
            String text = selectedApp.getDescription() == null ? "App description not found." : selectedApp.getDescription();
            this.descriptionTextArea.setText((String)type + "\n\n" + text);
            if (selectedApp.isBundledApp()) {
                this.enableSelectedButton.setEnabled(false);
                this.disableSelectedButton.setEnabled(false);
                this.uninstallSelectedButton.setEnabled(false);
            } else if (selectedApp.getStatus() == App.AppStatus.INSTALLED || selectedApp.getStatus() == App.AppStatus.FAILED_TO_LOAD || selectedApp.getStatus() == App.AppStatus.FAILED_TO_START) {
                this.enableSelectedButton.setEnabled(false);
                this.disableSelectedButton.setEnabled(true);
                this.uninstallSelectedButton.setEnabled(true);
            } else if (selectedApp.getStatus() == App.AppStatus.DISABLED) {
                this.enableSelectedButton.setEnabled(true);
                this.disableSelectedButton.setEnabled(false);
                this.uninstallSelectedButton.setEnabled(true);
            } else if (selectedApp.getStatus() == App.AppStatus.UNINSTALLED) {
                this.enableSelectedButton.setEnabled(true);
                this.disableSelectedButton.setEnabled(true);
                this.uninstallSelectedButton.setEnabled(false);
            } else {
                this.enableSelectedButton.setEnabled(true);
                this.disableSelectedButton.setEnabled(true);
                this.uninstallSelectedButton.setEnabled(true);
            }
        } else {
            this.descriptionTextArea.setText(numSelected + " apps selected.");
            boolean allInstalled = true;
            boolean allDisabled = true;
            boolean allUninstalled = true;
            boolean anyCore = false;
            for (App selectedApp : selectedApps) {
                if (selectedApp.isBundledApp()) {
                    anyCore = true;
                }
                if (selectedApp.getStatus() == App.AppStatus.INSTALLED) {
                    allDisabled = false;
                    allUninstalled = false;
                }
                if (selectedApp.getStatus() == App.AppStatus.DISABLED) {
                    allInstalled = false;
                    allUninstalled = false;
                }
                if (selectedApp.getStatus() != App.AppStatus.UNINSTALLED) continue;
                allInstalled = false;
                allDisabled = false;
            }
            if (anyCore) {
                this.enableSelectedButton.setEnabled(false);
                this.disableSelectedButton.setEnabled(false);
                this.uninstallSelectedButton.setEnabled(false);
            } else if (allInstalled) {
                this.enableSelectedButton.setEnabled(false);
                this.disableSelectedButton.setEnabled(true);
                this.uninstallSelectedButton.setEnabled(true);
            } else if (allDisabled) {
                this.enableSelectedButton.setEnabled(true);
                this.disableSelectedButton.setEnabled(false);
                this.uninstallSelectedButton.setEnabled(true);
            } else if (allUninstalled) {
                this.enableSelectedButton.setEnabled(true);
                this.disableSelectedButton.setEnabled(true);
                this.uninstallSelectedButton.setEnabled(false);
            } else {
                this.enableSelectedButton.setEnabled(true);
                this.disableSelectedButton.setEnabled(true);
                this.uninstallSelectedButton.setEnabled(true);
            }
        }
        this.descriptionTextArea.setCaretPosition(0);
    }

    public boolean continueWithConflicts(Map<App, Collection<App>> otherAppsDependingOn) {
        int confirm;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        JLabel title = new JLabel("The following are required by one or more installed apps:");
        title.setAlignmentX(0.0f);
        panel.add(title);
        panel.add(Box.createVerticalStrut(title.getPreferredSize().height));
        Object deps = "";
        for (App app : otherAppsDependingOn.keySet()) {
            deps = (String)deps + app.getAppName() + " (required by";
            for (App otherAppDependingOn : otherAppsDependingOn.get(app)) {
                deps = (String)deps + " " + otherAppDependingOn.getAppName() + ",";
            }
            deps = ((String)deps).substring(0, ((String)deps).length() - 1) + ")\n";
        }
        deps = ((String)deps).substring(0, ((String)deps).length() - 1);
        JTextArea textArea = new JTextArea((String)deps);
        textArea.setRows(Math.min(otherAppsDependingOn.size(), 10));
        textArea.setEditable(false);
        textArea.setHighlighter(null);
        textArea.setBorder(null);
        textArea.setOpaque(false);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setAlignmentX(0.0f);
        scrollPane.setBorder(null);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setOpaque(false);
        panel.add(scrollPane);
        panel.add(Box.createVerticalStrut(title.getPreferredSize().height));
        JLabel message = new JLabel("Continue?");
        message.setAlignmentX(0.0f);
        panel.add(message);
        Dimension size = panel.getPreferredSize();
        if (size.width > 600) {
            size.width = 600;
            panel.setPreferredSize(size);
        }
        return (confirm = JOptionPane.showConfirmDialog(this, panel, "Warning", 2, 2)) == 0;
    }

    public Map<App, Collection<App>> getOtherAppsDependingOn(Collection<App> apps) {
        HashMap<App, Collection<App>> otherAppsDependingOn = new HashMap<App, Collection<App>>();
        for (App app : apps) {
            ArrayList<App> dependencies = new ArrayList<App>();
            for (App installedApp : this.appManager.getInstalledApps()) {
                if (installedApp.getAppName().equalsIgnoreCase("core apps") || apps.contains(installedApp) || installedApp.getDependencies() == null) continue;
                for (App.Dependency dep : installedApp.getDependencies()) {
                    if (!app.getAppName().equalsIgnoreCase(dep.getName()) || WebQuerier.compareVersions(dep.getVersion(), app.getVersion()) < 0) continue;
                    dependencies.add(installedApp);
                }
            }
            if (dependencies.isEmpty()) continue;
            otherAppsDependingOn.put(app, dependencies);
        }
        if (!otherAppsDependingOn.isEmpty()) {
            return otherAppsDependingOn;
        }
        return null;
    }
}

