/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.WebQuerier;
import org.cytoscape.app.internal.ui.RetrieveTask;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.OpenBrowser;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.swing.DialogTaskManager;

public class CitationsDialog
extends JDialog {
    private final JTextPane textPane;
    private final WebQuerier webQuerier;
    private final AppManager appManager;
    private final CyServiceRegistrar serviceRegistrar;

    public CitationsDialog(Window owner, WebQuerier webQuerier, AppManager appManager, CyServiceRegistrar serviceRegistrar) {
        super(owner, "Citations", Dialog.ModalityType.MODELESS);
        this.webQuerier = webQuerier;
        this.appManager = appManager;
        this.serviceRegistrar = serviceRegistrar;
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(new Dimension(500, 400));
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.textPane.setContentType("text/html");
        this.textPane.addHyperlinkListener(evt -> {
            if (!evt.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                return;
            }
            ((OpenBrowser)serviceRegistrar.getService(OpenBrowser.class)).openURL(evt.getURL().toString());
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new JScrollPane(this.textPane), c);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            DialogTaskManager taskMgr = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
            taskMgr.execute(new TaskIterator(new Task[]{new RetrieveTask(this.webQuerier, this.textPane, this.appManager)}));
            this.pack();
        }
        super.setVisible(b);
    }
}

