/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.ui;

import java.util.List;

class Article {
    final String pmid;
    final String pubDate;
    final String source;
    final String title;
    final List<String> authors;
    final String volume;
    final String issue;
    final String pages;

    public Article(String pmid, String pubDate, String source, String title, List<String> authors, String volume, String issue, String pages) {
        this.pmid = pmid;
        this.pubDate = pubDate;
        this.source = source;
        this.title = title;
        this.authors = authors;
        this.volume = volume;
        this.issue = issue;
        this.pages = pages;
    }

    public String getPmid() {
        return this.pmid;
    }

    public String getPubDate() {
        return this.pubDate;
    }

    public String getSource() {
        return this.source;
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public String getAuthorsAsString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.authors.size(); ++i) {
            buffer.append(this.authors.get(i));
            if (i == this.authors.size() - 1) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public String getVolume() {
        return this.volume;
    }

    public String getIssue() {
        return this.issue;
    }

    public String getPages() {
        return this.pages;
    }

    public String toString() {
        return this.toString("%s. <i>%s</i> %s, %s:%s (%s). %s. PubMed ID: %s.");
    }

    public String toString(String fmtString) {
        return String.format(fmtString, this.getAuthorsAsString(), this.getTitle(), this.getSource(), this.getVolume(), this.getIssue(), this.getPages(), this.getPubDate(), this.getPmid());
    }
}

