/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.task;

import java.util.Collection;
import java.util.Map;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.task.InstallAppsTask;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class ResolveAppConflictTask
extends AbstractTask {
    @Tunable
    public final AppConflict conflict;
    private final Collection<App> appsToInstall;
    private final Map<App, App> appsToReplace;
    private final AppManager appManager;
    private int replaceApps = 0;

    public ResolveAppConflictTask(Collection<App> appsToInstall, Map<App, App> appsToReplace, AppManager appManager) {
        this.appsToInstall = appsToInstall;
        this.appsToReplace = appsToReplace;
        this.appManager = appManager;
        this.conflict = new AppConflict();
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        if (this.replaceApps == 0) {
            this.insertTasksAfterCurrentTask(new Task[]{new InstallAppsTask(this.appsToInstall, this.appsToReplace, this.appManager)});
        }
    }

    public class AppConflict {
        private AppConflict() {
        }

        public Map<App, App> getAppsToReplace() {
            return ResolveAppConflictTask.this.appsToReplace;
        }

        public int getReplaceApps() {
            return ResolveAppConflictTask.this.replaceApps;
        }

        public void setReplaceApps(int replaceApps) {
            ResolveAppConflictTask.this.replaceApps = replaceApps;
        }
    }
}

