/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.task;

import java.util.ArrayList;
import java.util.Collection;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.Update;
import org.cytoscape.app.internal.net.WebApp;
import org.cytoscape.app.internal.task.InstallAppsFromWebAppTask;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;

public class InstallUpdatesTask
extends AbstractTask {
    private final Collection<Update> updates;
    private final AppManager appManager;

    public InstallUpdatesTask(Collection<Update> updates, AppManager appManager) {
        this.updates = updates;
        this.appManager = appManager;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("Install Updates");
        taskMonitor.setTitle("");
        ArrayList<WebApp> webApps = new ArrayList<WebApp>();
        for (Update update : this.updates) {
            webApps.add(update.getWebApp());
        }
        this.insertTasksAfterCurrentTask(new Task[]{new InstallAppsFromWebAppTask(webApps, this.appManager, false)});
    }
}

