/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.net.server;

import org.cytoscape.app.internal.net.server.CyHttpBeforeResponse;
import org.cytoscape.app.internal.net.server.CyHttpRequest;
import org.cytoscape.app.internal.net.server.CyHttpResponse;
import org.cytoscape.app.internal.net.server.CyHttpResponseFactory;
import org.cytoscape.app.internal.net.server.CyHttpResponseFactoryImpl;

public class ScreenOriginsBeforeResponse
implements CyHttpBeforeResponse {
    static final CyHttpResponseFactory responseFactory = new CyHttpResponseFactoryImpl();
    final String[] allowedOrigins;

    public ScreenOriginsBeforeResponse(String ... allowedOrigins) {
        this.allowedOrigins = new String[allowedOrigins.length];
        for (int i = 0; i < allowedOrigins.length; ++i) {
            String origin = allowedOrigins[i];
            if (origin.endsWith("/")) {
                origin = origin.substring(0, origin.length() - 1);
            }
            this.allowedOrigins[i] = origin;
        }
    }

    @Override
    public CyHttpResponse intercept(CyHttpRequest request) {
        String origin = request.getHeaders().get("Origin");
        if (origin == null) {
            return responseFactory.createHttpResponse(403, "<html><body><h1>403 Forbidden</h1>No <tt>Origin</tt> header specified.</body></html>", "text/html");
        }
        for (String allowedOrigin : this.allowedOrigins) {
            if (!allowedOrigin.equals(origin)) continue;
            return null;
        }
        return responseFactory.createHttpResponse(403, String.format("<html><body><h1>403 Forbidden</h1><tt>Origin: %s</tt> not allowed.</body></html>", origin), "text/html");
    }
}

