/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.net.server;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerRegistry;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.cytoscape.app.internal.net.server.CyHttpAfterResponse;
import org.cytoscape.app.internal.net.server.CyHttpBeforeResponse;
import org.cytoscape.app.internal.net.server.CyHttpRequest;
import org.cytoscape.app.internal.net.server.CyHttpRequestImpl;
import org.cytoscape.app.internal.net.server.CyHttpResponder;
import org.cytoscape.app.internal.net.server.CyHttpResponse;
import org.cytoscape.app.internal.net.server.CyHttpd;
import org.cytoscape.app.internal.net.server.ServerSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CyHttpdImpl
implements CyHttpd {
    static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    static final int PORT_REBIND_INTERVAL = 5000;
    final ServerSocketFactory serverSocketFactory;
    final List<CyHttpResponder> responders = new ArrayList<CyHttpResponder>();
    final List<CyHttpBeforeResponse> beforeResponses = new ArrayList<CyHttpBeforeResponse>();
    final List<CyHttpAfterResponse> afterResponses = new ArrayList<CyHttpAfterResponse>();
    boolean running = false;
    boolean aborted = false;
    ExecutorService executor = null;
    final HttpParams params;
    final HttpService service;
    private final Object lock = new Object();

    public CyHttpdImpl(ServerSocketFactory serverSocketFactory) {
        if (serverSocketFactory == null) {
            throw new IllegalArgumentException("serverSocketFactory == null");
        }
        this.serverSocketFactory = serverSocketFactory;
        this.params = new SyncBasicHttpParams().setIntParameter("http.socket.timeout", 5000).setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", (Object)"HttpComponents/1.1");
        ImmutableHttpProcessor proc = new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseDate(), new ResponseServer(), new ResponseContent(), new ResponseConnControl()});
        HttpRequestHandlerRegistry registry = new HttpRequestHandlerRegistry();
        registry.register("*", (HttpRequestHandler)new RequestHandlerDispatcher());
        this.service = new HttpService((HttpProcessor)proc, (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpResponseFactory)new DefaultHttpResponseFactory(), (HttpRequestHandlerResolver)registry, this.params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.running) {
                throw new IllegalStateException("server is running");
            }
            this.executor = Executors.newCachedThreadPool();
            this.aborted = false;
            this.executor.execute(new ServerThread());
            while (!this.running) {
                try {
                    this.lock.wait(500L);
                    if (!this.aborted) continue;
                    return;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public void stop() {
        if (!this.running) {
            throw new IllegalStateException("server is not running");
        }
        this.running = false;
        this.executor.shutdown();
        this.executor = null;
    }

    @Override
    public boolean isRunning() {
        return this.running && !this.aborted;
    }

    @Override
    public void addResponder(CyHttpResponder responder) {
        this.responders.add(responder);
    }

    @Override
    public void removeResponder(CyHttpResponder responder) {
        this.responders.remove(responder);
    }

    @Override
    public Collection<CyHttpResponder> getResponders() {
        return this.responders;
    }

    @Override
    public void addBeforeResponse(CyHttpBeforeResponse beforeResponse) {
        this.beforeResponses.add(beforeResponse);
    }

    @Override
    public void removeBeforeResponse(CyHttpBeforeResponse beforeResponse) {
        this.beforeResponses.remove(beforeResponse);
    }

    @Override
    public Collection<CyHttpBeforeResponse> getBeforeResponses() {
        return this.beforeResponses;
    }

    @Override
    public void addAfterResponse(CyHttpAfterResponse afterResponse) {
        this.afterResponses.add(afterResponse);
    }

    @Override
    public void removeAfterResponse(CyHttpAfterResponse afterResponse) {
        this.afterResponses.remove(afterResponse);
    }

    @Override
    public Collection<CyHttpAfterResponse> getAfterResponses() {
        return this.afterResponses;
    }

    static final void setHttpResponse(CyHttpResponse response, HttpResponse httpResponse) {
        CyHttpdImpl.setHttpResponse(response.getStatusCode(), response.getContent(), response.getContentType(), httpResponse);
        for (Map.Entry<String, String> entry : response.getHeaders().entrySet()) {
            httpResponse.addHeader(entry.getKey(), entry.getValue());
        }
    }

    static final void setHttpResponse(int statusCode, String content, String contentType, HttpResponse httpResponse) {
        httpResponse.setStatusCode(statusCode);
        if (content != null && contentType != null) {
            httpResponse.setEntity((HttpEntity)new StringEntity(content, ContentType.create((String)contentType, (String)"UTF-8")));
        }
    }

    class RequestHandlerDispatcher
    implements HttpRequestHandler {
        RequestHandlerDispatcher() {
        }

        public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException {
            for (Header header : httpRequest.getAllHeaders()) {
                logger.info("{}: {}", (Object)header.getName(), (Object)header.getValue());
            }
            CyHttpRequestImpl request = new CyHttpRequestImpl(httpRequest);
            CyHttpResponse response = this.handle(request);
            if (response == null) {
                CyHttpdImpl.setHttpResponse(404, "<html><body><h1>404 Not Found</h1></body></html>", "text/html", httpResponse);
            } else {
                CyHttpdImpl.setHttpResponse(response, httpResponse);
            }
        }

        private CyHttpResponse handle(CyHttpRequest request) {
            CyHttpResponse response = null;
            for (CyHttpBeforeResponse beforeResponse : CyHttpdImpl.this.beforeResponses) {
                response = beforeResponse.intercept(request);
                if (response == null) continue;
                return response;
            }
            String uri = request.getURI();
            logger.info("Received request: {}", (Object)uri);
            for (CyHttpResponder responder : CyHttpdImpl.this.responders) {
                Matcher matcher = responder.getURIPattern().matcher(uri);
                if (!matcher.matches()) continue;
                response = responder.respond(request, matcher);
                break;
            }
            if (response == null) {
                return null;
            }
            for (CyHttpAfterResponse afterResponse : CyHttpdImpl.this.afterResponses) {
                response = afterResponse.intercept(request, response);
            }
            return response;
        }
    }

    class ConnectionHandler
    implements Runnable {
        final HttpService service;
        final HttpServerConnection connection;

        public ConnectionHandler(HttpService service, HttpServerConnection connection) {
            this.service = service;
            this.connection = connection;
        }

        @Override
        public void run() {
            BasicHttpContext context = new BasicHttpContext(null);
            try {
                while (CyHttpdImpl.this.running && this.connection.isOpen()) {
                    this.service.handleRequest(this.connection, (HttpContext)context);
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (ConnectionClosedException connectionClosedException) {
            }
            catch (IOException e) {
                logger.warn("Failed to complete communication with client; connection closing", (Throwable)e);
            }
            catch (HttpException e) {
                logger.warn("Client violated http; connection closing", (Throwable)e);
            }
            finally {
                try {
                    this.connection.shutdown();
                }
                catch (IOException e) {}
            }
        }
    }

    class ServerThread
    implements Runnable {
        ServerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServerSocket serverSocket = null;
            while (true) {
                try {
                    serverSocket = CyHttpdImpl.this.serverSocketFactory.createServerSocket();
                }
                catch (BindException e) {
                    logger.error("Port already in use", (Throwable)e);
                    CyHttpdImpl.this.aborted = true;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        logger.error("Unexpected interruption", (Throwable)e1);
                    }
                    continue;
                }
                catch (IOException e) {
                    logger.error("Failed to create server socket", (Throwable)e);
                    CyHttpdImpl.this.aborted = true;
                    return;
                }
                break;
            }
            logger.info("Server socket started on {}", (Object)String.format("%s:%d", serverSocket.getInetAddress().getHostAddress(), serverSocket.getLocalPort()));
            CyHttpdImpl.this.running = true;
            Object e = CyHttpdImpl.this.lock;
            synchronized (e) {
                CyHttpdImpl.this.lock.notifyAll();
            }
            while (CyHttpdImpl.this.running) {
                DefaultHttpServerConnection connection = null;
                try {
                    Socket socket = serverSocket.accept();
                    logger.info("Server socket received connection from {}", (Object)socket.getInetAddress().getHostAddress());
                    connection = new DefaultHttpServerConnection();
                    connection.bind(socket, CyHttpdImpl.this.params);
                }
                catch (IOException e2) {
                    logger.error("Failed to initiate connection with client", (Throwable)e2);
                    continue;
                }
                ConnectionHandler connectionHandler = new ConnectionHandler(CyHttpdImpl.this.service, (HttpServerConnection)connection);
                CyHttpdImpl.this.executor.execute(connectionHandler);
            }
            logger.debug("Server socket stopped");
        }
    }
}

