/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.net;

import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.cytoscape.app.event.AppsFinishedStartingEvent;
import org.cytoscape.app.event.AppsFinishedStartingListener;
import org.cytoscape.app.internal.event.UpdatesChangedEvent;
import org.cytoscape.app.internal.event.UpdatesChangedListener;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.Update;
import org.cytoscape.app.internal.ui.downloadsites.DownloadSite;
import org.cytoscape.app.internal.ui.downloadsites.DownloadSitesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateManager
implements AppsFinishedStartingListener {
    private static final Logger sysLogger = LoggerFactory.getLogger(UpdateManager.class);
    private static final Logger userLogger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private AppManager appManager;
    private DownloadSitesManager downloadSitesManager;
    private List<UpdatesChangedListener> updatesChangedListeners;
    private Set<Update> updates = new HashSet<Update>();
    private Calendar lastUpdateCheckTime;
    private Object updateMutex = new Object();

    public UpdateManager(AppManager appManager, DownloadSitesManager downloadSitesManager) {
        this.appManager = appManager;
        this.downloadSitesManager = downloadSitesManager;
        this.updatesChangedListeners = new CopyOnWriteArrayList<UpdatesChangedListener>();
    }

    public void checkForUpdates() {
        this.checkForUpdates(this.appManager.getInstalledApps());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForUpdates(Set<App> apps) {
        Set<Update> set = this.appManager.getWebQuerier().checkForUpdates(apps, this.appManager);
        Object object = this.updateMutex;
        synchronized (object) {
            this.updates.clear();
            this.updates.addAll(set);
            this.lastUpdateCheckTime = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        }
        this.fireUpdatesChangedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Update> getUpdates() {
        HashSet<Update> set = new HashSet<Update>();
        Object object = this.updateMutex;
        synchronized (object) {
            set.addAll(this.updates);
        }
        return set;
    }

    public int getUpdateCount() {
        return this.updates.size();
    }

    public void addUpdatesChangedListener(UpdatesChangedListener listener) {
        this.updatesChangedListeners.add(listener);
    }

    public void removeUpdatesChangedListener(UpdatesChangedListener listener) {
        this.updatesChangedListeners.remove(listener);
    }

    private void fireUpdatesChangedEvent() {
        UpdatesChangedEvent evt = new UpdatesChangedEvent(this);
        for (UpdatesChangedListener listener : this.updatesChangedListeners) {
            listener.updatesChanged(evt);
        }
    }

    public Calendar getLastUpdateCheckTime() {
        return this.lastUpdateCheckTime;
    }

    public void handleEvent(AppsFinishedStartingEvent evt) {
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.submit(() -> {
            for (DownloadSite downloadSite : this.downloadSitesManager.getDownloadSites()) {
                this.appManager.getWebQuerier().setCurrentSiteName(downloadSite.getSiteName());
                this.appManager.getWebQuerier().setCurrentAppStoreUrl(downloadSite.getSiteUrl());
                this.appManager.getWebQuerier().getAllApps();
            }
            this.checkForUpdates(this.appManager.getInstalledApps());
            for (Update update : this.updates) {
                userLogger.info("Update for " + update + " available (latest version: " + update.getUpdateVersion() + ", " + update.getApp().getVersion() + " installed)");
            }
            if (this.updates.size() > 0) {
                userLogger.info(this.updates.size() + " " + (this.updates.size() == 1 ? "update" : "updates") + " available");
            }
        });
    }
}

