/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.manager;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;
import org.cytoscape.app.AbstractCyApp;
import org.cytoscape.app.CyAppAdapter;
import org.cytoscape.app.internal.exception.AppLoadingException;
import org.cytoscape.app.internal.exception.AppStartupException;
import org.cytoscape.app.internal.exception.AppStoppingException;
import org.cytoscape.app.internal.exception.AppUnloadingException;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.util.AppHelper;
import org.cytoscape.app.swing.CySwingAppAdapter;
import org.cytoscape.application.CyVersion;

public class SimpleApp
extends App {
    private File appTemporaryInstallFile;
    private Constructor<?> appConstructor;
    private Class<?> appEntryClass;
    private AbstractCyApp app;

    @Override
    public boolean isHidden() {
        return super.isHidden() && this.app == null;
    }

    @Override
    public String getReadableStatus() {
        switch (this.getStatus()) {
            case INACTIVE: {
                if (this.app != null) {
                    return "Inactive on Restart";
                }
                return "Inactive";
            }
            case DISABLED: {
                if (this.app != null) {
                    return "Disable on Restart";
                }
                return "Disabled";
            }
            case UNINSTALLED: {
                if (this.app != null) {
                    return "Uninstall on Restart";
                }
                return "Uninstalled";
            }
            case FILE_MOVED: {
                return "File Moved (Needs restart to uninstall)";
            }
        }
        return super.getReadableStatus();
    }

    @Override
    public void load(AppManager appManager) throws AppLoadingException {
        if (this.appConstructor != null) {
            return;
        }
        LinkedList<String> uniqueNameDirectory = new LinkedList<String>();
        uniqueNameDirectory.add(appManager.getTemporaryInstallPath());
        try {
            if (this.appTemporaryInstallFile == null) {
                File targetFile = new File(appManager.getTemporaryInstallPath() + File.separator + this.suggestFileName(uniqueNameDirectory, this.getAppFile().getName()));
                FileUtils.copyFile((File)this.getAppFile(), (File)targetFile);
                this.appTemporaryInstallFile = targetFile;
            }
        }
        catch (IOException e) {
            throw new AppLoadingException("Unable to make copy of app jar for instancing", e);
        }
        File installFile = this.appTemporaryInstallFile;
        if (installFile == null) {
            throw new AppLoadingException("No copy of app jar for instancing was found");
        }
        URL appURL = null;
        try {
            appURL = installFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new AppLoadingException("Unable to obtain URL for file: " + installFile, e);
        }
        URLClassLoader appClassLoader = new URLClassLoader(new URL[]{appURL}, appManager.getSwingAppAdapter().getClass().getClassLoader());
        try {
            this.appEntryClass = appClassLoader.loadClass(this.getEntryClassName());
        }
        catch (ClassNotFoundException e) {
            throw new AppLoadingException("Class " + this.getEntryClassName() + " not found in URL: " + appURL, e);
        }
        try {
            try {
                this.appConstructor = this.appEntryClass.getConstructor(CyAppAdapter.class);
            }
            catch (SecurityException e) {
                throw new AppLoadingException("Access to the constructor for " + this.appEntryClass + " denied.", e);
            }
            catch (NoSuchMethodException e) {
                throw new AppLoadingException("Unable to find a constructor for " + this.appEntryClass + " that takes a CyAppAdapter as its argument.", e);
            }
        }
        catch (AppLoadingException e) {
            try {
                this.appConstructor = this.appEntryClass.getConstructor(CySwingAppAdapter.class);
            }
            catch (SecurityException e2) {
                throw new AppLoadingException("Access to the constructor for " + this.appEntryClass + " taking a CySwingAppAdapter as its argument denied.", e2);
            }
            catch (NoSuchMethodException e2) {
                throw new AppLoadingException("Unable to find an accessible constructor that takes either a CyAppAdapter or a CySwingAppAdapter as its argument.", e2);
            }
        }
    }

    @Override
    public void start(AppManager appManager) throws AppStartupException {
        if (this.app != null) {
            return;
        }
        try {
            this.app = (AbstractCyApp)this.appConstructor.newInstance(appManager.getSwingAppAdapter());
        }
        catch (IllegalArgumentException e) {
            throw new AppStartupException("Illegal arguments passed to the constructor for the app's entry class", e);
        }
        catch (InstantiationException e) {
            throw new AppStartupException("Error instantiating the class " + this.appEntryClass, e);
        }
        catch (IllegalAccessException e) {
            throw new AppStartupException("Access to constructor denied", e);
        }
        catch (InvocationTargetException e) {
            throw new AppStartupException("App constructor threw exception", e);
        }
    }

    @Override
    public void unload(AppManager appManager) throws AppUnloadingException {
    }

    @Override
    public void stop(AppManager appManager) throws AppStoppingException {
    }

    @Override
    public boolean isCompatible(CyVersion cyVer) {
        return AppHelper.isCompatible(cyVer, this.getCompatibleVersions());
    }
}

