/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.manager;

import org.cytoscape.app.internal.manager.Version;
import org.cytoscape.app.internal.util.AppUtil;
import org.cytoscape.app.internal.util.MiniTest;

class Range {
    private static final char VERSION_DELIMITER = ',';
    private static final char HARD_START = '[';
    private static final char SOFT_START = '(';
    private static final char HARD_END = ']';
    private static final char SOFT_END = ')';
    private Version lower;
    private boolean lowerInclusive;
    private Version upper;
    private boolean upperInclusive;

    private Range(Version lower, boolean lowerInclusive, Version upper, boolean upperInclusive) {
        this.setRange(lower, lowerInclusive, upper, upperInclusive);
    }

    public Range(String range) throws Exception {
        String string = range = range == null ? null : range.trim();
        if (range == null) {
            this.setRange(new Version(null), true, new Version(null), true);
        } else {
            String[] rangeList = AppUtil.dumbSplit(range, ',');
            if (rangeList.length > 2) {
                throw new Exception("Invalid range " + range);
            }
            String startVersion = rangeList[0];
            int startBound = 91;
            String endVersion = rangeList[rangeList.length - 1];
            int endBound = 93;
            if (startVersion.length() > 0) {
                startBound = startVersion.charAt(0);
                if (startBound == 91 || startBound == 40) {
                    startVersion = startVersion.substring(1);
                } else {
                    startBound = 91;
                }
            }
            if (endVersion.length() > 0) {
                endBound = endVersion.charAt(endVersion.length() - 1);
                if (endBound == 93 || endBound == 41) {
                    endVersion = endVersion.substring(0, endVersion.length() - 1);
                } else {
                    endBound = 93;
                }
            }
            this.lowerInclusive = startBound == 91;
            this.upper = new Version(endVersion);
            this.upperInclusive = endBound == 93;
            this.setRange(new Version(startVersion), this.lowerInclusive, this.upper, this.upperInclusive);
        }
    }

    private void setRange(Version lower, boolean lowerInclusive, Version upper, boolean upperInclusive) {
        this.lower = lower;
        this.lowerInclusive = lowerInclusive;
        this.upper = upper;
        this.upperInclusive = upperInclusive;
    }

    public boolean equals(Range r) {
        return this.equals(r.lower, r.lowerInclusive, r.upper, r.upperInclusive);
    }

    public boolean equals(Version lower, boolean lowerInclusive, Version upper, boolean upperInclusive) {
        return this.lower.compare(lower) == 0 && this.lowerInclusive == lowerInclusive && this.upper.compare(upper) == 0 && this.upperInclusive == upperInclusive;
    }

    public boolean inRange(Version check) {
        if (check != null && check.isDefined()) {
            boolean aboveFloor = true;
            if (this.lower.isDefined()) {
                int compareFloor = this.lower.compare(check);
                aboveFloor = compareFloor < 0 || compareFloor == 0 && this.lowerInclusive;
            }
            boolean belowCeiling = true;
            if (this.upper.isDefined()) {
                int compareCeiling = this.upper.compare(check);
                belowCeiling = compareCeiling > 0 || compareCeiling == 0 && this.upperInclusive;
            }
            return aboveFloor && belowCeiling;
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println("Tester for class Range");
        try {
            MiniTest.isTrue(new Range(null).equals(new Version(""), true, new Version(""), true), "null = open range");
            MiniTest.isTrue(new Range("").equals(new Version(""), true, new Version(""), true), "\"\" = open range");
            MiniTest.isTrue(new Range("  ").equals(new Version(""), true, new Version(""), true), "\"  \" = open range");
            MiniTest.isTrue(new Range("1").equals(new Version("1"), true, new Version("1"), true), "1,1");
            MiniTest.isTrue(new Range("1,").equals(new Version("1"), true, new Version(""), true), "1,open");
            MiniTest.isTrue(new Range(",1").equals(new Version(""), true, new Version("1"), true), "open,1");
            MiniTest.isTrue(new Range("1,10").equals(new Version("1"), true, new Version("10"), true), "1,10");
            MiniTest.isTrue(new Range("1.2.3-alpha,10.11.12-beta").equals(new Version("1.2.3-alpha"), true, new Version("10.11.12-beta"), true), "1.2.3-alpha,10.11.12-beta");
            MiniTest.isTrue(new Range("[1.2.3-alpha,10.11.12-beta)").equals(new Version("1.2.3-alpha"), true, new Version("10.11.12-beta"), false), "[1.2.3-alpha,10.11.12-beta)");
            MiniTest.isTrue(new Range("(1.2.3-alpha,10.11.12-beta]").equals(new Version("1.2.3-alpha"), false, new Version("10.11.12-beta"), true), "(1.2.3-alpha,10.11.12-beta]");
            MiniTest.isTrue(new Range("(,10.11.12-beta]").equals(new Version(""), false, new Version("10.11.12-beta"), true), "(,10.11.12-beta]");
            MiniTest.isTrue(new Range("(1.2.3-alpha,]").equals(new Version("1.2.3-alpha"), false, new Version(""), true), "(1.2.3-alpha,]");
            try {
                new Range("1,2,3");
                System.out.println("1,2,3 exception test FAILED");
            }
            catch (Throwable t) {
                System.out.println("1,2,3 exception test PASSED");
            }
            try {
                new Range("junk");
                System.out.println("junk exception test FAILED");
            }
            catch (Throwable t) {
                System.out.println("junk exception test PASSED");
            }
            try {
                new Range("[junk]");
                System.out.println("[junk] exception test FAILED");
            }
            catch (Throwable t) {
                System.out.println("[junk] exception test PASSED");
            }
            MiniTest.isTrue(!new Range(new Version("3"), true, new Version("4"), false).inRange(null), "null in [3,4)");
            MiniTest.isTrue(!new Range(new Version("3"), true, new Version("4"), false).inRange(new Version("")), "undefined in [3,4)");
            MiniTest.isTrue(new Range(new Version("3"), true, new Version("4"), false).inRange(new Version("3")), "3 in [3,4)");
            MiniTest.isTrue(!new Range(new Version("3"), false, new Version("4"), false).inRange(new Version("3")), "3 in (3,4)");
            MiniTest.isTrue(new Range(new Version("3"), true, new Version("4"), false).inRange(new Version("3.1")), "3.1 in [3,4)");
            MiniTest.isTrue(!new Range(new Version("3"), true, new Version("4"), false).inRange(new Version("4")), "4 in (3,4)");
            MiniTest.isTrue(new Range(new Version("3"), true, new Version("4"), true).inRange(new Version("4")), "4 in (3,4]");
            MiniTest.isTrue(!new Range(new Version("3"), true, new Version("4"), true).inRange(new Version("2")), "2 in (3,4]");
            MiniTest.isTrue(!new Range(new Version("3"), true, new Version("4"), true).inRange(new Version("5")), "5 in (3,4]");
        }
        catch (Throwable t) {
            System.out.println("Should not see exception: " + t);
        }
    }
}

