/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.action;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.UpdateManager;
import org.cytoscape.app.internal.ui.AppManagerMediator;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.event.DebounceTimer;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.TextIcon;

public class UpdateNotificationAction
extends AbstractCyAction {
    private final BadgeIcon icon;
    private final DebounceTimer debounceTimer = new DebounceTimer(2000);
    private final UpdateManager updateManager;
    private final AppManagerMediator appManagerMediator;

    public UpdateNotificationAction(AppManager appManager, UpdateManager updateManager, AppManagerMediator appManagerMediator, CyServiceRegistrar serviceRegistrar) {
        super("App Updates");
        this.updateManager = updateManager;
        this.appManagerMediator = appManagerMediator;
        this.icon = new BadgeIcon((IconManager)serviceRegistrar.getService(IconManager.class));
        this.putValue("SwingLargeIconKey", (Object)this.icon);
        this.putValue("ShortDescription", "App Updates");
        this.setIsInMenuBar(false);
        this.setIsInToolBar(true);
        this.setToolbarGravity(Float.MAX_VALUE);
        appManager.addAppListener(evt -> this.updateEnableState(true));
        updateManager.addUpdatesChangedListener(evt -> this.updateEnableState(false));
    }

    public void actionPerformed(ActionEvent evt) {
        this.appManagerMediator.showAppManager(true, evt);
    }

    public void updateEnableState() {
        this.setEnabled(false);
        int count = this.updateManager.getUpdateCount();
        Object text = count > 0 ? count + " update" + (count > 1 ? "s" : "") + " available!" : "All your apps are up-to-date.";
        this.putValue("LongDescription", text);
        this.icon.setCount(count);
        this.setEnabled(count > 0);
    }

    public void updateEnableState(boolean checkForUpdates) {
        this.debounceTimer.debounce(() -> {
            if (checkForUpdates) {
                this.updateManager.checkForUpdates();
            }
            SwingUtilities.invokeLater(() -> this.updateEnableState());
        });
    }

    private static class BadgeIcon
    extends TextIcon {
        private static float ICON_FONT_SIZE = 24.0f;
        private static int ICON_SIZE = 32;
        private static int BADGE_BORDER_WIDTH = 1;
        private static Color BADGE_COLOR = Color.RED;
        private static Color BADGE_BORDER_COLOR = Color.WHITE;
        private static Color BADGE_TEXT_COLOR = Color.WHITE;
        private static Color ICON_COLOR = UIManager.getColor("CyColor.complement(-2)");
        private int count;
        private final IconManager iconManager;

        public BadgeIcon(IconManager iconManager) {
            super("\uf0f3", iconManager.getIconFont(ICON_FONT_SIZE), ICON_COLOR, ICON_SIZE, ICON_SIZE);
            this.iconManager = iconManager;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            float hr;
            super.paintIcon(c, g, x, y);
            if (!c.isEnabled() || this.count <= 0) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g.create();
            RenderingHints hints = new RenderingHints(null);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHints(hints);
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            float d = (float)Math.max(w, h) / 1.75f;
            float di = d - (float)(2 * BADGE_BORDER_WIDTH);
            float bx = (float)(x + w) - d;
            float by = y;
            g2d.setColor(BADGE_BORDER_COLOR);
            g2d.fillOval(Math.round(bx), Math.round(by), Math.round(d), Math.round(d));
            g2d.setColor(BADGE_COLOR);
            g2d.fillOval(Math.round(bx + (float)BADGE_BORDER_WIDTH), Math.round(by + (float)BADGE_BORDER_WIDTH), Math.round(di), Math.round(di));
            String text = this.count > 99 ? "\uf141" : "" + this.count;
            float th = hr = (float)Math.sqrt(di * di / 2.0f);
            float tw = 0.0f;
            Font textFont = this.count > 99 ? this.iconManager.getIconFont((float)h) : UIManager.getFont("Label.font").deriveFont(1);
            textFont = BadgeIcon.getFont(textFont, th, g2d);
            g2d.setFont(textFont);
            g2d.setColor(BADGE_TEXT_COLOR);
            FontMetrics fm = g2d.getFontMetrics();
            th = fm.getHeight();
            tw = fm.stringWidth(text);
            float tx = bx + (d - hr) / 2.0f;
            float ty = by + (d - hr) / 2.0f;
            g2d.drawString(text, tx += (hr - tw) / 2.0f, ty += (hr - th) / 2.0f + (float)fm.getAscent());
            g2d.dispose();
        }

        public void setCount(int count) {
            this.count = count;
        }

        private static Font getFont(Font f, float height, Graphics g) {
            Font font;
            float size = height;
            Boolean up = null;
            while (true) {
                int testHeight;
                if ((float)(testHeight = g.getFontMetrics(font = f.deriveFont(size)).getHeight()) < height && up != Boolean.FALSE) {
                    size += 1.0f;
                    up = Boolean.TRUE;
                    continue;
                }
                if (!((float)testHeight > height) || up == Boolean.TRUE) break;
                size -= 1.0f;
                up = Boolean.FALSE;
            }
            return font;
        }
    }
}

