/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.application.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.application.CyVersion;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;

public class CyVersionImpl
implements CyVersion {
    private static final String PROPERTY_FILE = "config.properties";
    private static final String APPLICATION_VERSION_PROPERTY = "application.version";
    private static final Pattern p = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)([\\-\\.\\w]*)$");
    private final int major;
    private final int minor;
    private final int bugfix;
    private final String qualifier;
    private final String version;

    public CyVersionImpl(CyServiceRegistrar serviceRegistrar) {
        InputStream stream = this.getClass().getResourceAsStream(PROPERTY_FILE);
        if (stream == null) {
            throw new NullPointerException("Application properties are missing");
        }
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.version = properties.getProperty(APPLICATION_VERSION_PROPERTY);
        if (this.version == null) {
            throw new NullPointerException("No version number found in the provided properties");
        }
        Matcher m = p.matcher(this.version);
        if (!m.matches()) {
            throw new IllegalArgumentException("Malformed version number: " + this.version + "  The version number must match this regular expression: ^(\\d+)\\.(\\d+)\\.(\\d+)([\\-\\.\\w]*)$");
        }
        Properties props = (Properties)((CyProperty)serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)")).getProperties();
        props.setProperty("cytoscape.version.number", this.version);
        this.major = Integer.parseInt(m.group(1));
        this.minor = Integer.parseInt(m.group(2));
        this.bugfix = Integer.parseInt(m.group(3));
        this.qualifier = m.group(4);
        try {
            System.setProperty("cytoscape.version.major", "" + this.major);
            System.setProperty("cytoscape.version.minor", "" + this.minor);
            System.setProperty("cytoscape.version.fix", "" + this.bugfix);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getVersion() {
        return this.version;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public int getBugFixVersion() {
        return this.bugfix;
    }

    public String getQualifier() {
        return this.qualifier;
    }
}

