/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.application.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.cytoscape.application.CyApplicationConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyApplicationConfigurationImpl
implements CyApplicationConfiguration {
    public static final String DEFAULT_CONFIG_DIR = "CytoscapeConfiguration";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String USER_HOME_DIR = System.getProperty("user.home");
    private static final String CYTOSCAPE_HOME_DIR = System.getProperty("cytoscape.home");
    private static final String APP_CONFIGURATION_DIR = "app-data";
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String BUNDLE_VERSION = "Bundle-Version";
    private final File cytoscapeConfigurationDir = new File(USER_HOME_DIR, "CytoscapeConfiguration");
    private final File cytoscapeInstallationDir;
    public static final String activeSessionFilename = "tracker.active.session";

    public CyApplicationConfigurationImpl(String version) {
        if (!this.cytoscapeConfigurationDir.exists()) {
            this.cytoscapeConfigurationDir.mkdir();
            logger.warn("CytoscapeConfiguration directory was not available.  New directory created.");
        } else {
            logger.info("Setting file directory = " + this.cytoscapeConfigurationDir.getAbsolutePath());
        }
        this.cytoscapeInstallationDir = CYTOSCAPE_HOME_DIR != null ? new File(CYTOSCAPE_HOME_DIR) : (USER_DIR != null ? new File(USER_DIR) : null);
        this.addActiveSessionFile(version);
    }

    private void addActiveSessionFile(String version) {
        Path path = Paths.get(this.cytoscapeConfigurationDir.getAbsolutePath(), activeSessionFilename);
        if (path.toFile().exists()) {
            try {
                String content = new String(Files.readAllBytes(path));
                logger.error("Previous session failed to terminate gracefully. " + content);
                this.phoneHome(content);
            }
            catch (Exception e) {
                logger.error("Previous session failed to terminate gracefully and file failed to read.");
            }
        }
        try {
            logger.info("Write tracker.active.session into " + this.cytoscapeConfigurationDir);
            Files.write(path, version.getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            logger.error("Failed to write tracker.active.session into " + this.cytoscapeConfigurationDir);
        }
    }

    private void phoneHome(String content) {
    }

    public File getInstallationDirectoryLocation() {
        return this.cytoscapeInstallationDir;
    }

    public File getConfigurationDirectoryLocation() {
        return this.cytoscapeConfigurationDir;
    }

    public File getAppConfigurationDirectoryLocation(Class<?> appClass) {
        File configurationDirectory = this.getConfigurationDirectoryLocation();
        Bundle bundle = FrameworkUtil.getBundle(appClass);
        if (bundle != null) {
            Dictionary headers = bundle.getHeaders();
            String basePath = (String)headers.get(BUNDLE_SYMBOLIC_NAME);
            String version = (String)headers.get(BUNDLE_VERSION);
            if (version == null) {
                version = "";
            }
            String path = CyApplicationConfigurationImpl.join(File.separator, configurationDirectory.getPath(), APP_CONFIGURATION_DIR, basePath + "-" + version);
            return new File(path);
        }
        URLClassLoader cl = (URLClassLoader)appClass.getClassLoader();
        URL url = cl.findResource("META-INF/MANIFEST.MF");
        try {
            Manifest manifest = new Manifest(url.openStream());
            Attributes a = manifest.getMainAttributes();
            String app = a.getValue("Cytoscape-App");
            String version = a.getValue("Cytoscape-App-Version");
            if (version == null) {
                version = "";
            }
            if (app != null && version != null) {
                String path = CyApplicationConfigurationImpl.join(File.separator, configurationDirectory.getPath(), APP_CONFIGURATION_DIR, app + "-" + version);
                return new File(path);
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String join(String separator, String ... items) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String item : items) {
            if (!first) {
                builder.append(separator);
            }
            builder.append(item);
            first = false;
        }
        return builder.toString();
    }
}

