/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.application.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.application.TableViewRenderer;
import org.cytoscape.application.internal.CyApplicationConfigurationImpl;
import org.cytoscape.application.internal.CyApplicationManagerImpl;
import org.cytoscape.application.internal.CyVersionImpl;
import org.cytoscape.application.internal.DefaultNetworkViewFactory;
import org.cytoscape.application.internal.ShutdownHandler;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyActivator
extends AbstractCyActivator {
    private static final String PROP_PREFIX = "installoptions";
    private static final String SHARE_STATISTICS_TAG = "shareStatistics";
    private static final String SHARE_STATISTICS_DATE_TAG = "shareStatisticsDate";
    private static final String INSTALL_OPTIONS_FILE_NAME = "cytoscape.installoptions";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public void start(BundleContext bc) {
        CyServiceRegistrar serviceRegistrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        Bundle rootBundle = bc.getBundle(0L);
        ShutdownHandler cytoscapeShutdown = new ShutdownHandler(rootBundle, serviceRegistrar);
        CyVersionImpl cytoscapeVersion = new CyVersionImpl(serviceRegistrar);
        CyApplicationConfigurationImpl cyApplicationConfiguration = new CyApplicationConfigurationImpl(cytoscapeVersion.getVersion());
        CyApplicationManagerImpl cyApplicationManager = new CyApplicationManagerImpl(serviceRegistrar);
        this.registerAllServices(bc, cyApplicationManager, new Properties());
        this.registerAllServices(bc, cytoscapeShutdown, new Properties());
        this.registerAllServices(bc, cytoscapeVersion, new Properties());
        this.registerAllServices(bc, cyApplicationConfiguration, new Properties());
        this.registerServiceListener(bc, cyApplicationManager::addNetworkViewRenderer, cyApplicationManager::removeNetworkViewRenderer, NetworkViewRenderer.class);
        this.registerServiceListener(bc, cyApplicationManager::addTableViewRenderer, cyApplicationManager::removeTableViewRenderer, TableViewRenderer.class);
        DefaultNetworkViewFactory viewFactory = new DefaultNetworkViewFactory(cyApplicationManager);
        Properties viewFactoryProperties = new Properties();
        viewFactoryProperties.put("service.ranking", (Object)Integer.MAX_VALUE);
        this.registerService(bc, viewFactory, CyNetworkViewFactory.class, viewFactoryProperties);
        CyProperty cyPropertyServiceRef = (CyProperty)this.getService(bc, CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        this.checkIsntallOptions(cyApplicationConfiguration, (CyProperty<Properties>)cyPropertyServiceRef);
    }

    private void checkIsntallOptions(CyApplicationConfiguration appConfig, CyProperty<Properties> cyPropertyServiceRef) {
        File installationLocation = appConfig.getInstallationDirectoryLocation();
        File optionFile = new File(installationLocation.getAbsolutePath(), INSTALL_OPTIONS_FILE_NAME);
        if (optionFile.exists()) {
            logger.info("Install option file found: " + optionFile.toString());
            Properties prop = new Properties();
            try {
                FileInputStream is = new FileInputStream(optionFile);
                prop.load(is);
            }
            catch (IOException e) {
                logger.warn("Could not read the install option property file.", (Throwable)e);
            }
            String shareStatistics = prop.getProperty(SHARE_STATISTICS_TAG);
            String shareStatisticsDate = prop.getProperty(SHARE_STATISTICS_DATE_TAG);
            String currentDate = ((Properties)cyPropertyServiceRef.getProperties()).getProperty("installoptions.shareStatisticsDate");
            if (shareStatistics == null || shareStatisticsDate == null) {
                return;
            }
            if (currentDate == null) {
                ((Properties)cyPropertyServiceRef.getProperties()).setProperty("installoptions.shareStatistics", shareStatistics);
                ((Properties)cyPropertyServiceRef.getProperties()).setProperty("installoptions.shareStatisticsDate", shareStatisticsDate);
            } else {
                SimpleDateFormat parser = new SimpleDateFormat("yyyymmdd hhmmss");
                try {
                    Date oldDate = parser.parse(currentDate);
                    Date newDate = parser.parse(shareStatisticsDate);
                    int comparison = oldDate.compareTo(newDate);
                    if (comparison < 0) {
                        ((Properties)cyPropertyServiceRef.getProperties()).setProperty("installoptions.shareStatistics", shareStatistics);
                        ((Properties)cyPropertyServiceRef.getProperties()).setProperty("installoptions.shareStatisticsDate", shareStatisticsDate);
                    }
                }
                catch (Exception e) {
                    logger.warn("Failed to parse Share Statistics Date.", (Throwable)e);
                }
            }
        }
    }
}

