/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.command.internal;

import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.command.AvailableCommands;
import org.cytoscape.command.internal.Executor;
import org.cytoscape.command.internal.TFExecutor;
import org.cytoscape.command.internal.tunables.CommandTunableInterceptorImpl;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.DynamicTaskFactoryProvisioner;
import org.cytoscape.task.NetworkTaskFactory;
import org.cytoscape.task.NetworkViewCollectionTaskFactory;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.task.TableTaskFactory;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TaskObserver;

public class CommandExecutorImpl {
    private final Map<String, Map<String, Executor>> commandExecutorMap = new HashMap<String, Map<String, Executor>>();
    private final CommandTunableInterceptorImpl interceptor;
    private final AvailableCommands availableCommands;
    private final CyServiceRegistrar serviceRegistrar;
    private final Object lock = new Object();

    public CommandExecutorImpl(CommandTunableInterceptorImpl interceptor, AvailableCommands availableCommands, CyServiceRegistrar serviceRegistrar) {
        this.interceptor = interceptor;
        this.availableCommands = availableCommands;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void addTaskFactory(TaskFactory tf, Map<?, ?> props) {
        this.addTF(new TFExecutor(tf, this.interceptor), props);
    }

    public void removeTaskFactory(TaskFactory tf, Map<?, ?> props) {
        this.removeTF(props);
    }

    public void addNetworkTaskFactory(NetworkTaskFactory tf, Map<?, ?> props) {
        DynamicTaskFactoryProvisioner provisioner = (DynamicTaskFactoryProvisioner)this.serviceRegistrar.getService(DynamicTaskFactoryProvisioner.class);
        this.addTF(new TFExecutor(provisioner.createFor(tf), this.interceptor), props);
    }

    public void removeNetworkTaskFactory(NetworkTaskFactory tf, Map<?, ?> props) {
        this.removeTF(props);
    }

    public void addNetworkViewTaskFactory(NetworkViewTaskFactory tf, Map<?, ?> props) {
        DynamicTaskFactoryProvisioner provisioner = (DynamicTaskFactoryProvisioner)this.serviceRegistrar.getService(DynamicTaskFactoryProvisioner.class);
        this.addTF(new TFExecutor(provisioner.createFor(tf), this.interceptor), props);
    }

    public void removeNetworkViewTaskFactory(NetworkViewTaskFactory tf, Map<?, ?> props) {
        this.removeTF(props);
    }

    public void addNetworkViewCollectionTaskFactory(NetworkViewCollectionTaskFactory tf, Map<?, ?> props) {
        DynamicTaskFactoryProvisioner provisioner = (DynamicTaskFactoryProvisioner)this.serviceRegistrar.getService(DynamicTaskFactoryProvisioner.class);
        this.addTF(new TFExecutor(provisioner.createFor(tf), this.interceptor), props);
    }

    public void removeNetworkViewCollectionTaskFactory(NetworkViewCollectionTaskFactory tf, Map<?, ?> props) {
        this.removeTF(props);
    }

    public void addTableTaskFactory(TableTaskFactory tf, Map<?, ?> props) {
        DynamicTaskFactoryProvisioner provisioner = (DynamicTaskFactoryProvisioner)this.serviceRegistrar.getService(DynamicTaskFactoryProvisioner.class);
        this.addTF(new TFExecutor(provisioner.createFor(tf), this.interceptor), props);
    }

    public void removeTableTaskFactory(TableTaskFactory tf, Map<?, ?> props) {
        this.removeTF(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTF(Executor ex, Map<?, ?> props) {
        String namespace = (String)props.get("commandNamespace");
        String command = (String)props.get("command");
        if (command == null && namespace == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            Map<String, Executor> map = this.commandExecutorMap.get(namespace);
            if (map == null) {
                map = new HashMap<String, Executor>();
                this.commandExecutorMap.put(namespace, map);
            }
            map.put(command, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTF(Map<?, ?> props) {
        String namespace = (String)props.get("commandNamespace");
        String command = (String)props.get("command");
        if (command == null && namespace == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            Map<String, Executor> ce = this.commandExecutorMap.get(namespace);
            if (ce != null) {
                ce.remove(command);
                if (ce.size() == 0) {
                    this.commandExecutorMap.remove(namespace);
                }
            }
        }
    }

    public void executeList(List<String> commandLines, TaskMonitor tm, TaskObserver observer) throws Exception {
        double size = commandLines.size();
        double count = 1.0;
        for (String fullLine : commandLines) {
            String line = fullLine.trim();
            if (line.startsWith("#") || line.length() == 0) continue;
            this.handleCommand(line, tm, observer);
            tm.setProgress(count / size);
            count += 1.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommand(String namespace, String command, Map<String, Object> args, TaskMonitor tm, TaskObserver observer) throws Exception {
        Executor ex;
        Object object = this.lock;
        synchronized (object) {
            Map<String, Executor> commandMap = this.commandExecutorMap.get(namespace);
            if (commandMap == null) {
                throw new RuntimeException("Failed to find command namespace: '" + namespace + "'");
            }
            ex = commandMap.get(command);
        }
        if (ex == null) {
            throw new RuntimeException("Failed to find command: '" + command + "' (from namespace: " + namespace + ")");
        }
        ex.execute(args, tm, observer);
    }

    private void handleCommand(String commandLine, TaskMonitor tm, TaskObserver observer) throws Exception {
        String ns = null;
        ns = this.isNamespace(commandLine);
        if (ns == null) {
            throw new RuntimeException("Failed to find command namespace: '" + commandLine + "'");
        }
        HashMap<String, Object> settings = new HashMap<String, Object>();
        String comm = CommandExecutorImpl.parseInput(commandLine.substring(ns.length()).trim(), settings);
        String sub = null;
        for (String command : this.availableCommands.getCommands(ns)) {
            if (!command.equalsIgnoreCase(comm)) continue;
            sub = command;
            break;
        }
        if (sub == null && comm != null && comm.length() > 0) {
            throw new RuntimeException("Failed to find command: '" + comm + "' (from namespace: " + ns + ")");
        }
        HashMap<String, Object> modifiedSettings = new HashMap<String, Object>();
        List argList = this.availableCommands.getArguments(ns, comm);
        for (String inputArg : settings.keySet()) {
            boolean found = false;
            for (String arg : argList) {
                String[] bareArg = arg.split("=");
                if (!bareArg[0].trim().equalsIgnoreCase(inputArg)) continue;
                found = true;
                modifiedSettings.put(bareArg[0].trim(), settings.get(inputArg));
                break;
            }
            if (found) continue;
            throw new RuntimeException("Argument: '" + inputArg + " isn't applicable to command: '" + ns + " " + comm + "'");
        }
        this.executeCommand(ns, sub, modifiedSettings, tm, observer);
    }

    private String isNamespace(String input) {
        String namespace = null;
        String[] splits = input.split(" ");
        for (String ns : this.availableCommands.getNamespaces()) {
            if (!splits[0].equalsIgnoreCase(ns) || namespace != null && ns.length() <= namespace.length()) continue;
            namespace = ns;
        }
        return namespace;
    }

    public static String parseInput(String input, Map<String, Object> arguments) {
        StringReader reader = new StringReader(input);
        StreamTokenizer st = new StreamTokenizer(reader);
        st.ordinaryChar(58);
        st.ordinaryChar(47);
        st.ordinaryChar(95);
        st.ordinaryChar(45);
        st.ordinaryChar(46);
        st.ordinaryChars(48, 57);
        st.wordChars(58, 58);
        st.wordChars(47, 47);
        st.wordChars(95, 95);
        st.wordChars(45, 45);
        st.wordChars(46, 46);
        st.wordChars(48, 57);
        ArrayList<String> tokenList = new ArrayList<String>();
        int tokenIndex = 0;
        try {
            int i;
            block6: while ((i = st.nextToken()) != -1) {
                switch (i) {
                    case 61: {
                        i = st.nextToken();
                        if (i != -3 && i != 34 && i != 39) continue block6;
                        String key = (String)tokenList.get(--tokenIndex);
                        arguments.put(key, st.sval);
                        tokenList.remove(tokenIndex);
                        continue block6;
                    }
                    case -3: 
                    case 34: 
                    case 39: {
                        tokenList.add(st.sval);
                        ++tokenIndex;
                        continue block6;
                    }
                }
            }
        }
        catch (Exception e) {
            return "";
        }
        String command = String.join((CharSequence)" ", tokenList);
        return command.trim();
    }
}

