/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.nicecy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.io.internal.cx_reader.ViewMaker;
import org.cytoscape.io.internal.nicecy.Identifiable;
import org.cytoscape.io.internal.nicecy.NiceCyNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.ndexbio.cxio.aspects.datamodels.CartesianLayoutElement;
import org.ndexbio.cxio.aspects.datamodels.CyVisualPropertiesElement;

public class NiceCyView
extends Identifiable {
    private final String name;
    private final NiceCyNetwork.NiceCySubNetwork subnet;
    private Map<Long, CartesianLayoutElement> cartesianLayout;
    private Map<String, CyVisualPropertiesElement> visualProperties;
    private Map<Long, List<CyVisualPropertiesElement>> nodeBypass;
    private Map<Long, List<CyVisualPropertiesElement>> edgeBypass;

    public NiceCyView(long id, NiceCyNetwork.NiceCySubNetwork subnet, String name) {
        super(id);
        this.name = name;
        this.subnet = subnet;
        this.cartesianLayout = new HashMap<Long, CartesianLayoutElement>();
        this.visualProperties = new HashMap<String, CyVisualPropertiesElement>();
        this.nodeBypass = new HashMap<Long, List<CyVisualPropertiesElement>>();
        this.edgeBypass = new HashMap<Long, List<CyVisualPropertiesElement>>();
    }

    public boolean isCartesianLayoutEmpty() {
        return this.cartesianLayout.isEmpty();
    }

    public boolean isVisualPropertiesEmpty() {
        return this.visualProperties.isEmpty();
    }

    public boolean isNodeBypassEmpty() {
        return this.nodeBypass.isEmpty();
    }

    public boolean isEdgeBypassEmpty() {
        return this.edgeBypass.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public void addNodeBypass(Long id, CyVisualPropertiesElement cvpe) {
        if (!this.nodeBypass.containsKey(id)) {
            this.nodeBypass.put(id, new ArrayList());
        }
        this.nodeBypass.get(id).add(cvpe);
    }

    public void addEdgeBypass(Long id, CyVisualPropertiesElement cvpe) {
        if (!this.edgeBypass.containsKey(id)) {
            this.edgeBypass.put(id, new ArrayList());
        }
        this.edgeBypass.get(id).add(cvpe);
    }

    public void addCartesianLayout(long id, CartesianLayoutElement cl) {
        this.cartesianLayout.put(id, cl);
    }

    public void addVisualProperties(CyVisualPropertiesElement cvpe) {
        if (this.visualProperties.containsKey(cvpe.getProperties_of())) {
            cvpe.getDependencies().forEach((k, v) -> this.visualProperties.get(cvpe.getProperties_of()).putDependency(k, v));
            cvpe.getMappings().forEach((k, v) -> this.visualProperties.get(cvpe.getProperties_of()).putMapping(k, v));
            cvpe.getProperties().forEach((k, v) -> this.visualProperties.get(cvpe.getProperties_of()).putProperty(k, v));
        } else {
            this.visualProperties.put(cvpe.getProperties_of(), cvpe);
        }
    }

    public void apply(CyNetworkView v) {
        v.setVisualProperty(BasicVisualLexicon.NETWORK_TITLE, (Object)this.name);
        ViewMaker.makeView(v, this.subnet.parent, this.cartesianLayout, this.visualProperties, this.nodeBypass, this.edgeBypass);
        this.subnet.groups.forEach(suid -> {
            Identifiable.NiceCyGroup group = this.subnet.parent.root_groups.get(suid);
            group.updateInView((CySubNetwork)this.subnet.network);
        });
    }

    public void updateIds(NiceCyView otherView) {
        this.id = otherView.id;
    }
}

