/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.cxio;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cytoscape.io.internal.AspectSet;
import org.cytoscape.io.internal.cxio.Settings;
import org.cytoscape.io.internal.cxio.TimingUtil;
import org.ndexbio.cxio.aspects.datamodels.CartesianLayoutElement;
import org.ndexbio.cxio.aspects.datamodels.EdgeAttributesElement;
import org.ndexbio.cxio.aspects.datamodels.EdgesElement;
import org.ndexbio.cxio.aspects.datamodels.NetworkAttributesElement;
import org.ndexbio.cxio.aspects.datamodels.NodeAttributesElement;
import org.ndexbio.cxio.aspects.datamodels.NodesElement;
import org.ndexbio.cxio.core.CxElementReader2;
import org.ndexbio.cxio.core.interfaces.AspectElement;
import org.ndexbio.cxio.core.interfaces.AspectFragmentReader;
import org.ndexbio.cxio.metadata.MetaDataCollection;
import org.ndexbio.cxio.metadata.MetaDataElement;
import org.ndexbio.model.cx.NiceCXNetwork;

public final class CxImporter {
    private final Set<AspectFragmentReader> all_readers;

    public CxImporter() {
        ArrayList<String> aspects = AspectSet.getAspectNames();
        this.all_readers = new HashSet<AspectFragmentReader>();
        for (AspectFragmentReader reader : AspectSet.getAspectFragmentReaders(aspects)) {
            this.all_readers.add(reader);
        }
    }

    public final void addAdditionalReaders(Collection<AspectFragmentReader> additional_readers) {
        this.all_readers.addAll(additional_readers);
    }

    public final void addAdditionalReader(AspectFragmentReader additional_reader) {
        this.all_readers.add(additional_reader);
    }

    public NiceCXNetwork getCXNetworkFromStream(InputStream in) throws IOException {
        Long cxEdgeIdCounter;
        Long cxNodeIdCounter;
        CxElementReader2 r = new CxElementReader2(in, this.all_readers, true);
        long t0 = System.currentTimeMillis();
        MetaDataCollection metadata = r.getPreMetaData();
        long nodeIdCounter = 0L;
        long edgeIdCounter = 0L;
        NiceCXNetwork niceCX = new NiceCXNetwork();
        block18: for (Object elmt : r) {
            switch (elmt.getAspectName()) {
                case "nodes": {
                    NodesElement n = (NodesElement)elmt;
                    niceCX.addNode(n);
                    if (n.getId() <= nodeIdCounter) continue block18;
                    nodeIdCounter = n.getId();
                    continue block18;
                }
                case "ndexStatus": {
                    continue block18;
                }
                case "edges": {
                    EdgesElement ee = (EdgesElement)elmt;
                    niceCX.addEdge(ee);
                    if (ee.getId() <= edgeIdCounter) continue block18;
                    edgeIdCounter = ee.getId();
                    continue block18;
                }
                case "nodeAttributes": {
                    niceCX.addNodeAttribute((NodeAttributesElement)elmt);
                    continue block18;
                }
                case "networkAttributes": {
                    niceCX.addNetworkAttribute((NetworkAttributesElement)elmt);
                    continue block18;
                }
                case "edgeAttributes": {
                    niceCX.addEdgeAttribute((EdgeAttributesElement)elmt);
                    continue block18;
                }
                case "cartesianLayout": {
                    CartesianLayoutElement e = (CartesianLayoutElement)elmt;
                    niceCX.addNodeAssociatedAspectElement(e.getNode(), (AspectElement)e);
                    continue block18;
                }
            }
            niceCX.addOpaqueAspect((AspectElement)elmt);
        }
        MetaDataCollection postmetadata = r.getPostMetaData();
        if (postmetadata != null) {
            if (metadata == null) {
                metadata = postmetadata;
            } else {
                for (MetaDataElement e : postmetadata) {
                    Long cnt = e.getIdCounter();
                    if (cnt != null) {
                        metadata.setIdCounter(e.getName(), cnt);
                    }
                    if ((cnt = e.getElementCount()) == null) continue;
                    metadata.setElementCount(e.getName(), cnt);
                }
            }
        }
        if ((cxNodeIdCounter = metadata.getIdCounter("nodes")) == null || cxNodeIdCounter < nodeIdCounter) {
            metadata.setIdCounter("nodes", Long.valueOf(nodeIdCounter));
        }
        if ((cxEdgeIdCounter = metadata.getIdCounter("edges")) == null || cxEdgeIdCounter < edgeIdCounter) {
            metadata.setIdCounter("edges", Long.valueOf(edgeIdCounter));
        }
        niceCX.setMetadata(metadata);
        if (Settings.INSTANCE.isTiming()) {
            TimingUtil.reportTimeDifference(t0, "niceCX", niceCX.getMetadata().size());
        }
        return niceCX;
    }
}

