/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.cx_writer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.internal.AspectSet;
import org.cytoscape.io.internal.CyServiceModule;
import org.cytoscape.io.internal.cxio.CxExporter;
import org.cytoscape.io.internal.cxio.CxUtil;
import org.cytoscape.io.internal.cxio.Settings;
import org.cytoscape.io.internal.cxio.TimingUtil;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListMultipleSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxNetworkWriter
implements CyWriter {
    private static final Logger logger = LoggerFactory.getLogger(CxNetworkWriter.class);
    private static final boolean WRITE_SIBLINGS_DEFAULT = false;
    private static final boolean USE_CXID_DEFAULT = true;
    private final OutputStream _os;
    private final CyNetwork _network;
    public ListMultipleSelection<String> aspectFilter = new ListMultipleSelection((Object[])new String[0]);
    public ListMultipleSelection<String> nodeColFilter = new ListMultipleSelection((Object[])new String[0]);
    public ListMultipleSelection<String> edgeColFilter = new ListMultipleSelection((Object[])new String[0]);
    public ListMultipleSelection<String> networkColFilter = new ListMultipleSelection((Object[])new String[0]);
    public boolean writeSiblings = false;
    public boolean useCxId = true;

    @Tunable(description="Aspects")
    public ListMultipleSelection<String> getAspectFilter() {
        return this.aspectFilter;
    }

    @Tunable(description="Node Columns")
    public ListMultipleSelection<String> getNodeColFilter() {
        return this.nodeColFilter;
    }

    @Tunable(description="Edge Columns")
    public ListMultipleSelection<String> getEdgeColFilter() {
        return this.edgeColFilter;
    }

    @Tunable(description="Network Columns")
    public ListMultipleSelection<String> getNetworkColFilter() {
        return this.networkColFilter;
    }

    @Tunable(description="Write all networks in the collection")
    public Boolean getWriteSiblings() {
        return this.writeSiblings;
    }

    public void setWriteSiblings(Boolean writeSiblings) {
        this.writeSiblings = writeSiblings;
    }

    @Tunable(description="Use CX ID (recommended)", dependsOn="writeSiblings=false", listenForChange={"writeSiblings"}, tooltip="Element IDs (nodes, edges) do not normally persist when a network is imported/exported from Cytoscape. Cytoscape uses Session Unique IDs (SUIDs) which are set incrementally. Check this box to persist element IDs (useful for scripting).")
    public boolean getUseCxId() {
        if (this.writeSiblings) {
            return false;
        }
        CyApplicationManager _application_manager = CyServiceModule.getService(CyApplicationManager.class);
        if (!CxUtil.hasCxIds(_application_manager.getCurrentNetwork())) {
            return false;
        }
        return this.useCxId;
    }

    public void setUseCxId(Boolean useCxId) {
        this.useCxId = useCxId;
    }

    public CxNetworkWriter(OutputStream os, CyNetwork network, boolean writeSiblings, boolean useCxId) {
        this._os = os;
        this._network = network;
        this.writeSiblings = writeSiblings;
        this.useCxId = useCxId;
        this.populateFilters();
    }

    private void populateFilters() {
        ArrayList<String> aspects = AspectSet.getAspectNames();
        this.aspectFilter.setPossibleValues(aspects);
        ArrayList<String> nodeColumnNames = this.getAllColumnNames(CyNode.class);
        this.nodeColFilter.setPossibleValues(nodeColumnNames);
        this.nodeColFilter.setSelectedValues(nodeColumnNames);
        ArrayList<String> edgeColumnNames = this.getAllColumnNames(CyEdge.class);
        this.edgeColFilter.setPossibleValues(edgeColumnNames);
        this.edgeColFilter.setSelectedValues(edgeColumnNames);
        ArrayList<String> networkColumnNames = this.getAllColumnNames(CyNetwork.class);
        this.networkColFilter.setPossibleValues(networkColumnNames);
        this.networkColFilter.setSelectedValues(networkColumnNames);
    }

    private final Set<String> getAllColumnNames(Class<? extends CyIdentifiable> type, CyNetwork subnet) {
        TreeSet<String> colNames = new TreeSet<String>();
        CyTable sharedTable = subnet.getTable(type, "USER");
        colNames.addAll(sharedTable.getColumns().stream().map(col -> col.getName()).collect(Collectors.toList()));
        CyTable localTable = subnet.getTable(type, "LOCAL_ATTRS");
        colNames.addAll(localTable.getColumns().stream().map(col -> col.getName()).collect(Collectors.toList()));
        CyTable hiddenTable = subnet.getTable(type, "HIDDEN");
        colNames.addAll(hiddenTable.getColumns().stream().map(col -> col.getName()).collect(Collectors.toList()));
        return colNames;
    }

    private final ArrayList<String> getAllColumnNames(Class<? extends CyIdentifiable> type) {
        Set<String> colNames = this.getAllColumnNames(type, this._network);
        if (type == CyNetwork.class && this._network instanceof CySubNetwork) {
            CyRootNetwork root = ((CySubNetwork)this._network).getRootNetwork();
            CyTable rootTable = root.getDefaultNetworkTable();
            colNames.addAll(rootTable.getColumns().stream().map(col -> col.getName()).collect(Collectors.toList()));
            for (CySubNetwork subnet : root.getSubNetworkList()) {
                if (subnet == this._network) continue;
                colNames.addAll(this.getAllColumnNames(type, (CyNetwork)subnet));
            }
        }
        return new ArrayList<String>(colNames);
    }

    public void run(TaskMonitor taskMonitor) throws FileNotFoundException, IOException {
        if (taskMonitor != null) {
            taskMonitor.setProgress(0.0);
            taskMonitor.setTitle("Exporting to CX");
            taskMonitor.setStatusMessage("Exporting current network as CX...");
        }
        CxExporter exporter = new CxExporter(this._network, this.writeSiblings, this.useCxId);
        List aspects = this.aspectFilter.getSelectedValues();
        exporter.setNodeColumnFilter(this.nodeColFilter.getSelectedValues().stream().filter(columnName -> this.writeSiblings || !Settings.IGNORE_SINGLE_NETWORK_NODE_ATTRIBUTES.contains(columnName)).collect(Collectors.toList()));
        exporter.setEdgeColumnFilter(this.edgeColFilter.getSelectedValues().stream().filter(columnName -> this.writeSiblings || !Settings.IGNORE_SINGLE_NETWORK_EDGE_ATTRIBUTES.contains(columnName)).collect(Collectors.toList()));
        exporter.setNetworkColumnFilter(this.networkColFilter.getSelectedValues().stream().filter(columnName -> this.writeSiblings || !Settings.IGNORE_SINGLE_NETWORK_NETWORK_ATTRIBUTES.contains(columnName)).collect(Collectors.toList()));
        long t0 = System.currentTimeMillis();
        exporter.writeNetwork(aspects, this._os);
        this._os.close();
        if (Settings.INSTANCE.isTiming()) {
            TimingUtil.reportTimeDifference(t0, "total time", -1);
        }
    }

    public void cancel() {
        if (this._os == null) {
            return;
        }
        try {
            this._os.close();
        }
        catch (IOException e) {
            logger.error("Could not close Outputstream for CxNetworkWriter.", (Throwable)e);
        }
    }
}

