/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.cx_reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringParser {
    private final Map<String, String> _data = new HashMap<String, String>();
    private static final Pattern p0 = Pattern.compile("(?<=(^|,))([^,]|,,)*(?=(,|$))");
    private static final Pattern p = Pattern.compile("^((K|V|L|E|G|OV)=([0-9]+))=(.*)$");

    public static List<String> commaDelimitedListStringToStringList2(String list) {
        Matcher matcher = p0.matcher(list);
        ArrayList<String> result = new ArrayList<String>();
        while (matcher.find()) {
            String v = matcher.group();
            if (v.length() <= 0) continue;
            result.add(v);
        }
        return result;
    }

    public StringParser(String str) throws IOException {
        List<String> array = StringParser.commaDelimitedListStringToStringList2(str);
        for (String n : array) {
            String v;
            if (n.startsWith("COL=")) {
                v = n.substring(4);
                this._data.put("COL", v.replace(",,", ","));
                continue;
            }
            if (n.startsWith("T=")) {
                v = n.substring(2);
                this._data.put("T", v.replace(",,", ","));
                continue;
            }
            Matcher m = p.matcher(n);
            if (!m.matches()) {
                throw new IOException("Failed to parse mapping string: " + n);
            }
            this._data.put(m.group(1), m.group(4).replace(",,", ","));
        }
    }

    public final String get(String key) {
        return this._data.get(key);
    }
}

