/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.network.merge.internal.NetworkMerge;
import org.cytoscape.network.merge.internal.conflict.AttributeConflictCollectorImpl;
import org.cytoscape.network.merge.internal.model.AttributeMapping;
import org.cytoscape.network.merge.internal.model.AttributeMappingImpl;
import org.cytoscape.network.merge.internal.model.MatchingAttribute;
import org.cytoscape.network.merge.internal.model.MatchingAttributeImpl;
import org.cytoscape.network.merge.internal.task.NetworkMergeTask;
import org.cytoscape.network.merge.internal.ui.MatchNodeTable;
import org.cytoscape.network.merge.internal.ui.MergeAttributeTable;
import org.cytoscape.network.merge.internal.ui.NetworkListModel;
import org.cytoscape.network.merge.internal.ui.SortedNetworkListModel;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CyNetworkNaming;
import org.cytoscape.util.swing.BasicCollapsiblePanel;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.swing.DialogTaskManager;

public class NetworkMergeDialog
extends JDialog {
    private static final long serialVersionUID = 1013626339762545400L;
    private final CyNetworkManager cnm;
    private final CyNetworkNaming cnn;
    private final CyServiceRegistrar serviceRegistrar;
    private final TaskManager<?, ?> taskManager;
    private final IconManager iconMgr;
    private JPanel operationPnl;
    private ButtonGroup operationGroup;
    private JPanel differencePnl;
    private JRadioButton difference1Btn;
    private JRadioButton difference2Btn;
    private ButtonGroup differenceGroup;
    private JPanel selectNetPnl;
    private JButton moveRightBtn;
    private JButton moveLeftBtn;
    private JButton moveUpBtn;
    private JButton moveDownBtn;
    private JList<CyNetwork> unselectedNetLs;
    private JList<CyNetwork> selectedNetLs;
    private BasicCollapsiblePanel advancedOptionsPnl;
    private JScrollPane attrScr;
    private NetworkListModel selectedNetData;
    private SortedNetworkListModel unselectedNetData;
    private JTabbedPane mergeAttrTp;
    private JPanel mergeNodeAttrPnl;
    private JPanel mergeEdgeAttrPnl;
    private JPanel mergeNetAttrPnl;
    private MatchNodeTable matchNodeTbl;
    private MergeAttributeTable mergeNodeAttrTbl;
    private MergeAttributeTable mergeEdgeAttrTbl;
    private MergeAttributeTable mergeNetAttrTbl;
    private JCheckBox idMappingCkb;
    private JCheckBox inNetMergeCkb;
    private JCheckBox NodesOnly;
    private JPanel buttonPnl;
    private JButton cancelBtn;
    private JButton okBtn;
    private final TreeMap<NetworkMerge.Operation, AbstractButton> operationButtons;
    private final AttributeMapping nodeAttrMapping;
    private final AttributeMapping edgeAttrMapping;
    private final AttributeMapping netAttrMapping;
    private final MatchingAttribute matchingAttr;
    private NetworkMerge.Operation selectedOperation = NetworkMerge.Operation.UNION;

    public NetworkMergeDialog(CyServiceRegistrar serviceRegistrar) {
        this.setDefaultCloseOperation(2);
        this.serviceRegistrar = serviceRegistrar;
        this.cnm = (CyNetworkManager)serviceRegistrar.getService(CyNetworkManager.class);
        this.cnn = (CyNetworkNaming)serviceRegistrar.getService(CyNetworkNaming.class);
        this.taskManager = (TaskManager)serviceRegistrar.getService(DialogTaskManager.class);
        this.iconMgr = (IconManager)serviceRegistrar.getService(IconManager.class);
        this.operationButtons = new TreeMap();
        this.matchingAttr = new MatchingAttributeImpl();
        this.nodeAttrMapping = new AttributeMappingImpl();
        this.edgeAttrMapping = new AttributeMappingImpl();
        this.netAttrMapping = new AttributeMappingImpl();
        this.initComponents();
        this.updateOKButton();
    }

    private void initComponents() {
        this.setTitle("Advanced Network Merge");
        this.setResizable(false);
        this.operationGroup = new ButtonGroup();
        this.differenceGroup = new ButtonGroup();
        this.differenceGroup.add(this.getDifference1Btn());
        this.differenceGroup.add(this.getDifference2Btn());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getOperationPnl(), -1, -1, Short.MAX_VALUE).addComponent(this.getDifferencePnl(), -1, -1, Short.MAX_VALUE).addComponent(this.getSelectNetPnl(), -1, -1, Short.MAX_VALUE).addComponent((Component)this.getAdvancedOptionsPnl(), -1, -1, Short.MAX_VALUE).addComponent(this.getButtonPnl(), -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getOperationPnl(), -1, -1, Short.MAX_VALUE).addComponent(this.getDifferencePnl(), -1, -1, Short.MAX_VALUE).addComponent(this.getSelectNetPnl(), -1, -1, Short.MAX_VALUE).addComponent((Component)this.getAdvancedOptionsPnl(), -1, -1, Short.MAX_VALUE).addComponent(this.getButtonPnl(), -2, -1, -2));
        this.updateDifferencePanel();
        this.updateOperationPanel();
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)this.getOkBtn().getAction(), (Action)this.getCancelBtn().getAction());
        this.getRootPane().setDefaultButton(this.getOkBtn());
        this.pack();
    }

    private JPanel getOperationPnl() {
        if (this.operationPnl == null) {
            NetworkMerge.Operation[] values;
            this.operationPnl = new JPanel();
            this.operationPnl.setLayout(new BoxLayout(this.operationPnl, 2));
            this.operationPnl.add(Box.createHorizontalGlue());
            int count = 0;
            for (NetworkMerge.Operation op : values = NetworkMerge.Operation.values()) {
                JToggleButton btn = new JToggleButton(op.toString(), op.getIcon());
                btn.setActionCommand(op.name());
                this.operationGroup.add(btn);
                this.operationButtons.put(op, btn);
                btn.putClientProperty("JComponent.sizeVariant", "regular");
                btn.putClientProperty("JButton.buttonType", "segmented");
                if (count == 0) {
                    btn.putClientProperty("JButton.segmentPosition", "first");
                } else if (count == values.length - 1) {
                    btn.putClientProperty("JButton.segmentPosition", "last");
                } else {
                    btn.putClientProperty("JButton.segmentPosition", "middle");
                }
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        String actionCommand = evt.getActionCommand();
                        NetworkMerge.Operation selectOp = NetworkMerge.Operation.valueOf(actionCommand);
                        int nSelectedNetwork = NetworkMergeDialog.this.selectedNetData.getSize();
                        if (selectOp == NetworkMerge.Operation.DIFFERENCE && nSelectedNetwork > 2) {
                            int ioption = JOptionPane.showConfirmDialog(NetworkMergeDialog.this, "Only the first two networks in the selected network list will be merged for difference operation. All the other selected networks will be removed. Are you sure?", "Warning: only two networks will be kept", 0);
                            if (ioption == 1 && NetworkMergeDialog.this.selectedOperation != null) {
                                NetworkMergeDialog.this.operationGroup.setSelected(NetworkMergeDialog.this.operationButtons.get((Object)NetworkMergeDialog.this.selectedOperation).getModel(), true);
                                return;
                            }
                            for (int is = nSelectedNetwork - 1; is >= 2; --is) {
                                CyNetwork removed = NetworkMergeDialog.this.selectedNetData.removeElement(is);
                                NetworkMergeDialog.this.unselectedNetData.add(removed);
                                NetworkMergeDialog.this.addRemoveAttributeMapping(removed, false);
                            }
                            NetworkMergeDialog.this.getSelectedNetLs().repaint();
                            NetworkMergeDialog.this.getUnselectedNetLs().repaint();
                            NetworkMergeDialog.this.updateAttributeTable();
                            NetworkMergeDialog.this.updateMergeAttributeTable();
                        }
                        NetworkMergeDialog.this.selectedOperation = selectOp;
                        NetworkMergeDialog.this.updateDifferencePanel();
                        NetworkMergeDialog.this.updateOperationPanel();
                        NetworkMergeDialog.this.updateUpDownButtons();
                        NetworkMergeDialog.this.updateOKButton();
                    }
                });
                this.operationPnl.add(btn);
                ++count;
            }
            this.operationPnl.add(Box.createHorizontalGlue());
            this.operationGroup.setSelected(this.operationButtons.get((Object)NetworkMerge.Operation.values()[0]).getModel(), true);
        }
        return this.operationPnl;
    }

    private JPanel getDifferencePnl() {
        if (this.differencePnl == null) {
            this.differencePnl = new JPanel();
            GroupLayout layout = new GroupLayout(this.differencePnl);
            this.differencePnl.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.getDifference1Btn()).addComponent(this.getDifference2Btn()));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getDifference1Btn()).addComponent(this.getDifference2Btn()));
        }
        return this.differencePnl;
    }

    private JRadioButton getDifference1Btn() {
        if (this.difference1Btn == null) {
            this.difference1Btn = new JRadioButton("Only remove nodes if all their edges are being subtracted, too");
            this.difference1Btn.setSelected(true);
        }
        return this.difference1Btn;
    }

    private JRadioButton getDifference2Btn() {
        if (this.difference2Btn == null) {
            this.difference2Btn = new JRadioButton("Remove all nodes that are in the 2\u207f\u1d48 network");
        }
        return this.difference2Btn;
    }

    private JPanel getSelectNetPnl() {
        if (this.selectNetPnl == null) {
            this.selectNetPnl = new JPanel();
            JLabel allNetsLbl = new JLabel("Available Networks:");
            JLabel selNetsLbl = new JLabel("Networks to Merge:");
            JScrollPane listScr1 = new JScrollPane(this.getUnselectedNetLs());
            listScr1.setPreferredSize(new Dimension(260, 72));
            JScrollPane listScr2 = new JScrollPane(this.getSelectedNetLs());
            listScr2.setPreferredSize(new Dimension(260, 72));
            GroupLayout layout = new GroupLayout(this.selectNetPnl);
            this.selectNetPnl.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(LookAndFeelUtil.isWinLAF());
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(allNetsLbl, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(listScr1, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getMoveRightBtn(), -1, -1, Short.MAX_VALUE).addComponent(this.getMoveLeftBtn(), -1, -1, Short.MAX_VALUE)))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addComponent(selNetsLbl, -1, -1, Short.MAX_VALUE).addComponent(this.getMoveUpBtn(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getMoveDownBtn(), -2, -1, -2)).addComponent(listScr2, -1, -1, Short.MAX_VALUE)));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(allNetsLbl, -2, -1, -2).addComponent(selNetsLbl, -2, -1, -2).addComponent(this.getMoveUpBtn(), -2, -1, -2).addComponent(this.getMoveDownBtn(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE, true).addComponent(listScr1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 1, Short.MAX_VALUE).addComponent(this.getMoveRightBtn(), -2, -1, -2).addComponent(this.getMoveLeftBtn(), -2, -1, -2).addGap(0, 1, Short.MAX_VALUE)).addComponent(listScr2, -1, -1, Short.MAX_VALUE)));
        }
        return this.selectNetPnl;
    }

    private JList<CyNetwork> getUnselectedNetLs() {
        if (this.unselectedNetLs == null) {
            this.unselectedNetData = new SortedNetworkListModel();
            this.unselectedNetLs = new JList<CyNetwork>(this.unselectedNetData);
            for (CyNetwork network : this.cnm.getNetworkSet()) {
                this.unselectedNetData.add(network);
            }
            this.unselectedNetLs.setCellRenderer(new ListCellRenderer<CyNetwork>(){
                private DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

                @Override
                public Component getListCellRendererComponent(JList<? extends CyNetwork> list, CyNetwork value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    renderer.setText(value.toString());
                    return renderer;
                }
            });
            this.unselectedNetLs.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent evt) {
                    int index = NetworkMergeDialog.this.unselectedNetLs.getMinSelectionIndex();
                    if (index > -1) {
                        NetworkMergeDialog.this.selectedNetLs.getSelectionModel().clearSelection();
                        NetworkMergeDialog.this.getMoveRightBtn().setEnabled(true);
                    } else {
                        NetworkMergeDialog.this.getMoveRightBtn().setEnabled(false);
                    }
                }
            });
        }
        return this.unselectedNetLs;
    }

    private JList<CyNetwork> getSelectedNetLs() {
        if (this.selectedNetLs == null) {
            this.selectedNetData = new NetworkListModel();
            this.selectedNetLs = new JList<CyNetwork>(this.selectedNetData);
            this.selectedNetLs.setSelectionMode(1);
            this.selectedNetLs.setCellRenderer(new ListCellRenderer<CyNetwork>(){
                private DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

                @Override
                public Component getListCellRendererComponent(JList<? extends CyNetwork> list, CyNetwork value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    renderer.setText(value.toString());
                    return renderer;
                }
            });
            this.selectedNetLs.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent evt) {
                    int index = NetworkMergeDialog.this.selectedNetLs.getMinSelectionIndex();
                    if (index > -1) {
                        NetworkMergeDialog.this.getUnselectedNetLs().getSelectionModel().clearSelection();
                        NetworkMergeDialog.this.getMoveLeftBtn().setEnabled(true);
                    } else {
                        NetworkMergeDialog.this.getMoveLeftBtn().setEnabled(false);
                    }
                    NetworkMergeDialog.this.updateUpDownButtons();
                }
            });
        }
        return this.selectedNetLs;
    }

    private JButton getMoveRightBtn() {
        if (this.moveRightBtn == null) {
            this.moveRightBtn = new JButton("\uf105");
            this.moveRightBtn.setFont(this.iconMgr.getIconFont(14.0f));
            this.moveRightBtn.setToolTipText("Add Selected");
            this.moveRightBtn.setEnabled(false);
            this.moveRightBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int[] indices = NetworkMergeDialog.this.getUnselectedNetLs().getSelectedIndices();
                    if (indices == null || indices.length == 0) {
                        return;
                    }
                    if (NetworkMergeDialog.this.getOperation() == NetworkMerge.Operation.DIFFERENCE && NetworkMergeDialog.this.selectedNetData.getSize() + indices.length > 2) {
                        JOptionPane.showMessageDialog(NetworkMergeDialog.this, "Difference operation only supports two networks. If you need to replace the selected network, remove it first and select the new one.", "Warning", 2);
                        return;
                    }
                    for (int i = indices.length - 1; i >= 0; --i) {
                        CyNetwork removed = NetworkMergeDialog.this.unselectedNetData.removeElement(indices[i]);
                        NetworkMergeDialog.this.selectedNetData.add(removed);
                        NetworkMergeDialog.this.addRemoveAttributeMapping(removed, true);
                    }
                    if (NetworkMergeDialog.this.unselectedNetData.getSize() == 0) {
                        NetworkMergeDialog.this.getUnselectedNetLs().clearSelection();
                        NetworkMergeDialog.this.moveRightBtn.setEnabled(false);
                    } else {
                        int minindex = NetworkMergeDialog.this.getUnselectedNetLs().getMinSelectionIndex();
                        if (minindex >= NetworkMergeDialog.this.unselectedNetData.getSize()) {
                            minindex = 0;
                        }
                        NetworkMergeDialog.this.getUnselectedNetLs().setSelectedIndex(minindex);
                    }
                    NetworkMergeDialog.this.getSelectedNetLs().repaint();
                    NetworkMergeDialog.this.getUnselectedNetLs().repaint();
                    NetworkMergeDialog.this.updateOKButton();
                    NetworkMergeDialog.this.updateAttributeTable();
                    NetworkMergeDialog.this.updateMergeAttributeTable();
                }
            });
        }
        return this.moveRightBtn;
    }

    private JButton getMoveLeftBtn() {
        if (this.moveLeftBtn == null) {
            this.moveLeftBtn = new JButton("\uf104");
            this.moveLeftBtn.setFont(this.iconMgr.getIconFont(14.0f));
            this.moveLeftBtn.setToolTipText("Remove Selected");
            this.moveLeftBtn.setEnabled(false);
            this.moveLeftBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int[] indices = NetworkMergeDialog.this.getSelectedNetLs().getSelectedIndices();
                    if (indices == null || indices.length == 0) {
                        return;
                    }
                    for (int i = indices.length - 1; i >= 0; --i) {
                        CyNetwork removed = NetworkMergeDialog.this.selectedNetData.removeElement(indices[i]);
                        NetworkMergeDialog.this.unselectedNetData.add(removed);
                        NetworkMergeDialog.this.addRemoveAttributeMapping(removed, false);
                    }
                    if (NetworkMergeDialog.this.selectedNetData.getSize() == 0) {
                        NetworkMergeDialog.this.getSelectedNetLs().clearSelection();
                        NetworkMergeDialog.this.moveLeftBtn.setEnabled(false);
                    } else {
                        int minindex = NetworkMergeDialog.this.getSelectedNetLs().getMinSelectionIndex();
                        if (minindex >= NetworkMergeDialog.this.selectedNetData.getSize()) {
                            minindex = 0;
                        }
                        NetworkMergeDialog.this.getSelectedNetLs().setSelectedIndex(minindex);
                    }
                    NetworkMergeDialog.this.getSelectedNetLs().repaint();
                    NetworkMergeDialog.this.getUnselectedNetLs().repaint();
                    NetworkMergeDialog.this.updateOKButton();
                    NetworkMergeDialog.this.updateAttributeTable();
                    NetworkMergeDialog.this.updateMergeAttributeTable();
                }
            });
        }
        return this.moveLeftBtn;
    }

    private JButton getMoveUpBtn() {
        if (this.moveUpBtn == null) {
            this.moveUpBtn = new JButton("\uf0d8");
            this.moveUpBtn.setFont(this.iconMgr.getIconFont(17.0f));
            this.moveUpBtn.setToolTipText("Move Selected Up");
            this.moveUpBtn.setBorderPainted(false);
            this.moveUpBtn.setContentAreaFilled(false);
            this.moveUpBtn.setOpaque(false);
            this.moveUpBtn.setFocusPainted(false);
            this.moveUpBtn.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            this.moveUpBtn.setEnabled(false);
            this.moveUpBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int[] indices = NetworkMergeDialog.this.getSelectedNetLs().getSelectedIndices();
                    if (indices == null || indices.length == 0) {
                        return;
                    }
                    int imin = NetworkMergeDialog.this.getSelectedNetLs().getMinSelectionIndex();
                    int imax = NetworkMergeDialog.this.getSelectedNetLs().getMaxSelectionIndex();
                    if (imin < 1) {
                        return;
                    }
                    CyNetwork removed = NetworkMergeDialog.this.selectedNetData.removeElement(imin - 1);
                    NetworkMergeDialog.this.selectedNetData.add(imax, removed);
                    int ii = 0;
                    while (ii < indices.length) {
                        int n = ii++;
                        indices[n] = indices[n] - 1;
                    }
                    NetworkMergeDialog.this.getSelectedNetLs().setSelectedIndices(indices);
                    NetworkMergeDialog.this.updateUpDownButtons();
                    NetworkMergeDialog.this.getSelectedNetLs().repaint();
                    NetworkMergeDialog.this.getUnselectedNetLs().repaint();
                    NetworkMergeDialog.this.updateOKButton();
                    NetworkMergeDialog.this.updateAttributeTable();
                    NetworkMergeDialog.this.updateMergeAttributeTable();
                }
            });
        }
        return this.moveUpBtn;
    }

    private JButton getMoveDownBtn() {
        if (this.moveDownBtn == null) {
            this.moveDownBtn = new JButton("\uf0d7");
            this.moveDownBtn.setFont(this.iconMgr.getIconFont(17.0f));
            this.moveDownBtn.setToolTipText("Move Selected Down");
            this.moveDownBtn.setBorderPainted(false);
            this.moveDownBtn.setContentAreaFilled(false);
            this.moveDownBtn.setOpaque(false);
            this.moveDownBtn.setFocusPainted(false);
            this.moveDownBtn.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            this.moveDownBtn.setEnabled(false);
            this.moveDownBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int[] indices = NetworkMergeDialog.this.getSelectedNetLs().getSelectedIndices();
                    if (indices == null || indices.length == 0) {
                        return;
                    }
                    int imin = NetworkMergeDialog.this.getSelectedNetLs().getMinSelectionIndex();
                    int imax = NetworkMergeDialog.this.getSelectedNetLs().getMaxSelectionIndex();
                    if (imax >= NetworkMergeDialog.this.selectedNetData.getSize() - 1) {
                        return;
                    }
                    CyNetwork removed = NetworkMergeDialog.this.selectedNetData.removeElement(imax + 1);
                    NetworkMergeDialog.this.selectedNetData.add(imin, removed);
                    int ii = 0;
                    while (ii < indices.length) {
                        int n = ii++;
                        indices[n] = indices[n] + 1;
                    }
                    NetworkMergeDialog.this.getSelectedNetLs().setSelectedIndices(indices);
                    NetworkMergeDialog.this.updateUpDownButtons();
                    NetworkMergeDialog.this.getSelectedNetLs().repaint();
                    NetworkMergeDialog.this.getUnselectedNetLs().repaint();
                    NetworkMergeDialog.this.updateOKButton();
                    NetworkMergeDialog.this.updateAttributeTable();
                    NetworkMergeDialog.this.updateMergeAttributeTable();
                }
            });
        }
        return this.moveDownBtn;
    }

    private BasicCollapsiblePanel getAdvancedOptionsPnl() {
        if (this.advancedOptionsPnl == null) {
            this.advancedOptionsPnl = new BasicCollapsiblePanel("Advanced Options");
            this.advancedOptionsPnl.addCollapseListener(new BasicCollapsiblePanel.CollapseListener(){

                public void collapsed() {
                    NetworkMergeDialog.this.updateOKButton();
                    NetworkMergeDialog.this.pack();
                }

                public void expanded() {
                    NetworkMergeDialog.this.updateOKButton();
                    NetworkMergeDialog.this.pack();
                }
            });
            JLabel matchingColumnsLbl = new JLabel("Matching Columns (table columns to match nodes between networks):");
            JLabel howLbl = new JLabel("How to merge columns:");
            GroupLayout layout = new GroupLayout(this.advancedOptionsPnl.getContentPane());
            this.advancedOptionsPnl.getContentPane().setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(matchingColumnsLbl).addComponent(this.getAttrScr(), -1, -1, Short.MAX_VALUE).addComponent(this.getIdMappingCkb()).addComponent(howLbl).addComponent(this.getMergeAttrTp(), -1, -1, Short.MAX_VALUE).addComponent(this.getInNetMergeCkb()).addComponent(this.getNodesOnly()));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(matchingColumnsLbl).addComponent(this.getAttrScr(), -1, -1, Short.MAX_VALUE).addComponent(this.getIdMappingCkb()).addComponent(howLbl).addComponent(this.getMergeAttrTp(), -1, -1, Short.MAX_VALUE).addComponent(this.getInNetMergeCkb()).addComponent(this.getNodesOnly()));
        }
        return this.advancedOptionsPnl;
    }

    private JScrollPane getAttrScr() {
        if (this.attrScr == null) {
            this.attrScr = new JScrollPane();
            this.attrScr.setMinimumSize(new Dimension(100, 50));
            this.attrScr.setPreferredSize(new Dimension(450, 50));
            this.attrScr.setViewportView(this.getMatchNodeTbl());
        }
        return this.attrScr;
    }

    private MatchNodeTable getMatchNodeTbl() {
        if (this.matchNodeTbl == null) {
            this.matchNodeTbl = new MatchNodeTable(this.matchingAttr);
            this.matchNodeTbl.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    NetworkMergeDialog.this.getMergeNodeAttrTbl().updateMatchingAttribute();
                }
            });
        }
        return this.matchNodeTbl;
    }

    private MergeAttributeTable getMergeNodeAttrTbl() {
        if (this.mergeNodeAttrTbl == null) {
            this.mergeNodeAttrTbl = new MergeAttributeTable(this.nodeAttrMapping, this.matchingAttr);
        }
        return this.mergeNodeAttrTbl;
    }

    private MergeAttributeTable getMergeEdgeAttrTbl() {
        if (this.mergeEdgeAttrTbl == null) {
            this.mergeEdgeAttrTbl = new MergeAttributeTable(this.edgeAttrMapping);
        }
        return this.mergeEdgeAttrTbl;
    }

    private MergeAttributeTable getMergeNetAttrTbl() {
        if (this.mergeNetAttrTbl == null) {
            this.mergeNetAttrTbl = new MergeAttributeTable(this.netAttrMapping);
        }
        return this.mergeNetAttrTbl;
    }

    private JCheckBox getIdMappingCkb() {
        if (this.idMappingCkb == null) {
            this.idMappingCkb = new JCheckBox("Map IDs between the matching columns");
            this.idMappingCkb.setVisible(false);
        }
        return this.idMappingCkb;
    }

    private JTabbedPane getMergeAttrTp() {
        if (this.mergeAttrTp == null) {
            this.mergeAttrTp = new JTabbedPane();
            this.mergeAttrTp.setTabPlacement(3);
            this.mergeAttrTp.setMinimumSize(new Dimension(450, 150));
            this.mergeAttrTp.setPreferredSize(new Dimension(450, 200));
            this.mergeAttrTp.addTab("Node", this.getMergeNodeAttrPnl());
            this.mergeAttrTp.addTab("Edge", this.getMergeEdgeAttrPnl());
            this.mergeAttrTp.addTab("Network", this.getMergeNetAttrPnl());
        }
        return this.mergeAttrTp;
    }

    private JPanel getMergeNodeAttrPnl() {
        if (this.mergeNodeAttrPnl == null) {
            this.mergeNodeAttrPnl = new JPanel();
            this.mergeNodeAttrPnl.setLayout(new BoxLayout(this.mergeNodeAttrPnl, 2));
            JScrollPane mergeNodeAttributeScrollPane = new JScrollPane();
            mergeNodeAttributeScrollPane.setViewportView(this.getMergeNodeAttrTbl());
            this.mergeNodeAttrPnl.add(mergeNodeAttributeScrollPane);
        }
        return this.mergeNodeAttrPnl;
    }

    private JPanel getMergeEdgeAttrPnl() {
        if (this.mergeEdgeAttrPnl == null) {
            this.mergeEdgeAttrPnl = new JPanel();
            this.mergeEdgeAttrPnl.setLayout(new BoxLayout(this.mergeEdgeAttrPnl, 2));
            JScrollPane mergeEdgeAttributeScrollPane = new JScrollPane();
            mergeEdgeAttributeScrollPane.setViewportView(this.getMergeEdgeAttrTbl());
            this.mergeEdgeAttrPnl.add(mergeEdgeAttributeScrollPane);
        }
        return this.mergeEdgeAttrPnl;
    }

    private JPanel getMergeNetAttrPnl() {
        if (this.mergeNetAttrPnl == null) {
            this.mergeNetAttrPnl = new JPanel();
            this.mergeNetAttrPnl.setLayout(new BoxLayout(this.mergeNetAttrPnl, 2));
            JScrollPane mergeNetAttributeScrollPane = new JScrollPane();
            mergeNetAttributeScrollPane.setViewportView(this.getMergeNetAttrTbl());
            this.mergeNetAttrPnl.add(mergeNetAttributeScrollPane);
        }
        return this.mergeNetAttrPnl;
    }

    private JCheckBox getInNetMergeCkb() {
        if (this.inNetMergeCkb == null) {
            this.inNetMergeCkb = new JCheckBox("Enable merging nodes/edges in the same network");
            this.inNetMergeCkb.setSelected(true);
            this.inNetMergeCkb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NetworkMergeDialog.this.updateOKButton();
                }
            });
        }
        return this.inNetMergeCkb;
    }

    private JCheckBox getNodesOnly() {
        if (this.NodesOnly == null) {
            this.NodesOnly = new JCheckBox("Merge only nodes and ignore edges");
            this.NodesOnly.setSelected(false);
            this.NodesOnly.setEnabled(false);
        }
        return this.NodesOnly;
    }

    private JPanel getButtonPnl() {
        if (this.buttonPnl == null) {
            this.buttonPnl = LookAndFeelUtil.createOkCancelPanel((JButton)this.getOkBtn(), (JButton)this.getCancelBtn());
            this.buttonPnl.setDoubleBuffered(false);
        }
        return this.buttonPnl;
    }

    private JButton getOkBtn() {
        if (this.okBtn == null) {
            this.okBtn = new JButton(new AbstractAction("Merge"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (NetworkMergeDialog.this.idMappingCkb.isSelected()) {
                        // empty if block
                    }
                    String netName = NetworkMergeDialog.this.cnn.getSuggestedNetworkTitle(NetworkMergeDialog.this.getMergeNodeAttrTbl().getMergedNetworkName());
                    AttributeConflictCollectorImpl conflictCollector = new AttributeConflictCollectorImpl();
                    NetworkMergeTask nmTask = new NetworkMergeTask(NetworkMergeDialog.this.serviceRegistrar, netName, NetworkMergeDialog.this.matchingAttr, NetworkMergeDialog.this.nodeAttrMapping, NetworkMergeDialog.this.edgeAttrMapping, NetworkMergeDialog.this.netAttrMapping, NetworkMergeDialog.this.selectedNetData.getNetworkList(), NetworkMergeDialog.this.getOperation(), NetworkMergeDialog.this.getDifference1Btn().isSelected(), conflictCollector, NetworkMergeDialog.this.getInNetMergeCkb().isSelected(), NetworkMergeDialog.this.getNodesOnly().isSelected());
                    TaskIterator ti = new TaskIterator(new Task[]{nmTask});
                    NetworkMergeDialog.this.taskManager.execute(ti);
                    NetworkMergeDialog.this.setVisible(false);
                    NetworkMergeDialog.this.dispose();
                }
            });
            this.okBtn.getAction().setEnabled(false);
        }
        return this.okBtn;
    }

    private JButton getCancelBtn() {
        if (this.cancelBtn == null) {
            this.cancelBtn = new JButton(new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NetworkMergeDialog.this.setVisible(false);
                    NetworkMergeDialog.this.dispose();
                }
            });
        }
        return this.cancelBtn;
    }

    private void addRemoveAttributeMapping(CyNetwork network, boolean isAdd) {
        if (isAdd) {
            this.nodeAttrMapping.addNetwork(network, network.getDefaultNodeTable());
            this.edgeAttrMapping.addNetwork(network, network.getDefaultEdgeTable());
            this.netAttrMapping.addNetwork(network, network.getDefaultNetworkTable());
            this.matchingAttr.addNetwork(network);
        } else {
            this.nodeAttrMapping.removeNetwork(network);
            this.edgeAttrMapping.removeNetwork(network);
            this.netAttrMapping.removeNetwork(network);
            this.matchingAttr.removeNetwork(network);
        }
    }

    private void updateOKButton() {
        int n;
        int n2 = n = !this.getAdvancedOptionsPnl().isCollapsed() && this.getInNetMergeCkb().isSelected() && this.getOperation() == NetworkMerge.Operation.UNION ? 1 : 2;
        if (this.selectedNetData.getSize() < n) {
            this.getOkBtn().setToolTipText("Select at least " + n + " networks to merge");
            this.getOkBtn().getAction().setEnabled(false);
        } else {
            this.getOkBtn().setToolTipText(null);
            this.getOkBtn().getAction().setEnabled(true);
        }
    }

    private void updateUpDownButtons() {
        boolean diff = this.selectedOperation == NetworkMerge.Operation.DIFFERENCE;
        int imin = this.getSelectedNetLs().getMinSelectionIndex();
        int imax = this.getSelectedNetLs().getMaxSelectionIndex();
        this.getMoveUpBtn().setEnabled(diff && 0 < imin && imax <= this.selectedNetData.getSize() - 1);
        this.getMoveDownBtn().setEnabled(diff && 0 <= imin && imax < this.selectedNetData.getSize() - 1);
    }

    private void updateDifferencePanel() {
        this.getDifferencePnl().setVisible(this.selectedOperation == NetworkMerge.Operation.DIFFERENCE);
        this.getNodesOnly().setEnabled(this.selectedOperation == NetworkMerge.Operation.INTERSECTION || this.selectedOperation == NetworkMerge.Operation.DIFFERENCE);
        this.pack();
    }

    private void updateOperationPanel() {
        this.getNodesOnly().setEnabled(this.selectedOperation == NetworkMerge.Operation.INTERSECTION || this.selectedOperation == NetworkMerge.Operation.DIFFERENCE);
        this.pack();
    }

    private void updateAttributeTable() {
        this.getMatchNodeTbl().fireTableStructureChanged();
    }

    private void updateMergeAttributeTable() {
        this.getMergeNodeAttrTbl().fireTableStructureChanged();
        this.getMergeEdgeAttrTbl().fireTableStructureChanged();
        this.getMergeNetAttrTbl().fireTableStructureChanged();
    }

    private NetworkMerge.Operation getOperation() {
        return this.selectedOperation;
    }
}

